/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting;

import java.util.Collection;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCurveFitter {
    public double[] fit(Collection<WeightedObservedPoint> collection) {
        return this.getOptimizer().optimize(this.getProblem(collection)).getPoint().toArray();
    }

    protected LeastSquaresOptimizer getOptimizer() {
        return new LevenbergMarquardtOptimizer();
    }

    protected abstract LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TheoreticalValuesFunction {
        private final ParametricUnivariateFunction f;
        private final double[] points;

        public TheoreticalValuesFunction(ParametricUnivariateFunction parametricUnivariateFunction, Collection<WeightedObservedPoint> collection) {
            this.f = parametricUnivariateFunction;
            int n = collection.size();
            this.points = new double[n];
            int n2 = 0;
            for (WeightedObservedPoint weightedObservedPoint : collection) {
                this.points[n2++] = weightedObservedPoint.getX();
            }
        }

        public MultivariateVectorFunction getModelFunction() {
            return new MultivariateVectorFunction(){

                public double[] value(double[] dArray) {
                    int n = TheoreticalValuesFunction.this.points.length;
                    double[] dArray2 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = TheoreticalValuesFunction.this.f.value(TheoreticalValuesFunction.this.points[i], dArray);
                    }
                    return dArray2;
                }
            };
        }

        public MultivariateMatrixFunction getModelFunctionJacobian() {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] dArray) {
                    int n = TheoreticalValuesFunction.this.points.length;
                    double[][] dArrayArray = new double[n][];
                    for (int i = 0; i < n; ++i) {
                        dArrayArray[i] = TheoreticalValuesFunction.this.f.gradient(TheoreticalValuesFunction.this.points[i], dArray);
                    }
                    return dArrayArray;
                }
            };
        }
    }
}

