/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussNewtonOptimizer
implements LeastSquaresOptimizer {
    private static final double SINGULARITY_THRESHOLD = 1.0E-11;
    private final Decomposition decomposition;

    public GaussNewtonOptimizer() {
        this(Decomposition.QR);
    }

    public GaussNewtonOptimizer(Decomposition decomposition) {
        this.decomposition = decomposition;
    }

    public Decomposition getDecomposition() {
        return this.decomposition;
    }

    public GaussNewtonOptimizer withDecomposition(Decomposition decomposition) {
        return new GaussNewtonOptimizer(decomposition);
    }

    @Override
    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem leastSquaresProblem) {
        Incrementor incrementor = leastSquaresProblem.getEvaluationCounter();
        Incrementor incrementor2 = leastSquaresProblem.getIterationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker = leastSquaresProblem.getConvergenceChecker();
        if (convergenceChecker == null) {
            throw new NullArgumentException();
        }
        RealVector realVector = leastSquaresProblem.getStart();
        LeastSquaresProblem.Evaluation evaluation = null;
        while (true) {
            incrementor2.incrementCount();
            LeastSquaresProblem.Evaluation evaluation2 = evaluation;
            incrementor.incrementCount();
            evaluation = leastSquaresProblem.evaluate(realVector);
            RealVector realVector2 = evaluation.getResiduals();
            RealMatrix realMatrix = evaluation.getJacobian();
            realVector = evaluation.getPoint();
            if (evaluation2 != null && convergenceChecker.converged(incrementor2.getCount(), evaluation2, evaluation)) {
                return new OptimumImpl(evaluation, incrementor.getCount(), incrementor2.getCount());
            }
            RealVector realVector3 = this.decomposition.solve(realMatrix, realVector2);
            realVector = realVector.add(realVector3);
        }
    }

    public String toString() {
        return "GaussNewtonOptimizer{decomposition=" + (Object)((Object)this.decomposition) + '}';
    }

    private static Pair<RealMatrix, RealVector> computeNormalMatrix(RealMatrix realMatrix, RealVector realVector) {
        int n;
        int n2;
        int n3 = realMatrix.getRowDimension();
        int n4 = realMatrix.getColumnDimension();
        RealMatrix realMatrix2 = MatrixUtils.createRealMatrix(n4, n4);
        ArrayRealVector arrayRealVector = new ArrayRealVector(n4);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                ((RealVector)arrayRealVector).setEntry(n, ((RealVector)arrayRealVector).getEntry(n) + realVector.getEntry(n2) * realMatrix.getEntry(n2, n));
            }
            for (n = 0; n < n4; ++n) {
                for (int i = n; i < n4; ++i) {
                    realMatrix2.setEntry(n, i, realMatrix2.getEntry(n, i) + realMatrix.getEntry(n2, n) * realMatrix.getEntry(n2, i));
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n2; ++n) {
                realMatrix2.setEntry(n2, n, realMatrix2.getEntry(n, n2));
            }
        }
        return new Pair<RealMatrix, RealVector>(realMatrix2, arrayRealVector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Decomposition {
        LU{

            protected RealVector solve(RealMatrix realMatrix, RealVector realVector) {
                try {
                    Pair pair = GaussNewtonOptimizer.computeNormalMatrix(realMatrix, realVector);
                    RealMatrix realMatrix2 = (RealMatrix)pair.getFirst();
                    RealVector realVector2 = (RealVector)pair.getSecond();
                    return new LUDecomposition(realMatrix2, 1.0E-11).getSolver().solve(realVector2);
                }
                catch (SingularMatrixException singularMatrixException) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, singularMatrixException);
                }
            }
        }
        ,
        QR{

            protected RealVector solve(RealMatrix realMatrix, RealVector realVector) {
                try {
                    return new QRDecomposition(realMatrix, 1.0E-11).getSolver().solve(realVector);
                }
                catch (SingularMatrixException singularMatrixException) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, singularMatrixException);
                }
            }
        }
        ,
        CHOLESKY{

            protected RealVector solve(RealMatrix realMatrix, RealVector realVector) {
                try {
                    Pair pair = GaussNewtonOptimizer.computeNormalMatrix(realMatrix, realVector);
                    RealMatrix realMatrix2 = (RealMatrix)pair.getFirst();
                    RealVector realVector2 = (RealVector)pair.getSecond();
                    return new CholeskyDecomposition(realMatrix2, 1.0E-11, 1.0E-11).getSolver().solve(realVector2);
                }
                catch (NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, nonPositiveDefiniteMatrixException);
                }
            }
        }
        ,
        SVD{

            protected RealVector solve(RealMatrix realMatrix, RealVector realVector) {
                return new SingularValueDecomposition(realMatrix).getSolver().solve(realVector);
            }
        };


        protected abstract RealVector solve(RealMatrix var1, RealVector var2);
    }
}

