/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fraction;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.AbstractFormat;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.ProperBigFractionFormat;

public class BigFractionFormat
extends AbstractFormat
implements Serializable {
    private static final long serialVersionUID = -2932167925527338976L;

    public BigFractionFormat() {
    }

    public BigFractionFormat(NumberFormat numberFormat) {
        super(numberFormat);
    }

    public BigFractionFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        super(numberFormat, numberFormat2);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static String formatBigFraction(BigFraction bigFraction) {
        return BigFractionFormat.getImproperInstance().format(bigFraction);
    }

    public static BigFractionFormat getImproperInstance() {
        return BigFractionFormat.getImproperInstance(Locale.getDefault());
    }

    public static BigFractionFormat getImproperInstance(Locale locale) {
        return new BigFractionFormat(BigFractionFormat.getDefaultNumberFormat(locale));
    }

    public static BigFractionFormat getProperInstance() {
        return BigFractionFormat.getProperInstance(Locale.getDefault());
    }

    public static BigFractionFormat getProperInstance(Locale locale) {
        return new ProperBigFractionFormat(BigFractionFormat.getDefaultNumberFormat(locale));
    }

    public StringBuffer format(BigFraction bigFraction, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        this.getNumeratorFormat().format(bigFraction.getNumerator(), stringBuffer, fieldPosition);
        stringBuffer.append(" / ");
        this.getDenominatorFormat().format(bigFraction.getDenominator(), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2;
        if (object instanceof BigFraction) {
            stringBuffer2 = this.format((BigFraction)object, stringBuffer, fieldPosition);
        } else if (object instanceof BigInteger) {
            stringBuffer2 = this.format(new BigFraction((BigInteger)object), stringBuffer, fieldPosition);
        } else if (object instanceof Number) {
            stringBuffer2 = this.format(new BigFraction(((Number)object).doubleValue()), stringBuffer, fieldPosition);
        } else {
            throw new MathIllegalArgumentException(LocalizedFormats.CANNOT_FORMAT_OBJECT_TO_FRACTION, new Object[0]);
        }
        return stringBuffer2;
    }

    public BigFraction parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        BigFraction bigFraction = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), BigFraction.class);
        }
        return bigFraction;
    }

    public BigFraction parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        BigFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        BigInteger bigInteger = this.parseNextBigInteger(string, parsePosition);
        if (bigInteger == null) {
            parsePosition.setIndex(n);
            return null;
        }
        int n2 = parsePosition.getIndex();
        char c = BigFractionFormat.parseNextCharacter(string, parsePosition);
        switch (c) {
            case '\u0000': {
                return new BigFraction(bigInteger);
            }
            case '/': {
                break;
            }
            default: {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
        BigFractionFormat.parseAndIgnoreWhitespace(string, parsePosition);
        BigInteger bigInteger2 = this.parseNextBigInteger(string, parsePosition);
        if (bigInteger2 == null) {
            parsePosition.setIndex(n);
            return null;
        }
        return new BigFraction(bigInteger, bigInteger2);
    }

    protected BigInteger parseNextBigInteger(String string, ParsePosition parsePosition) {
        int n;
        int n2 = parsePosition.getIndex();
        int n3 = n = string.charAt(n2) == '-' ? n2 + 1 : n2;
        while (n < string.length() && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        try {
            BigInteger bigInteger = new BigInteger(string.substring(n2, n));
            parsePosition.setIndex(n);
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            parsePosition.setErrorIndex(n2);
            return null;
        }
    }
}

