/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.genetics.Chromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListChromosome<T>
extends Chromosome {
    private final List<T> representation;

    public AbstractListChromosome(List<T> list) {
        this(list, true);
    }

    public AbstractListChromosome(T[] TArray) {
        this(Arrays.asList(TArray));
    }

    public AbstractListChromosome(List<T> arrayList, boolean bl) {
        this.checkValidity(arrayList);
        this.representation = Collections.unmodifiableList(bl ? new ArrayList(arrayList) : arrayList);
    }

    protected abstract void checkValidity(List<T> var1);

    protected List<T> getRepresentation() {
        return this.representation;
    }

    public int getLength() {
        return this.getRepresentation().size();
    }

    public abstract AbstractListChromosome<T> newFixedLengthChromosome(List<T> var1);

    public String toString() {
        return String.format("(f=%s %s)", this.getFitness(), this.getRepresentation());
    }
}

