/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.InvalidRepresentationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryChromosome
extends AbstractListChromosome<Integer> {
    public BinaryChromosome(List<Integer> list) {
        super(list);
    }

    public BinaryChromosome(Integer[] integerArray) {
        super(integerArray);
    }

    @Override
    protected void checkValidity(List<Integer> list) {
        for (int n : list) {
            if (n >= 0 && n <= 1) continue;
            throw new InvalidRepresentationException(LocalizedFormats.INVALID_BINARY_DIGIT, n);
        }
    }

    public static List<Integer> randomBinaryRepresentation(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(GeneticAlgorithm.getRandomGenerator().nextInt(2));
        }
        return arrayList;
    }

    @Override
    protected boolean isSame(Chromosome chromosome) {
        if (!(chromosome instanceof BinaryChromosome)) {
            return false;
        }
        BinaryChromosome binaryChromosome = (BinaryChromosome)chromosome;
        if (this.getLength() != binaryChromosome.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getRepresentation().size(); ++i) {
            if (((Integer)this.getRepresentation().get(i)).equals(binaryChromosome.getRepresentation().get(i))) continue;
            return false;
        }
        return true;
    }
}

