/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedCrossover<T>
implements CrossoverPolicy {
    @Override
    public ChromosomePair crossover(Chromosome chromosome, Chromosome chromosome2) {
        if (!(chromosome instanceof AbstractListChromosome) || !(chromosome2 instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.mate((AbstractListChromosome)chromosome, (AbstractListChromosome)chromosome2);
    }

    protected ChromosomePair mate(AbstractListChromosome<T> abstractListChromosome, AbstractListChromosome<T> abstractListChromosome2) {
        int n;
        int n2 = abstractListChromosome.getLength();
        if (n2 != abstractListChromosome2.getLength()) {
            throw new DimensionMismatchException(abstractListChromosome2.getLength(), n2);
        }
        List<T> list = abstractListChromosome.getRepresentation();
        List<T> list2 = abstractListChromosome2.getRepresentation();
        ArrayList<T> arrayList = new ArrayList<T>(n2);
        ArrayList<T> arrayList2 = new ArrayList<T>(n2);
        HashSet<T> hashSet = new HashSet<T>(n2);
        HashSet<T> hashSet2 = new HashSet<T>(n2);
        RandomGenerator randomGenerator = GeneticAlgorithm.getRandomGenerator();
        int n3 = randomGenerator.nextInt(n2);
        while (n3 == (n = randomGenerator.nextInt(n2))) {
        }
        int n4 = FastMath.min(n3, n);
        int n5 = FastMath.max(n3, n);
        arrayList.addAll(list.subList(n4, n5 + 1));
        hashSet.addAll(arrayList);
        arrayList2.addAll(list2.subList(n4, n5 + 1));
        hashSet2.addAll(arrayList2);
        for (int i = 1; i <= n2; ++i) {
            int n6 = (n5 + i) % n2;
            T t = list.get(n6);
            T t2 = list2.get(n6);
            if (!hashSet.contains(t2)) {
                arrayList.add(t2);
                hashSet.add(t2);
            }
            if (hashSet2.contains(t)) continue;
            arrayList2.add(t);
            hashSet2.add(t);
        }
        Collections.rotate(arrayList, n4);
        Collections.rotate(arrayList2, n4);
        return new ChromosomePair(abstractListChromosome.newFixedLengthChromosome(arrayList), abstractListChromosome2.newFixedLengthChromosome(arrayList2));
    }
}

