/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.InvalidRepresentationException;
import org.apache.commons.math3.genetics.PermutationChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomKey<T>
extends AbstractListChromosome<Double>
implements PermutationChromosome<T> {
    private final List<Double> sortedRepresentation;
    private final List<Integer> baseSeqPermutation;

    public RandomKey(List<Double> list) {
        super(list);
        ArrayList arrayList = new ArrayList(this.getRepresentation());
        Collections.sort(arrayList);
        this.sortedRepresentation = Collections.unmodifiableList(arrayList);
        this.baseSeqPermutation = Collections.unmodifiableList(RandomKey.decodeGeneric(RandomKey.baseSequence(this.getLength()), this.getRepresentation(), this.sortedRepresentation));
    }

    public RandomKey(Double[] doubleArray) {
        this(Arrays.asList(doubleArray));
    }

    @Override
    public List<T> decode(List<T> list) {
        return RandomKey.decodeGeneric(list, this.getRepresentation(), this.sortedRepresentation);
    }

    private static <S> List<S> decodeGeneric(List<S> list, List<Double> list2, List<Double> list3) {
        int n = list.size();
        if (list2.size() != n) {
            throw new DimensionMismatchException(list2.size(), n);
        }
        if (list3.size() != n) {
            throw new DimensionMismatchException(list3.size(), n);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(list2);
        ArrayList<S> arrayList2 = new ArrayList<S>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = arrayList.indexOf(list3.get(i));
            arrayList2.add(list.get(n2));
            arrayList.set(n2, null);
        }
        return arrayList2;
    }

    @Override
    protected boolean isSame(Chromosome chromosome) {
        if (!(chromosome instanceof RandomKey)) {
            return false;
        }
        RandomKey randomKey = (RandomKey)chromosome;
        if (this.getLength() != randomKey.getLength()) {
            return false;
        }
        List<Integer> list = this.baseSeqPermutation;
        List<Integer> list2 = randomKey.baseSeqPermutation;
        for (int i = 0; i < this.getLength(); ++i) {
            if (list.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void checkValidity(List<Double> list) {
        for (double d : list) {
            if (!(d < 0.0) && !(d > 1.0)) continue;
            throw new InvalidRepresentationException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, d, 0, 1);
        }
    }

    public static final List<Double> randomPermutation(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(GeneticAlgorithm.getRandomGenerator().nextDouble());
        }
        return arrayList;
    }

    public static final List<Double> identityPermutation(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((double)i / (double)n);
        }
        return arrayList;
    }

    public static <S> List<Double> comparatorPermutation(List<S> list, Comparator<S> comparator) {
        ArrayList<S> arrayList = new ArrayList<S>(list);
        Collections.sort(arrayList, comparator);
        return RandomKey.inducedPermutation(list, arrayList);
    }

    public static <S> List<Double> inducedPermutation(List<S> list, List<S> list2) {
        if (list.size() != list2.size()) {
            throw new DimensionMismatchException(list2.size(), list.size());
        }
        int n = list.size();
        ArrayList<S> arrayList = new ArrayList<S>(list);
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = arrayList.indexOf(list2.get(i));
            if (n2 == -1) {
                throw new MathIllegalArgumentException(LocalizedFormats.DIFFERENT_ORIG_AND_PERMUTED_DATA, new Object[0]);
            }
            doubleArray[n2] = (double)i / (double)n;
            arrayList.set(n2, null);
        }
        return Arrays.asList(doubleArray);
    }

    @Override
    public String toString() {
        return String.format("(f=%s pi=(%s))", this.getFitness(), this.baseSeqPermutation);
    }

    private static List<Integer> baseSequence(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }
}

