/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.random.RandomGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniformCrossover<T>
implements CrossoverPolicy {
    private final double ratio;

    public UniformCrossover(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.CROSSOVER_RATE, (Number)d, 0.0, 1.0);
        }
        this.ratio = d;
    }

    public double getRatio() {
        return this.ratio;
    }

    @Override
    public ChromosomePair crossover(Chromosome chromosome, Chromosome chromosome2) {
        if (!(chromosome instanceof AbstractListChromosome) || !(chromosome2 instanceof AbstractListChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_FIXED_LENGTH_CHROMOSOME, new Object[0]);
        }
        return this.mate((AbstractListChromosome)chromosome, (AbstractListChromosome)chromosome2);
    }

    private ChromosomePair mate(AbstractListChromosome<T> abstractListChromosome, AbstractListChromosome<T> abstractListChromosome2) {
        int n = abstractListChromosome.getLength();
        if (n != abstractListChromosome2.getLength()) {
            throw new DimensionMismatchException(abstractListChromosome2.getLength(), n);
        }
        List<T> list = abstractListChromosome.getRepresentation();
        List<T> list2 = abstractListChromosome2.getRepresentation();
        ArrayList<T> arrayList = new ArrayList<T>(n);
        ArrayList<T> arrayList2 = new ArrayList<T>(n);
        RandomGenerator randomGenerator = GeneticAlgorithm.getRandomGenerator();
        for (int i = 0; i < n; ++i) {
            if (randomGenerator.nextDouble() < this.ratio) {
                arrayList.add(list2.get(i));
                arrayList2.add(list.get(i));
                continue;
            }
            arrayList.add(list.get(i));
            arrayList2.add(list2.get(i));
        }
        return new ChromosomePair(abstractListChromosome.newFixedLengthChromosome(arrayList), abstractListChromosome2.newFixedLengthChromosome(arrayList2));
    }
}

