/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.enclosing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.enclosing.Encloser;
import org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import org.apache.commons.math3.geometry.enclosing.SupportBallGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WelzlEncloser<S extends Space, P extends Point<S>>
implements Encloser<S, P> {
    private final double tolerance;
    private final SupportBallGenerator<S, P> generator;

    public WelzlEncloser(double d, SupportBallGenerator<S, P> supportBallGenerator) {
        this.tolerance = d;
        this.generator = supportBallGenerator;
    }

    @Override
    public EnclosingBall<S, P> enclose(Iterable<P> iterable) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return this.generator.ballOnSupport(new ArrayList());
        }
        return this.pivotingBall(iterable);
    }

    private EnclosingBall<S, P> pivotingBall(Iterable<P> iterable) {
        Point point = (Point)iterable.iterator().next();
        ArrayList<Point<Object>> arrayList = new ArrayList<Point<Object>>(point.getSpace().getDimension() + 1);
        ArrayList<P> arrayList2 = new ArrayList<P>(point.getSpace().getDimension() + 1);
        arrayList.add(point);
        EnclosingBall enclosingBall = this.moveToFrontBall(arrayList, arrayList.size(), arrayList2);
        P p;
        while (!enclosingBall.contains(p = this.selectFarthest(iterable, enclosingBall), this.tolerance)) {
            arrayList2.clear();
            arrayList2.add(p);
            EnclosingBall enclosingBall2 = enclosingBall;
            enclosingBall = this.moveToFrontBall(arrayList, arrayList.size(), arrayList2);
            if (enclosingBall.getRadius() < enclosingBall2.getRadius()) {
                throw new MathInternalError();
            }
            arrayList.add(0, (Point<Object>)p);
            arrayList.subList(enclosingBall.getSupportSize(), arrayList.size()).clear();
        }
        return enclosingBall;
    }

    private EnclosingBall<S, P> moveToFrontBall(List<P> list, int n, List<P> list2) {
        EnclosingBall<S, Point> enclosingBall = this.generator.ballOnSupport(list2);
        if (enclosingBall.getSupportSize() <= enclosingBall.getCenter().getSpace().getDimension()) {
            for (int i = 0; i < n; ++i) {
                Point point = (Point)list.get(i);
                if (enclosingBall.contains(point, this.tolerance)) continue;
                list2.add(point);
                enclosingBall = this.moveToFrontBall(list, i, list2);
                list2.remove(list2.size() - 1);
                for (int j = i; j > 0; --j) {
                    list.set(j, list.get(j - 1));
                }
                list.set(0, point);
            }
        }
        return enclosingBall;
    }

    public P selectFarthest(Iterable<P> iterable, EnclosingBall<S, P> enclosingBall) {
        P p = enclosingBall.getCenter();
        Point point = null;
        double d = -1.0;
        for (Point point2 : iterable) {
            double d2 = point2.distance(p);
            if (!(d2 > d)) continue;
            point = point2;
            d = d2;
        }
        return (P)point;
    }
}

