/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.oned;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.math3.geometry.euclidean.oned.SubOrientedPoint;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.partitioning.AbstractRegion;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalsSet
extends AbstractRegion<Euclidean1D, Euclidean1D>
implements Iterable<double[]> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;

    public IntervalsSet(double d) {
        super(d);
    }

    public IntervalsSet(double d, double d2, double d3) {
        super(IntervalsSet.buildTree(d, d2, d3), d3);
    }

    public IntervalsSet(BSPTree<Euclidean1D> bSPTree, double d) {
        super(bSPTree, d);
    }

    public IntervalsSet(Collection<SubHyperplane<Euclidean1D>> collection, double d) {
        super(collection, d);
    }

    @Deprecated
    public IntervalsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public IntervalsSet(double d, double d2) {
        this(d, d2, 1.0E-10);
    }

    @Deprecated
    public IntervalsSet(BSPTree<Euclidean1D> bSPTree) {
        this(bSPTree, 1.0E-10);
    }

    @Deprecated
    public IntervalsSet(Collection<SubHyperplane<Euclidean1D>> collection) {
        this(collection, 1.0E-10);
    }

    private static BSPTree<Euclidean1D> buildTree(double d, double d2, double d3) {
        if (Double.isInfinite(d) && d < 0.0) {
            if (Double.isInfinite(d2) && d2 > 0.0) {
                return new BSPTree<Euclidean1D>(Boolean.TRUE);
            }
            SubOrientedPoint subOrientedPoint = new OrientedPoint(new Vector1D(d2), true, d3).wholeHyperplane();
            return new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null);
        }
        SubOrientedPoint subOrientedPoint = new OrientedPoint(new Vector1D(d), false, d3).wholeHyperplane();
        if (Double.isInfinite(d2) && d2 > 0.0) {
            return new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null);
        }
        SubOrientedPoint subOrientedPoint2 = new OrientedPoint(new Vector1D(d2), true, d3).wholeHyperplane();
        return new BSPTree<Euclidean1D>(subOrientedPoint, new BSPTree(Boolean.FALSE), new BSPTree<Euclidean1D>(subOrientedPoint2, new BSPTree(Boolean.FALSE), new BSPTree(Boolean.TRUE), null), null);
    }

    public IntervalsSet buildNew(BSPTree<Euclidean1D> bSPTree) {
        return new IntervalsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        if (this.getTree(false).getCut() == null) {
            this.setBarycenter(Vector1D.NaN);
            this.setSize((Boolean)this.getTree(false).getAttribute() != false ? Double.POSITIVE_INFINITY : 0.0);
        } else {
            double d = 0.0;
            double d2 = 0.0;
            for (Interval interval : this.asList()) {
                d += interval.getSize();
                d2 += interval.getSize() * interval.getBarycenter();
            }
            this.setSize(d);
            if (Double.isInfinite(d)) {
                this.setBarycenter(Vector1D.NaN);
            } else if (d >= Precision.SAFE_MIN) {
                this.setBarycenter(new Vector1D(d2 / d));
            } else {
                this.setBarycenter(((OrientedPoint)this.getTree(false).getCut().getHyperplane()).getLocation());
            }
        }
    }

    public double getInf() {
        BSPTree bSPTree = this.getTree(false);
        double d = Double.POSITIVE_INFINITY;
        while (bSPTree.getCut() != null) {
            OrientedPoint orientedPoint = (OrientedPoint)bSPTree.getCut().getHyperplane();
            d = orientedPoint.getLocation().getX();
            bSPTree = orientedPoint.isDirect() ? bSPTree.getMinus() : bSPTree.getPlus();
        }
        return (Boolean)bSPTree.getAttribute() != false ? Double.NEGATIVE_INFINITY : d;
    }

    public double getSup() {
        BSPTree bSPTree = this.getTree(false);
        double d = Double.NEGATIVE_INFINITY;
        while (bSPTree.getCut() != null) {
            OrientedPoint orientedPoint = (OrientedPoint)bSPTree.getCut().getHyperplane();
            d = orientedPoint.getLocation().getX();
            bSPTree = orientedPoint.isDirect() ? bSPTree.getPlus() : bSPTree.getMinus();
        }
        return (Boolean)bSPTree.getAttribute() != false ? Double.POSITIVE_INFINITY : d;
    }

    @Override
    public BoundaryProjection<Euclidean1D> projectToBoundary(Point<Euclidean1D> point) {
        double d = ((Vector1D)point).getX();
        double d2 = Double.NEGATIVE_INFINITY;
        for (double[] dArray : this) {
            if (d < dArray[0]) {
                double d3 = d - d2;
                double d4 = dArray[0] - d;
                if (d3 < d4) {
                    return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(d2), d3);
                }
                return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(dArray[0]), d4);
            }
            if (d <= dArray[1]) {
                double d5 = dArray[0] - d;
                double d6 = d - dArray[1];
                if (d5 < d6) {
                    return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(dArray[1]), d6);
                }
                return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(dArray[0]), d5);
            }
            d2 = dArray[1];
        }
        return new BoundaryProjection<Euclidean1D>(point, this.finiteOrNullPoint(d2), d - d2);
    }

    private Vector1D finiteOrNullPoint(double d) {
        return Double.isInfinite(d) ? null : new Vector1D(d);
    }

    public List<Interval> asList() {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        for (double[] dArray : this) {
            arrayList.add(new Interval(dArray[0], dArray[1]));
        }
        return arrayList;
    }

    private BSPTree<Euclidean1D> getFirstLeaf(BSPTree<Euclidean1D> bSPTree) {
        if (bSPTree.getCut() == null) {
            return bSPTree;
        }
        BSPTree<Euclidean1D> bSPTree2 = null;
        BSPTree<Euclidean1D> bSPTree3 = bSPTree;
        while (bSPTree3 != null) {
            bSPTree2 = bSPTree3;
            bSPTree3 = this.previousInternalNode(bSPTree3);
        }
        return this.leafBefore(bSPTree2);
    }

    private BSPTree<Euclidean1D> getFirstIntervalBoundary() {
        BSPTree<Euclidean1D> bSPTree = this.getTree(false);
        if (bSPTree.getCut() == null) {
            return null;
        }
        bSPTree = this.getFirstLeaf(bSPTree).getParent();
        while (bSPTree != null && !this.isIntervalStart(bSPTree) && !this.isIntervalEnd(bSPTree)) {
            bSPTree = this.nextInternalNode(bSPTree);
        }
        return bSPTree;
    }

    private boolean isIntervalStart(BSPTree<Euclidean1D> bSPTree) {
        if (((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() != false;
    }

    private boolean isIntervalEnd(BSPTree<Euclidean1D> bSPTree) {
        if (!((Boolean)this.leafBefore(bSPTree).getAttribute()).booleanValue()) {
            return false;
        }
        return (Boolean)this.leafAfter(bSPTree).getAttribute() == false;
    }

    private BSPTree<Euclidean1D> nextInternalNode(BSPTree<Euclidean1D> bSPTree) {
        if (this.childAfter(bSPTree).getCut() != null) {
            return this.leafAfter(bSPTree).getParent();
        }
        while (this.isAfterParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Euclidean1D> previousInternalNode(BSPTree<Euclidean1D> bSPTree) {
        if (this.childBefore(bSPTree).getCut() != null) {
            return this.leafBefore(bSPTree).getParent();
        }
        while (this.isBeforeParent(bSPTree)) {
            bSPTree = bSPTree.getParent();
        }
        return bSPTree.getParent();
    }

    private BSPTree<Euclidean1D> leafBefore(BSPTree<Euclidean1D> bSPTree) {
        bSPTree = this.childBefore(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childAfter(bSPTree);
        }
        return bSPTree;
    }

    private BSPTree<Euclidean1D> leafAfter(BSPTree<Euclidean1D> bSPTree) {
        bSPTree = this.childAfter(bSPTree);
        while (bSPTree.getCut() != null) {
            bSPTree = this.childBefore(bSPTree);
        }
        return bSPTree;
    }

    private boolean isBeforeParent(BSPTree<Euclidean1D> bSPTree) {
        BSPTree<Euclidean1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childBefore(bSPTree2);
    }

    private boolean isAfterParent(BSPTree<Euclidean1D> bSPTree) {
        BSPTree<Euclidean1D> bSPTree2 = bSPTree.getParent();
        if (bSPTree2 == null) {
            return false;
        }
        return bSPTree == this.childAfter(bSPTree2);
    }

    private BSPTree<Euclidean1D> childBefore(BSPTree<Euclidean1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getMinus();
        }
        return bSPTree.getPlus();
    }

    private BSPTree<Euclidean1D> childAfter(BSPTree<Euclidean1D> bSPTree) {
        if (this.isDirect(bSPTree)) {
            return bSPTree.getPlus();
        }
        return bSPTree.getMinus();
    }

    private boolean isDirect(BSPTree<Euclidean1D> bSPTree) {
        return ((OrientedPoint)bSPTree.getCut().getHyperplane()).isDirect();
    }

    private double getAngle(BSPTree<Euclidean1D> bSPTree) {
        return ((OrientedPoint)bSPTree.getCut().getHyperplane()).getLocation().getX();
    }

    @Override
    public Iterator<double[]> iterator() {
        return new SubIntervalsIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubIntervalsIterator
    implements Iterator<double[]> {
        private BSPTree<Euclidean1D> current;
        private double[] pending;

        SubIntervalsIterator() {
            this.current = IntervalsSet.this.getFirstIntervalBoundary();
            if (this.current == null) {
                this.pending = (double[])(((Boolean)IntervalsSet.this.getFirstLeaf(IntervalsSet.this.getTree(false)).getAttribute()).booleanValue() ? new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY} : null);
            } else if (IntervalsSet.this.isIntervalEnd(this.current)) {
                this.pending = new double[]{Double.NEGATIVE_INFINITY, IntervalsSet.this.getAngle(this.current)};
            } else {
                this.selectPending();
            }
        }

        private void selectPending() {
            BSPTree bSPTree = this.current;
            while (bSPTree != null && !IntervalsSet.this.isIntervalStart(bSPTree)) {
                bSPTree = IntervalsSet.this.nextInternalNode(bSPTree);
            }
            if (bSPTree == null) {
                this.current = null;
                this.pending = null;
                return;
            }
            BSPTree bSPTree2 = bSPTree;
            while (bSPTree2 != null && !IntervalsSet.this.isIntervalEnd(bSPTree2)) {
                bSPTree2 = IntervalsSet.this.nextInternalNode(bSPTree2);
            }
            if (bSPTree2 != null) {
                this.pending = new double[]{IntervalsSet.this.getAngle(bSPTree), IntervalsSet.this.getAngle(bSPTree2)};
                this.current = bSPTree2;
            } else {
                this.pending = new double[]{IntervalsSet.this.getAngle(bSPTree), Double.POSITIVE_INFINITY};
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pending != null;
        }

        @Override
        public double[] next() {
            if (this.pending == null) {
                throw new NoSuchElementException();
            }
            double[] dArray = this.pending;
            this.selectPending();
            return dArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

