/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.euclidean.threed.CardanEulerSingularityException;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.NotARotationMatrixException;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldRotation<T extends RealFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20130224L;
    private final T q0;
    private final T q1;
    private final T q2;
    private final T q3;

    public FieldRotation(T t, T t2, T t3, T t4, boolean bl) {
        if (bl) {
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(t)).add(t2.multiply(t2))).add(t3.multiply(t3))).add(t4.multiply(t4))).sqrt()).reciprocal();
            this.q0 = (RealFieldElement)realFieldElement.multiply(t);
            this.q1 = (RealFieldElement)realFieldElement.multiply(t2);
            this.q2 = (RealFieldElement)realFieldElement.multiply(t3);
            this.q3 = (RealFieldElement)realFieldElement.multiply(t4);
        } else {
            this.q0 = t;
            this.q1 = t2;
            this.q2 = t3;
            this.q3 = t4;
        }
    }

    @Deprecated
    public FieldRotation(FieldVector3D<T> fieldVector3D, T t) {
        this(fieldVector3D, t, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation(FieldVector3D<T> fieldVector3D, T t, RotationConvention rotationConvention) {
        T t2 = fieldVector3D.getNorm();
        if (t2.getReal() == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_AXIS, new Object[0]);
        }
        RealFieldElement realFieldElement = (RealFieldElement)t.multiply(rotationConvention == RotationConvention.VECTOR_OPERATOR ? -0.5 : 0.5);
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)realFieldElement.sin()).divide(t2);
        this.q0 = (RealFieldElement)realFieldElement.cos();
        this.q1 = (RealFieldElement)realFieldElement2.multiply(fieldVector3D.getX());
        this.q2 = (RealFieldElement)realFieldElement2.multiply(fieldVector3D.getY());
        this.q3 = (RealFieldElement)realFieldElement2.multiply(fieldVector3D.getZ());
    }

    public FieldRotation(T[][] TArray, double d) {
        if (TArray.length != 3 || TArray[0].length != 3 || TArray[1].length != 3 || TArray[2].length != 3) {
            throw new NotARotationMatrixException(LocalizedFormats.ROTATION_MATRIX_DIMENSIONS, TArray.length, TArray[0].length);
        }
        RealFieldElement[][] realFieldElementArray = this.orthogonalizeMatrix((RealFieldElement[][])TArray, d);
        RealFieldElement realFieldElement = realFieldElementArray[1][1].multiply(realFieldElementArray[2][2]).subtract(realFieldElementArray[2][1].multiply(realFieldElementArray[1][2]));
        RealFieldElement realFieldElement2 = realFieldElementArray[0][1].multiply(realFieldElementArray[2][2]).subtract(realFieldElementArray[2][1].multiply(realFieldElementArray[0][2]));
        RealFieldElement realFieldElement3 = realFieldElementArray[0][1].multiply(realFieldElementArray[1][2]).subtract(realFieldElementArray[1][1].multiply(realFieldElementArray[0][2]));
        RealFieldElement realFieldElement4 = realFieldElementArray[0][0].multiply(realFieldElement).subtract(realFieldElementArray[1][0].multiply(realFieldElement2)).add(realFieldElementArray[2][0].multiply(realFieldElement3));
        if (realFieldElement4.getReal() < 0.0) {
            throw new NotARotationMatrixException(LocalizedFormats.CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT, realFieldElement4);
        }
        RealFieldElement[] realFieldElementArray2 = this.mat2quat(realFieldElementArray);
        this.q0 = realFieldElementArray2[0];
        this.q1 = realFieldElementArray2[1];
        this.q2 = realFieldElementArray2[2];
        this.q3 = realFieldElementArray2[3];
    }

    public FieldRotation(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2, FieldVector3D<T> fieldVector3D3, FieldVector3D<T> fieldVector3D4) {
        FieldVector3D<T> fieldVector3D5 = FieldVector3D.crossProduct(fieldVector3D, fieldVector3D2).normalize();
        fieldVector3D2 = FieldVector3D.crossProduct(fieldVector3D5, fieldVector3D).normalize();
        fieldVector3D = fieldVector3D.normalize();
        FieldVector3D<T> fieldVector3D6 = FieldVector3D.crossProduct(fieldVector3D3, fieldVector3D4).normalize();
        fieldVector3D4 = FieldVector3D.crossProduct(fieldVector3D6, fieldVector3D3).normalize();
        fieldVector3D3 = fieldVector3D3.normalize();
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(fieldVector3D.getX().getField(), 3, 3);
        realFieldElementArray[0][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getX().multiply(fieldVector3D3.getX())).add(fieldVector3D2.getX().multiply(fieldVector3D4.getX()))).add(fieldVector3D5.getX().multiply(fieldVector3D6.getX()));
        realFieldElementArray[0][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getY().multiply(fieldVector3D3.getX())).add(fieldVector3D2.getY().multiply(fieldVector3D4.getX()))).add(fieldVector3D5.getY().multiply(fieldVector3D6.getX()));
        realFieldElementArray[0][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getZ().multiply(fieldVector3D3.getX())).add(fieldVector3D2.getZ().multiply(fieldVector3D4.getX()))).add(fieldVector3D5.getZ().multiply(fieldVector3D6.getX()));
        realFieldElementArray[1][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getX().multiply(fieldVector3D3.getY())).add(fieldVector3D2.getX().multiply(fieldVector3D4.getY()))).add(fieldVector3D5.getX().multiply(fieldVector3D6.getY()));
        realFieldElementArray[1][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getY().multiply(fieldVector3D3.getY())).add(fieldVector3D2.getY().multiply(fieldVector3D4.getY()))).add(fieldVector3D5.getY().multiply(fieldVector3D6.getY()));
        realFieldElementArray[1][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getZ().multiply(fieldVector3D3.getY())).add(fieldVector3D2.getZ().multiply(fieldVector3D4.getY()))).add(fieldVector3D5.getZ().multiply(fieldVector3D6.getY()));
        realFieldElementArray[2][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getX().multiply(fieldVector3D3.getZ())).add(fieldVector3D2.getX().multiply(fieldVector3D4.getZ()))).add(fieldVector3D5.getX().multiply(fieldVector3D6.getZ()));
        realFieldElementArray[2][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getY().multiply(fieldVector3D3.getZ())).add(fieldVector3D2.getY().multiply(fieldVector3D4.getZ()))).add(fieldVector3D5.getY().multiply(fieldVector3D6.getZ()));
        realFieldElementArray[2][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldVector3D.getZ().multiply(fieldVector3D3.getZ())).add(fieldVector3D2.getZ().multiply(fieldVector3D4.getZ()))).add(fieldVector3D5.getZ().multiply(fieldVector3D6.getZ()));
        RealFieldElement[] realFieldElementArray2 = this.mat2quat(realFieldElementArray);
        this.q0 = realFieldElementArray2[0];
        this.q1 = realFieldElementArray2[1];
        this.q2 = realFieldElementArray2[2];
        this.q3 = realFieldElementArray2[3];
    }

    public FieldRotation(FieldVector3D<T> fieldVector3D, FieldVector3D<T> fieldVector3D2) {
        RealFieldElement realFieldElement = (RealFieldElement)fieldVector3D.getNorm().multiply(fieldVector3D2.getNorm());
        if (realFieldElement.getReal() == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR, new Object[0]);
        }
        RealFieldElement realFieldElement2 = FieldVector3D.dotProduct(fieldVector3D, fieldVector3D2);
        if (realFieldElement2.getReal() < -0.999999999999998 * realFieldElement.getReal()) {
            FieldVector3D<T> fieldVector3D3 = fieldVector3D.orthogonal();
            this.q0 = (RealFieldElement)realFieldElement.getField().getZero();
            this.q1 = (RealFieldElement)fieldVector3D3.getX().negate();
            this.q2 = (RealFieldElement)fieldVector3D3.getY().negate();
            this.q3 = (RealFieldElement)fieldVector3D3.getZ().negate();
        } else {
            this.q0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.divide((RealFieldElement)realFieldElement).add(1.0)).multiply(0.5)).sqrt();
            RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)this.q0.multiply((RealFieldElement)realFieldElement).multiply(2.0)).reciprocal();
            FieldVector3D<T> fieldVector3D4 = FieldVector3D.crossProduct(fieldVector3D2, fieldVector3D);
            this.q1 = (RealFieldElement)realFieldElement3.multiply(fieldVector3D4.getX());
            this.q2 = (RealFieldElement)realFieldElement3.multiply(fieldVector3D4.getY());
            this.q3 = (RealFieldElement)realFieldElement3.multiply(fieldVector3D4.getZ());
        }
    }

    @Deprecated
    public FieldRotation(RotationOrder rotationOrder, T t, T t2, T t3) {
        this(rotationOrder, RotationConvention.VECTOR_OPERATOR, t, t2, t3);
    }

    public FieldRotation(RotationOrder rotationOrder, RotationConvention rotationConvention, T t, T t2, T t3) {
        RealFieldElement realFieldElement = (RealFieldElement)t.getField().getOne();
        FieldRotation<RealFieldElement> fieldRotation = new FieldRotation<RealFieldElement>(new FieldVector3D<RealFieldElement>(realFieldElement, rotationOrder.getA1()), (RealFieldElement)t, rotationConvention);
        FieldRotation<RealFieldElement> fieldRotation2 = new FieldRotation<RealFieldElement>(new FieldVector3D<RealFieldElement>(realFieldElement, rotationOrder.getA2()), (RealFieldElement)t2, rotationConvention);
        FieldRotation<RealFieldElement> fieldRotation3 = new FieldRotation<RealFieldElement>(new FieldVector3D<RealFieldElement>(realFieldElement, rotationOrder.getA3()), (RealFieldElement)t3, rotationConvention);
        FieldRotation<RealFieldElement> fieldRotation4 = fieldRotation.compose(fieldRotation2.compose(fieldRotation3, rotationConvention), rotationConvention);
        this.q0 = fieldRotation4.q0;
        this.q1 = fieldRotation4.q1;
        this.q2 = fieldRotation4.q2;
        this.q3 = fieldRotation4.q3;
    }

    private T[] mat2quat(T[][] TArray) {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(TArray[0][0].getField(), 4);
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)TArray[0][0].add(TArray[1][1])).add(TArray[2][2]);
        if (realFieldElement.getReal() > -0.19) {
            realFieldElementArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.add(1.0)).sqrt()).multiply(0.5);
            RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)realFieldElementArray[0].reciprocal()).multiply(0.25);
            realFieldElementArray[1] = (RealFieldElement)realFieldElement2.multiply(TArray[1][2].subtract(TArray[2][1]));
            realFieldElementArray[2] = (RealFieldElement)realFieldElement2.multiply(TArray[2][0].subtract(TArray[0][2]));
            realFieldElementArray[3] = (RealFieldElement)realFieldElement2.multiply(TArray[0][1].subtract(TArray[1][0]));
        } else {
            realFieldElement = (RealFieldElement)((RealFieldElement)TArray[0][0].subtract(TArray[1][1])).subtract(TArray[2][2]);
            if (realFieldElement.getReal() > -0.19) {
                realFieldElementArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.add(1.0)).sqrt()).multiply(0.5);
                RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)realFieldElementArray[1].reciprocal()).multiply(0.25);
                realFieldElementArray[0] = (RealFieldElement)realFieldElement3.multiply(TArray[1][2].subtract(TArray[2][1]));
                realFieldElementArray[2] = (RealFieldElement)realFieldElement3.multiply(TArray[0][1].add(TArray[1][0]));
                realFieldElementArray[3] = (RealFieldElement)realFieldElement3.multiply(TArray[0][2].add(TArray[2][0]));
            } else {
                realFieldElement = (RealFieldElement)((RealFieldElement)TArray[1][1].subtract(TArray[0][0])).subtract(TArray[2][2]);
                if (realFieldElement.getReal() > -0.19) {
                    realFieldElementArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.add(1.0)).sqrt()).multiply(0.5);
                    RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)realFieldElementArray[2].reciprocal()).multiply(0.25);
                    realFieldElementArray[0] = (RealFieldElement)realFieldElement4.multiply(TArray[2][0].subtract(TArray[0][2]));
                    realFieldElementArray[1] = (RealFieldElement)realFieldElement4.multiply(TArray[0][1].add(TArray[1][0]));
                    realFieldElementArray[3] = (RealFieldElement)realFieldElement4.multiply(TArray[2][1].add(TArray[1][2]));
                } else {
                    realFieldElement = (RealFieldElement)((RealFieldElement)TArray[2][2].subtract(TArray[0][0])).subtract(TArray[1][1]);
                    realFieldElementArray[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.add(1.0)).sqrt()).multiply(0.5);
                    RealFieldElement realFieldElement5 = (RealFieldElement)((RealFieldElement)realFieldElementArray[3].reciprocal()).multiply(0.25);
                    realFieldElementArray[0] = (RealFieldElement)realFieldElement5.multiply(TArray[0][1].subtract(TArray[1][0]));
                    realFieldElementArray[1] = (RealFieldElement)realFieldElement5.multiply(TArray[0][2].add(TArray[2][0]));
                    realFieldElementArray[2] = (RealFieldElement)realFieldElement5.multiply(TArray[2][1].add(TArray[1][2]));
                }
            }
        }
        return realFieldElementArray;
    }

    public FieldRotation<T> revert() {
        return new FieldRotation<RealFieldElement>((RealFieldElement)this.q0.negate(), (RealFieldElement)this.q1, (RealFieldElement)this.q2, (RealFieldElement)this.q3, false);
    }

    public T getQ0() {
        return this.q0;
    }

    public T getQ1() {
        return this.q1;
    }

    public T getQ2() {
        return this.q2;
    }

    public T getQ3() {
        return this.q3;
    }

    @Deprecated
    public FieldVector3D<T> getAxis() {
        return this.getAxis(RotationConvention.VECTOR_OPERATOR);
    }

    public FieldVector3D<T> getAxis(RotationConvention rotationConvention) {
        double d;
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(this.q1)).add(this.q2.multiply(this.q2))).add(this.q3.multiply(this.q3));
        if (realFieldElement.getReal() == 0.0) {
            Field field = realFieldElement.getField();
            return new FieldVector3D<RealFieldElement>(rotationConvention == RotationConvention.VECTOR_OPERATOR ? (RealFieldElement)field.getOne() : (RealFieldElement)((RealFieldElement)field.getOne()).negate(), (RealFieldElement)field.getZero(), (RealFieldElement)field.getZero());
        }
        double d2 = d = rotationConvention == RotationConvention.VECTOR_OPERATOR ? 1.0 : -1.0;
        if (this.q0.getReal() < 0.0) {
            RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.sqrt()).reciprocal()).multiply(d);
            return new FieldVector3D<RealFieldElement>(this.q1.multiply((RealFieldElement)realFieldElement2), this.q2.multiply((RealFieldElement)realFieldElement2), this.q3.multiply((RealFieldElement)realFieldElement2));
        }
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement.sqrt()).reciprocal()).negate()).multiply(d);
        return new FieldVector3D<RealFieldElement>(this.q1.multiply((RealFieldElement)realFieldElement3), this.q2.multiply((RealFieldElement)realFieldElement3), this.q3.multiply((RealFieldElement)realFieldElement3));
    }

    public T getAngle() {
        if (this.q0.getReal() < -0.1 || this.q0.getReal() > 0.1) {
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(this.q1)).add(this.q2.multiply(this.q2))).add(this.q3.multiply(this.q3))).sqrt()).asin()).multiply(2));
        }
        if (this.q0.getReal() < 0.0) {
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.negate()).acos()).multiply(2));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.q0.acos()).multiply(2));
    }

    @Deprecated
    public T[] getAngles(RotationOrder rotationOrder) {
        return this.getAngles(rotationOrder, RotationConvention.VECTOR_OPERATOR);
    }

    public T[] getAngles(RotationOrder rotationOrder, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            if (rotationOrder == RotationOrder.XYZ) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 0.0, 1.0));
                FieldVector3D<T> fieldVector3D2 = this.applyInverseTo(this.vector(1.0, 0.0, 0.0));
                if (fieldVector3D2.getZ().getReal() < -0.9999999999 || fieldVector3D2.getZ().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D.getY().negate()).atan2(fieldVector3D.getZ()), (RealFieldElement)fieldVector3D2.getZ().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D2.getY().negate()).atan2(fieldVector3D2.getX()));
            }
            if (rotationOrder == RotationOrder.XZY) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 1.0, 0.0));
                FieldVector3D<T> fieldVector3D3 = this.applyInverseTo(this.vector(1.0, 0.0, 0.0));
                if (fieldVector3D3.getY().getReal() < -0.9999999999 || fieldVector3D3.getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getY()), (RealFieldElement)((RealFieldElement)fieldVector3D3.getY().asin()).negate(), (RealFieldElement)fieldVector3D3.getZ().atan2(fieldVector3D3.getX()));
            }
            if (rotationOrder == RotationOrder.YXZ) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 0.0, 1.0));
                FieldVector3D<T> fieldVector3D4 = this.applyInverseTo(this.vector(0.0, 1.0, 0.0));
                if (fieldVector3D4.getZ().getReal() < -0.9999999999 || fieldVector3D4.getZ().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getZ()), (RealFieldElement)((RealFieldElement)fieldVector3D4.getZ().asin()).negate(), (RealFieldElement)fieldVector3D4.getX().atan2(fieldVector3D4.getY()));
            }
            if (rotationOrder == RotationOrder.YZX) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(1.0, 0.0, 0.0));
                FieldVector3D<T> fieldVector3D5 = this.applyInverseTo(this.vector(0.0, 1.0, 0.0));
                if (fieldVector3D5.getX().getReal() < -0.9999999999 || fieldVector3D5.getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D.getZ().negate()).atan2(fieldVector3D.getX()), (RealFieldElement)fieldVector3D5.getX().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D5.getZ().negate()).atan2(fieldVector3D5.getY()));
            }
            if (rotationOrder == RotationOrder.ZXY) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 1.0, 0.0));
                FieldVector3D<T> fieldVector3D6 = this.applyInverseTo(this.vector(0.0, 0.0, 1.0));
                if (fieldVector3D6.getY().getReal() < -0.9999999999 || fieldVector3D6.getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D.getX().negate()).atan2(fieldVector3D.getY()), (RealFieldElement)fieldVector3D6.getY().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D6.getX().negate()).atan2(fieldVector3D6.getZ()));
            }
            if (rotationOrder == RotationOrder.ZYX) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(1.0, 0.0, 0.0));
                FieldVector3D<T> fieldVector3D7 = this.applyInverseTo(this.vector(0.0, 0.0, 1.0));
                if (fieldVector3D7.getX().getReal() < -0.9999999999 || fieldVector3D7.getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getX()), (RealFieldElement)((RealFieldElement)fieldVector3D7.getX().asin()).negate(), (RealFieldElement)fieldVector3D7.getY().atan2(fieldVector3D7.getZ()));
            }
            if (rotationOrder == RotationOrder.XYX) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(1.0, 0.0, 0.0));
                FieldVector3D<T> fieldVector3D8 = this.applyInverseTo(this.vector(1.0, 0.0, 0.0));
                if (fieldVector3D8.getX().getReal() < -0.9999999999 || fieldVector3D8.getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getZ().negate()), (RealFieldElement)fieldVector3D8.getX().acos(), (RealFieldElement)fieldVector3D8.getY().atan2(fieldVector3D8.getZ()));
            }
            if (rotationOrder == RotationOrder.XZX) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(1.0, 0.0, 0.0));
                FieldVector3D<T> fieldVector3D9 = this.applyInverseTo(this.vector(1.0, 0.0, 0.0));
                if (fieldVector3D9.getX().getReal() < -0.9999999999 || fieldVector3D9.getX().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getY()), (RealFieldElement)fieldVector3D9.getX().acos(), (RealFieldElement)fieldVector3D9.getZ().atan2(fieldVector3D9.getY().negate()));
            }
            if (rotationOrder == RotationOrder.YXY) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 1.0, 0.0));
                FieldVector3D<T> fieldVector3D10 = this.applyInverseTo(this.vector(0.0, 1.0, 0.0));
                if (fieldVector3D10.getY().getReal() < -0.9999999999 || fieldVector3D10.getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getZ()), (RealFieldElement)fieldVector3D10.getY().acos(), (RealFieldElement)fieldVector3D10.getX().atan2(fieldVector3D10.getZ().negate()));
            }
            if (rotationOrder == RotationOrder.YZY) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 1.0, 0.0));
                FieldVector3D<T> fieldVector3D11 = this.applyInverseTo(this.vector(0.0, 1.0, 0.0));
                if (fieldVector3D11.getY().getReal() < -0.9999999999 || fieldVector3D11.getY().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getX().negate()), (RealFieldElement)fieldVector3D11.getY().acos(), (RealFieldElement)fieldVector3D11.getZ().atan2(fieldVector3D11.getX()));
            }
            if (rotationOrder == RotationOrder.ZXZ) {
                FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 0.0, 1.0));
                FieldVector3D<T> fieldVector3D12 = this.applyInverseTo(this.vector(0.0, 0.0, 1.0));
                if (fieldVector3D12.getZ().getReal() < -0.9999999999 || fieldVector3D12.getZ().getReal() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return this.buildArray((RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getY().negate()), (RealFieldElement)fieldVector3D12.getZ().acos(), (RealFieldElement)fieldVector3D12.getX().atan2(fieldVector3D12.getY()));
            }
            FieldVector3D<T> fieldVector3D = this.applyTo(this.vector(0.0, 0.0, 1.0));
            FieldVector3D<T> fieldVector3D13 = this.applyInverseTo(this.vector(0.0, 0.0, 1.0));
            if (fieldVector3D13.getZ().getReal() < -0.9999999999 || fieldVector3D13.getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getX()), (RealFieldElement)fieldVector3D13.getZ().acos(), (RealFieldElement)fieldVector3D13.getY().atan2(fieldVector3D13.getX().negate()));
        }
        if (rotationOrder == RotationOrder.XYZ) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            FieldVector3D<T> fieldVector3D14 = this.applyInverseTo(Vector3D.PLUS_K);
            if (fieldVector3D14.getX().getReal() < -0.9999999999 || fieldVector3D14.getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D14.getY().negate()).atan2(fieldVector3D14.getZ()), (RealFieldElement)fieldVector3D14.getX().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D.getY().negate()).atan2(fieldVector3D.getX()));
        }
        if (rotationOrder == RotationOrder.XZY) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            FieldVector3D<T> fieldVector3D15 = this.applyInverseTo(Vector3D.PLUS_J);
            if (fieldVector3D15.getX().getReal() < -0.9999999999 || fieldVector3D15.getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)fieldVector3D15.getZ().atan2(fieldVector3D15.getY()), (RealFieldElement)((RealFieldElement)fieldVector3D15.getX().asin()).negate(), (RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getX()));
        }
        if (rotationOrder == RotationOrder.YXZ) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            FieldVector3D<T> fieldVector3D16 = this.applyInverseTo(Vector3D.PLUS_K);
            if (fieldVector3D16.getY().getReal() < -0.9999999999 || fieldVector3D16.getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)fieldVector3D16.getX().atan2(fieldVector3D16.getZ()), (RealFieldElement)((RealFieldElement)fieldVector3D16.getY().asin()).negate(), (RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getY()));
        }
        if (rotationOrder == RotationOrder.YZX) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            FieldVector3D<T> fieldVector3D17 = this.applyInverseTo(Vector3D.PLUS_I);
            if (fieldVector3D17.getY().getReal() < -0.9999999999 || fieldVector3D17.getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D17.getZ().negate()).atan2(fieldVector3D17.getX()), (RealFieldElement)fieldVector3D17.getY().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D.getZ().negate()).atan2(fieldVector3D.getY()));
        }
        if (rotationOrder == RotationOrder.ZXY) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_K);
            FieldVector3D<T> fieldVector3D18 = this.applyInverseTo(Vector3D.PLUS_J);
            if (fieldVector3D18.getZ().getReal() < -0.9999999999 || fieldVector3D18.getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)((RealFieldElement)fieldVector3D18.getX().negate()).atan2(fieldVector3D18.getY()), (RealFieldElement)fieldVector3D18.getZ().asin(), (RealFieldElement)((RealFieldElement)fieldVector3D.getX().negate()).atan2(fieldVector3D.getZ()));
        }
        if (rotationOrder == RotationOrder.ZYX) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_K);
            FieldVector3D<T> fieldVector3D19 = this.applyInverseTo(Vector3D.PLUS_I);
            if (fieldVector3D19.getZ().getReal() < -0.9999999999 || fieldVector3D19.getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return this.buildArray((RealFieldElement)fieldVector3D19.getY().atan2(fieldVector3D19.getX()), (RealFieldElement)((RealFieldElement)fieldVector3D19.getZ().asin()).negate(), (RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getZ()));
        }
        if (rotationOrder == RotationOrder.XYX) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            FieldVector3D<T> fieldVector3D20 = this.applyInverseTo(Vector3D.PLUS_I);
            if (fieldVector3D20.getX().getReal() < -0.9999999999 || fieldVector3D20.getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D20.getY().atan2(fieldVector3D20.getZ().negate()), (RealFieldElement)fieldVector3D20.getX().acos(), (RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getZ()));
        }
        if (rotationOrder == RotationOrder.XZX) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_I);
            FieldVector3D<T> fieldVector3D21 = this.applyInverseTo(Vector3D.PLUS_I);
            if (fieldVector3D21.getX().getReal() < -0.9999999999 || fieldVector3D21.getX().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D21.getZ().atan2(fieldVector3D21.getY()), (RealFieldElement)fieldVector3D21.getX().acos(), (RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getY().negate()));
        }
        if (rotationOrder == RotationOrder.YXY) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            FieldVector3D<T> fieldVector3D22 = this.applyInverseTo(Vector3D.PLUS_J);
            if (fieldVector3D22.getY().getReal() < -0.9999999999 || fieldVector3D22.getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D22.getX().atan2(fieldVector3D22.getZ()), (RealFieldElement)fieldVector3D22.getY().acos(), (RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getZ().negate()));
        }
        if (rotationOrder == RotationOrder.YZY) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_J);
            FieldVector3D<T> fieldVector3D23 = this.applyInverseTo(Vector3D.PLUS_J);
            if (fieldVector3D23.getY().getReal() < -0.9999999999 || fieldVector3D23.getY().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D23.getZ().atan2(fieldVector3D23.getX().negate()), (RealFieldElement)fieldVector3D23.getY().acos(), (RealFieldElement)fieldVector3D.getZ().atan2(fieldVector3D.getX()));
        }
        if (rotationOrder == RotationOrder.ZXZ) {
            FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_K);
            FieldVector3D<T> fieldVector3D24 = this.applyInverseTo(Vector3D.PLUS_K);
            if (fieldVector3D24.getZ().getReal() < -0.9999999999 || fieldVector3D24.getZ().getReal() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return this.buildArray((RealFieldElement)fieldVector3D24.getX().atan2(fieldVector3D24.getY().negate()), (RealFieldElement)fieldVector3D24.getZ().acos(), (RealFieldElement)fieldVector3D.getX().atan2(fieldVector3D.getY()));
        }
        FieldVector3D<T> fieldVector3D = this.applyTo(Vector3D.PLUS_K);
        FieldVector3D<T> fieldVector3D25 = this.applyInverseTo(Vector3D.PLUS_K);
        if (fieldVector3D25.getZ().getReal() < -0.9999999999 || fieldVector3D25.getZ().getReal() > 0.9999999999) {
            throw new CardanEulerSingularityException(false);
        }
        return this.buildArray((RealFieldElement)fieldVector3D25.getY().atan2(fieldVector3D25.getX()), (RealFieldElement)fieldVector3D25.getZ().acos(), (RealFieldElement)fieldVector3D.getY().atan2(fieldVector3D.getX().negate()));
    }

    private T[] buildArray(T t, T t2, T t3) {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(t.getField(), 3);
        realFieldElementArray[0] = t;
        realFieldElementArray[1] = t2;
        realFieldElementArray[2] = t3;
        return realFieldElementArray;
    }

    private FieldVector3D<T> vector(double d, double d2, double d3) {
        RealFieldElement realFieldElement = (RealFieldElement)this.q0.getField().getZero();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)realFieldElement.add(d), (RealFieldElement)realFieldElement.add(d2), (RealFieldElement)realFieldElement.add(d3));
    }

    public T[][] getMatrix() {
        RealFieldElement realFieldElement = (RealFieldElement)this.q0.multiply(this.q0);
        RealFieldElement realFieldElement2 = (RealFieldElement)this.q0.multiply(this.q1);
        RealFieldElement realFieldElement3 = (RealFieldElement)this.q0.multiply(this.q2);
        RealFieldElement realFieldElement4 = (RealFieldElement)this.q0.multiply(this.q3);
        RealFieldElement realFieldElement5 = (RealFieldElement)this.q1.multiply(this.q1);
        RealFieldElement realFieldElement6 = (RealFieldElement)this.q1.multiply(this.q2);
        RealFieldElement realFieldElement7 = (RealFieldElement)this.q1.multiply(this.q3);
        RealFieldElement realFieldElement8 = (RealFieldElement)this.q2.multiply(this.q2);
        RealFieldElement realFieldElement9 = (RealFieldElement)this.q2.multiply(this.q3);
        RealFieldElement realFieldElement10 = (RealFieldElement)this.q3.multiply(this.q3);
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.q0.getField(), 3, 3);
        realFieldElementArray[0][0] = (RealFieldElement)((RealFieldElement)realFieldElement.add(realFieldElement5).multiply(2)).subtract(1.0);
        realFieldElementArray[1][0] = (RealFieldElement)realFieldElement6.subtract(realFieldElement4).multiply(2);
        realFieldElementArray[2][0] = (RealFieldElement)realFieldElement7.add(realFieldElement3).multiply(2);
        realFieldElementArray[0][1] = (RealFieldElement)realFieldElement6.add(realFieldElement4).multiply(2);
        realFieldElementArray[1][1] = (RealFieldElement)((RealFieldElement)realFieldElement.add(realFieldElement8).multiply(2)).subtract(1.0);
        realFieldElementArray[2][1] = (RealFieldElement)realFieldElement9.subtract(realFieldElement2).multiply(2);
        realFieldElementArray[0][2] = (RealFieldElement)realFieldElement7.subtract(realFieldElement3).multiply(2);
        realFieldElementArray[1][2] = (RealFieldElement)realFieldElement9.add(realFieldElement2).multiply(2);
        realFieldElementArray[2][2] = (RealFieldElement)((RealFieldElement)realFieldElement.add(realFieldElement10).multiply(2)).subtract(1.0);
        return realFieldElementArray;
    }

    public Rotation toRotation() {
        return new Rotation(this.q0.getReal(), this.q1.getReal(), this.q2.getReal(), this.q3.getReal(), false);
    }

    public FieldVector3D<T> applyTo(FieldVector3D<T> fieldVector3D) {
        T t = fieldVector3D.getX();
        T t2 = fieldVector3D.getY();
        T t3 = fieldVector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(t)).add(this.q2.multiply(t2))).add(this.q3.multiply(t3));
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t.multiply(this.q0)).subtract(((RealFieldElement)this.q2.multiply(t3)).subtract(this.q3.multiply(t2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(t), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t2.multiply(this.q0)).subtract(((RealFieldElement)this.q3.multiply(t)).subtract(this.q1.multiply(t3))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(t2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t3.multiply(this.q0)).subtract(((RealFieldElement)this.q1.multiply(t2)).subtract(this.q2.multiply(t))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(t3));
    }

    public FieldVector3D<T> applyTo(Vector3D vector3D) {
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d)).add(this.q2.multiply(d2))).add(this.q3.multiply(d3));
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d)).subtract(((RealFieldElement)this.q2.multiply(d3)).subtract(this.q3.multiply(d2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(d), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d2)).subtract(((RealFieldElement)this.q3.multiply(d)).subtract(this.q1.multiply(d3))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(d2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d3)).subtract(((RealFieldElement)this.q1.multiply(d2)).subtract(this.q2.multiply(d))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(d3));
    }

    public void applyTo(T[] TArray, T[] TArray2) {
        T t = TArray[0];
        T t2 = TArray[1];
        T t3 = TArray[2];
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(t)).add(this.q2.multiply(t2))).add(this.q3.multiply(t3));
        TArray2[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t.multiply(this.q0)).subtract(((RealFieldElement)this.q2.multiply(t3)).subtract(this.q3.multiply(t2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(t);
        TArray2[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t2.multiply(this.q0)).subtract(((RealFieldElement)this.q3.multiply(t)).subtract(this.q1.multiply(t3))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(t2);
        TArray2[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)t3.multiply(this.q0)).subtract(((RealFieldElement)this.q1.multiply(t2)).subtract(this.q2.multiply(t))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(t3);
    }

    public void applyTo(double[] dArray, T[] TArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d)).add(this.q2.multiply(d2))).add(this.q3.multiply(d3));
        TArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d)).subtract(((RealFieldElement)this.q2.multiply(d3)).subtract(this.q3.multiply(d2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(d);
        TArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d2)).subtract(((RealFieldElement)this.q3.multiply(d)).subtract(this.q1.multiply(d3))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(d2);
        TArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(((RealFieldElement)this.q0.multiply(d3)).subtract(((RealFieldElement)this.q1.multiply(d2)).subtract(this.q2.multiply(d))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(d3);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> applyTo(Rotation rotation, FieldVector3D<T> fieldVector3D) {
        T t = fieldVector3D.getX();
        T t2 = fieldVector3D.getY();
        T t3 = fieldVector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(rotation.getQ1())).add(t2.multiply(rotation.getQ2()))).add(t3.multiply(rotation.getQ3()));
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(rotation.getQ0())).subtract(((RealFieldElement)t3.multiply(rotation.getQ2())).subtract(t2.multiply(rotation.getQ3())))).multiply(rotation.getQ0())).add(realFieldElement.multiply(rotation.getQ1()))).multiply(2)).subtract(t), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t2.multiply(rotation.getQ0())).subtract(((RealFieldElement)t.multiply(rotation.getQ3())).subtract(t3.multiply(rotation.getQ1())))).multiply(rotation.getQ0())).add(realFieldElement.multiply(rotation.getQ2()))).multiply(2)).subtract(t2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t3.multiply(rotation.getQ0())).subtract(((RealFieldElement)t2.multiply(rotation.getQ1())).subtract(t.multiply(rotation.getQ2())))).multiply(rotation.getQ0())).add(realFieldElement.multiply(rotation.getQ3()))).multiply(2)).subtract(t3));
    }

    public FieldVector3D<T> applyInverseTo(FieldVector3D<T> fieldVector3D) {
        RealFieldElement realFieldElement = fieldVector3D.getX();
        RealFieldElement realFieldElement2 = fieldVector3D.getY();
        RealFieldElement realFieldElement3 = fieldVector3D.getZ();
        RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(realFieldElement)).add(this.q2.multiply(realFieldElement2))).add(this.q3.multiply(realFieldElement3));
        RealFieldElement realFieldElement5 = (RealFieldElement)this.q0.negate();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement5.multiply(realFieldElement.multiply((RealFieldElement)realFieldElement5).subtract(((RealFieldElement)this.q2.multiply(realFieldElement3)).subtract(this.q3.multiply(realFieldElement2))))).add(realFieldElement4.multiply(this.q1))).multiply(2)).subtract(realFieldElement), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement5.multiply(realFieldElement2.multiply((RealFieldElement)realFieldElement5).subtract(((RealFieldElement)this.q3.multiply(realFieldElement)).subtract(this.q1.multiply(realFieldElement3))))).add(realFieldElement4.multiply(this.q2))).multiply(2)).subtract(realFieldElement2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement5.multiply(realFieldElement3.multiply((RealFieldElement)realFieldElement5).subtract(((RealFieldElement)this.q1.multiply(realFieldElement2)).subtract(this.q2.multiply(realFieldElement))))).add(realFieldElement4.multiply(this.q3))).multiply(2)).subtract(realFieldElement3));
    }

    public FieldVector3D<T> applyInverseTo(Vector3D vector3D) {
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d)).add(this.q2.multiply(d2))).add(this.q3.multiply(d3));
        RealFieldElement realFieldElement2 = (RealFieldElement)this.q0.negate();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d)).subtract(((RealFieldElement)this.q2.multiply(d3)).subtract(this.q3.multiply(d2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(d), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d2)).subtract(((RealFieldElement)this.q3.multiply(d)).subtract(this.q1.multiply(d3))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(d2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d3)).subtract(((RealFieldElement)this.q1.multiply(d2)).subtract(this.q2.multiply(d))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(d3));
    }

    public void applyInverseTo(T[] TArray, T[] TArray2) {
        RealFieldElement realFieldElement = TArray[0];
        RealFieldElement realFieldElement2 = TArray[1];
        RealFieldElement realFieldElement3 = TArray[2];
        RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(realFieldElement)).add(this.q2.multiply(realFieldElement2))).add(this.q3.multiply(realFieldElement3));
        RealFieldElement realFieldElement5 = (RealFieldElement)this.q0.negate();
        TArray2[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement5.multiply(realFieldElement.multiply((RealFieldElement)realFieldElement5).subtract(((RealFieldElement)this.q2.multiply(realFieldElement3)).subtract(this.q3.multiply(realFieldElement2))))).add(realFieldElement4.multiply(this.q1))).multiply(2)).subtract(realFieldElement);
        TArray2[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement5.multiply(realFieldElement2.multiply((RealFieldElement)realFieldElement5).subtract(((RealFieldElement)this.q3.multiply(realFieldElement)).subtract(this.q1.multiply(realFieldElement3))))).add(realFieldElement4.multiply(this.q2))).multiply(2)).subtract(realFieldElement2);
        TArray2[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement5.multiply(realFieldElement3.multiply((RealFieldElement)realFieldElement5).subtract(((RealFieldElement)this.q1.multiply(realFieldElement2)).subtract(this.q2.multiply(realFieldElement))))).add(realFieldElement4.multiply(this.q3))).multiply(2)).subtract(realFieldElement3);
    }

    public void applyInverseTo(double[] dArray, T[] TArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(d)).add(this.q2.multiply(d2))).add(this.q3.multiply(d3));
        RealFieldElement realFieldElement2 = (RealFieldElement)this.q0.negate();
        TArray[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d)).subtract(((RealFieldElement)this.q2.multiply(d3)).subtract(this.q3.multiply(d2))))).add(realFieldElement.multiply(this.q1))).multiply(2)).subtract(d);
        TArray[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d2)).subtract(((RealFieldElement)this.q3.multiply(d)).subtract(this.q1.multiply(d3))))).add(realFieldElement.multiply(this.q2))).multiply(2)).subtract(d2);
        TArray[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement2.multiply(((RealFieldElement)realFieldElement2.multiply(d3)).subtract(((RealFieldElement)this.q1.multiply(d2)).subtract(this.q2.multiply(d))))).add(realFieldElement.multiply(this.q3))).multiply(2)).subtract(d3);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> applyInverseTo(Rotation rotation, FieldVector3D<T> fieldVector3D) {
        T t = fieldVector3D.getX();
        T t2 = fieldVector3D.getY();
        T t3 = fieldVector3D.getZ();
        RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(rotation.getQ1())).add(t2.multiply(rotation.getQ2()))).add(t3.multiply(rotation.getQ3()));
        double d = -rotation.getQ0();
        return new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t.multiply(d)).subtract(((RealFieldElement)t3.multiply(rotation.getQ2())).subtract(t2.multiply(rotation.getQ3())))).multiply(d)).add(realFieldElement.multiply(rotation.getQ1()))).multiply(2)).subtract(t), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t2.multiply(d)).subtract(((RealFieldElement)t.multiply(rotation.getQ3())).subtract(t3.multiply(rotation.getQ1())))).multiply(d)).add(realFieldElement.multiply(rotation.getQ2()))).multiply(2)).subtract(t2), (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)t3.multiply(d)).subtract(((RealFieldElement)t2.multiply(rotation.getQ1())).subtract(t.multiply(rotation.getQ2())))).multiply(d)).add(realFieldElement.multiply(rotation.getQ3()))).multiply(2)).subtract(t3));
    }

    public FieldRotation<T> applyTo(FieldRotation<T> fieldRotation) {
        return this.compose(fieldRotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> compose(FieldRotation<T> fieldRotation, RotationConvention rotationConvention) {
        return rotationConvention == RotationConvention.VECTOR_OPERATOR ? this.composeInternal(fieldRotation) : super.composeInternal(this);
    }

    private FieldRotation<T> composeInternal(FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q0)).subtract(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(this.q1)).add(fieldRotation.q2.multiply(this.q2))).add(fieldRotation.q3.multiply(this.q3))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(this.q0)).add(fieldRotation.q0.multiply(this.q1))).add(((RealFieldElement)fieldRotation.q2.multiply(this.q3)).subtract(fieldRotation.q3.multiply(this.q2))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q2.multiply(this.q0)).add(fieldRotation.q0.multiply(this.q2))).add(((RealFieldElement)fieldRotation.q3.multiply(this.q1)).subtract(fieldRotation.q1.multiply(this.q3))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q3.multiply(this.q0)).add(fieldRotation.q0.multiply(this.q3))).add(((RealFieldElement)fieldRotation.q1.multiply(this.q2)).subtract(fieldRotation.q2.multiply(this.q1))), false);
    }

    public FieldRotation<T> applyTo(Rotation rotation) {
        return this.compose(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> compose(Rotation rotation, RotationConvention rotationConvention) {
        return rotationConvention == RotationConvention.VECTOR_OPERATOR ? this.composeInternal(rotation) : FieldRotation.applyTo(rotation, this);
    }

    private FieldRotation<T> composeInternal(Rotation rotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ0())).subtract(((RealFieldElement)((RealFieldElement)this.q1.multiply(rotation.getQ1())).add(this.q2.multiply(rotation.getQ2()))).add(this.q3.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ1())).add(this.q1.multiply(rotation.getQ0()))).add(((RealFieldElement)this.q3.multiply(rotation.getQ2())).subtract(this.q2.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ2())).add(this.q2.multiply(rotation.getQ0()))).add(((RealFieldElement)this.q1.multiply(rotation.getQ3())).subtract(this.q3.multiply(rotation.getQ1()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ3())).add(this.q3.multiply(rotation.getQ0()))).add(((RealFieldElement)this.q2.multiply(rotation.getQ1())).subtract(this.q1.multiply(rotation.getQ2()))), false);
    }

    public static <T extends RealFieldElement<T>> FieldRotation<T> applyTo(Rotation rotation, FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ0())).subtract(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ1())).add(fieldRotation.q2.multiply(rotation.getQ2()))).add(fieldRotation.q3.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ0())).add(fieldRotation.q0.multiply(rotation.getQ1()))).add(((RealFieldElement)fieldRotation.q2.multiply(rotation.getQ3())).subtract(fieldRotation.q3.multiply(rotation.getQ2()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q2.multiply(rotation.getQ0())).add(fieldRotation.q0.multiply(rotation.getQ2()))).add(((RealFieldElement)fieldRotation.q3.multiply(rotation.getQ1())).subtract(fieldRotation.q1.multiply(rotation.getQ3()))), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q3.multiply(rotation.getQ0())).add(fieldRotation.q0.multiply(rotation.getQ3()))).add(((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ2())).subtract(fieldRotation.q2.multiply(rotation.getQ1()))), false);
    }

    public FieldRotation<T> applyInverseTo(FieldRotation<T> fieldRotation) {
        return this.composeInverse(fieldRotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> composeInverse(FieldRotation<T> fieldRotation, RotationConvention rotationConvention) {
        return rotationConvention == RotationConvention.VECTOR_OPERATOR ? this.composeInverseInternal(fieldRotation) : super.composeInternal(this.revert());
    }

    private FieldRotation<T> composeInverseInternal(FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q0)).add(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(this.q1)).add(fieldRotation.q2.multiply(this.q2))).add(fieldRotation.q3.multiply(this.q3)))).negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q1)).add(((RealFieldElement)fieldRotation.q2.multiply(this.q3)).subtract(fieldRotation.q3.multiply(this.q2)))).subtract(fieldRotation.q1.multiply(this.q0)), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q2)).add(((RealFieldElement)fieldRotation.q3.multiply(this.q1)).subtract(fieldRotation.q1.multiply(this.q3)))).subtract(fieldRotation.q2.multiply(this.q0)), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(this.q3)).add(((RealFieldElement)fieldRotation.q1.multiply(this.q2)).subtract(fieldRotation.q2.multiply(this.q1)))).subtract(fieldRotation.q3.multiply(this.q0)), false);
    }

    public FieldRotation<T> applyInverseTo(Rotation rotation) {
        return this.composeInverse(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> composeInverse(Rotation rotation, RotationConvention rotationConvention) {
        return rotationConvention == RotationConvention.VECTOR_OPERATOR ? this.composeInverseInternal(rotation) : FieldRotation.applyTo(rotation, this.revert());
    }

    private FieldRotation<T> composeInverseInternal(Rotation rotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)this.q0.multiply(rotation.getQ0())).add(((RealFieldElement)((RealFieldElement)this.q1.multiply(rotation.getQ1())).add(this.q2.multiply(rotation.getQ2()))).add(this.q3.multiply(rotation.getQ3())))).negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q1.multiply(rotation.getQ0())).add(((RealFieldElement)this.q3.multiply(rotation.getQ2())).subtract(this.q2.multiply(rotation.getQ3())))).subtract(this.q0.multiply(rotation.getQ1())), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q2.multiply(rotation.getQ0())).add(((RealFieldElement)this.q1.multiply(rotation.getQ3())).subtract(this.q3.multiply(rotation.getQ1())))).subtract(this.q0.multiply(rotation.getQ2())), (RealFieldElement)((RealFieldElement)((RealFieldElement)this.q3.multiply(rotation.getQ0())).add(((RealFieldElement)this.q2.multiply(rotation.getQ1())).subtract(this.q1.multiply(rotation.getQ2())))).subtract(this.q0.multiply(rotation.getQ3())), false);
    }

    public static <T extends RealFieldElement<T>> FieldRotation<T> applyInverseTo(Rotation rotation, FieldRotation<T> fieldRotation) {
        return new FieldRotation<RealFieldElement>((RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ0())).add(((RealFieldElement)((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ1())).add(fieldRotation.q2.multiply(rotation.getQ2()))).add(fieldRotation.q3.multiply(rotation.getQ3())))).negate(), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ1())).add(((RealFieldElement)fieldRotation.q2.multiply(rotation.getQ3())).subtract(fieldRotation.q3.multiply(rotation.getQ2())))).subtract(fieldRotation.q1.multiply(rotation.getQ0())), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ2())).add(((RealFieldElement)fieldRotation.q3.multiply(rotation.getQ1())).subtract(fieldRotation.q1.multiply(rotation.getQ3())))).subtract(fieldRotation.q2.multiply(rotation.getQ0())), (RealFieldElement)((RealFieldElement)((RealFieldElement)fieldRotation.q0.multiply(rotation.getQ3())).add(((RealFieldElement)fieldRotation.q1.multiply(rotation.getQ2())).subtract(fieldRotation.q2.multiply(rotation.getQ1())))).subtract(fieldRotation.q3.multiply(rotation.getQ0())), false);
    }

    private T[][] orthogonalizeMatrix(T[][] TArray, double d) {
        RealFieldElement realFieldElement = TArray[0][0];
        RealFieldElement realFieldElement2 = TArray[0][1];
        RealFieldElement realFieldElement3 = TArray[0][2];
        RealFieldElement realFieldElement4 = TArray[1][0];
        RealFieldElement realFieldElement5 = TArray[1][1];
        RealFieldElement realFieldElement6 = TArray[1][2];
        RealFieldElement realFieldElement7 = TArray[2][0];
        RealFieldElement realFieldElement8 = TArray[2][1];
        RealFieldElement realFieldElement9 = TArray[2][2];
        double d2 = 0.0;
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(TArray[0][0].getField(), 3, 3);
        int n = 0;
        while (++n < 11) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            RealFieldElement realFieldElement10 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][0].multiply(realFieldElement)).add(TArray[1][0].multiply(realFieldElement4))).add(TArray[2][0].multiply(realFieldElement7));
            RealFieldElement realFieldElement11 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][1].multiply(realFieldElement)).add(TArray[1][1].multiply(realFieldElement4))).add(TArray[2][1].multiply(realFieldElement7));
            RealFieldElement realFieldElement12 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][2].multiply(realFieldElement)).add(TArray[1][2].multiply(realFieldElement4))).add(TArray[2][2].multiply(realFieldElement7));
            RealFieldElement realFieldElement13 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][0].multiply(realFieldElement2)).add(TArray[1][0].multiply(realFieldElement5))).add(TArray[2][0].multiply(realFieldElement8));
            RealFieldElement realFieldElement14 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][1].multiply(realFieldElement2)).add(TArray[1][1].multiply(realFieldElement5))).add(TArray[2][1].multiply(realFieldElement8));
            RealFieldElement realFieldElement15 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][2].multiply(realFieldElement2)).add(TArray[1][2].multiply(realFieldElement5))).add(TArray[2][2].multiply(realFieldElement8));
            RealFieldElement realFieldElement16 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][0].multiply(realFieldElement3)).add(TArray[1][0].multiply(realFieldElement6))).add(TArray[2][0].multiply(realFieldElement9));
            RealFieldElement realFieldElement17 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][1].multiply(realFieldElement3)).add(TArray[1][1].multiply(realFieldElement6))).add(TArray[2][1].multiply(realFieldElement9));
            RealFieldElement realFieldElement18 = (RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][2].multiply(realFieldElement3)).add(TArray[1][2].multiply(realFieldElement6))).add(TArray[2][2].multiply(realFieldElement9));
            realFieldElementArray[0][0] = (RealFieldElement)realFieldElement.subtract(((RealFieldElement)realFieldElement.multiply((RealFieldElement)realFieldElement10).add(realFieldElement2.multiply((RealFieldElement)realFieldElement11)).add(realFieldElement3.multiply((RealFieldElement)realFieldElement12)).subtract(TArray[0][0])).multiply(0.5));
            realFieldElementArray[0][1] = (RealFieldElement)realFieldElement2.subtract(((RealFieldElement)realFieldElement.multiply((RealFieldElement)realFieldElement13).add(realFieldElement2.multiply((RealFieldElement)realFieldElement14)).add(realFieldElement3.multiply((RealFieldElement)realFieldElement15)).subtract(TArray[0][1])).multiply(0.5));
            realFieldElementArray[0][2] = (RealFieldElement)realFieldElement3.subtract(((RealFieldElement)realFieldElement.multiply((RealFieldElement)realFieldElement16).add(realFieldElement2.multiply((RealFieldElement)realFieldElement17)).add(realFieldElement3.multiply((RealFieldElement)realFieldElement18)).subtract(TArray[0][2])).multiply(0.5));
            realFieldElementArray[1][0] = (RealFieldElement)realFieldElement4.subtract(((RealFieldElement)realFieldElement4.multiply((RealFieldElement)realFieldElement10).add(realFieldElement5.multiply((RealFieldElement)realFieldElement11)).add(realFieldElement6.multiply((RealFieldElement)realFieldElement12)).subtract(TArray[1][0])).multiply(0.5));
            realFieldElementArray[1][1] = (RealFieldElement)realFieldElement5.subtract(((RealFieldElement)realFieldElement4.multiply((RealFieldElement)realFieldElement13).add(realFieldElement5.multiply((RealFieldElement)realFieldElement14)).add(realFieldElement6.multiply((RealFieldElement)realFieldElement15)).subtract(TArray[1][1])).multiply(0.5));
            realFieldElementArray[1][2] = (RealFieldElement)realFieldElement6.subtract(((RealFieldElement)realFieldElement4.multiply((RealFieldElement)realFieldElement16).add(realFieldElement5.multiply((RealFieldElement)realFieldElement17)).add(realFieldElement6.multiply((RealFieldElement)realFieldElement18)).subtract(TArray[1][2])).multiply(0.5));
            realFieldElementArray[2][0] = (RealFieldElement)realFieldElement7.subtract(((RealFieldElement)realFieldElement7.multiply((RealFieldElement)realFieldElement10).add(realFieldElement8.multiply((RealFieldElement)realFieldElement11)).add(realFieldElement9.multiply((RealFieldElement)realFieldElement12)).subtract(TArray[2][0])).multiply(0.5));
            realFieldElementArray[2][1] = (RealFieldElement)realFieldElement8.subtract(((RealFieldElement)realFieldElement7.multiply((RealFieldElement)realFieldElement13).add(realFieldElement8.multiply((RealFieldElement)realFieldElement14)).add(realFieldElement9.multiply((RealFieldElement)realFieldElement15)).subtract(TArray[2][1])).multiply(0.5));
            realFieldElementArray[2][2] = (RealFieldElement)realFieldElement9.subtract(((RealFieldElement)realFieldElement7.multiply((RealFieldElement)realFieldElement16).add(realFieldElement8.multiply((RealFieldElement)realFieldElement17)).add(realFieldElement9.multiply((RealFieldElement)realFieldElement18)).subtract(TArray[2][2])).multiply(0.5));
            double d11 = realFieldElementArray[0][0].getReal() - TArray[0][0].getReal();
            double d12 = d11 * d11 + (d10 = realFieldElementArray[0][1].getReal() - TArray[0][1].getReal()) * d10 + (d9 = realFieldElementArray[0][2].getReal() - TArray[0][2].getReal()) * d9 + (d8 = realFieldElementArray[1][0].getReal() - TArray[1][0].getReal()) * d8 + (d7 = realFieldElementArray[1][1].getReal() - TArray[1][1].getReal()) * d7 + (d6 = realFieldElementArray[1][2].getReal() - TArray[1][2].getReal()) * d6 + (d5 = realFieldElementArray[2][0].getReal() - TArray[2][0].getReal()) * d5 + (d4 = realFieldElementArray[2][1].getReal() - TArray[2][1].getReal()) * d4 + (d3 = realFieldElementArray[2][2].getReal() - TArray[2][2].getReal()) * d3;
            if (FastMath.abs(d12 - d2) <= d) {
                return realFieldElementArray;
            }
            realFieldElement = realFieldElementArray[0][0];
            realFieldElement2 = realFieldElementArray[0][1];
            realFieldElement3 = realFieldElementArray[0][2];
            realFieldElement4 = realFieldElementArray[1][0];
            realFieldElement5 = realFieldElementArray[1][1];
            realFieldElement6 = realFieldElementArray[1][2];
            realFieldElement7 = realFieldElementArray[2][0];
            realFieldElement8 = realFieldElementArray[2][1];
            realFieldElement9 = realFieldElementArray[2][2];
            d2 = d12;
        }
        throw new NotARotationMatrixException(LocalizedFormats.UNABLE_TO_ORTHOGONOLIZE_MATRIX, n - 1);
    }

    public static <T extends RealFieldElement<T>> T distance(FieldRotation<T> fieldRotation, FieldRotation<T> fieldRotation2) {
        return super.composeInverseInternal(fieldRotation2).getAngle();
    }
}

