/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.SubLine;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.Embedding;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Embedding<Euclidean3D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private Vector3D direction;
    private Vector3D zero;
    private final double tolerance;

    public Line(Vector3D vector3D, Vector3D vector3D2, double d) {
        this.reset(vector3D, vector3D2);
        this.tolerance = d;
    }

    public Line(Line line) {
        this.direction = line.direction;
        this.zero = line.zero;
        this.tolerance = line.tolerance;
    }

    @Deprecated
    public Line(Vector3D vector3D, Vector3D vector3D2) {
        this(vector3D, vector3D2, 1.0E-10);
    }

    public void reset(Vector3D vector3D, Vector3D vector3D2) {
        Vector vector = vector3D2.subtract((Vector)vector3D);
        double d = ((Vector3D)vector).getNormSq();
        if (d == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.direction = new Vector3D(1.0 / FastMath.sqrt(d), (Vector3D)vector);
        this.zero = new Vector3D(1.0, vector3D, -vector3D.dotProduct(vector) / d, (Vector3D)vector);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Line revert() {
        Line line = new Line(this);
        line.direction = line.direction.negate();
        return line;
    }

    public Vector3D getDirection() {
        return this.direction;
    }

    public Vector3D getOrigin() {
        return this.zero;
    }

    public double getAbscissa(Vector3D vector3D) {
        return ((Vector3D)vector3D.subtract((Vector)this.zero)).dotProduct(this.direction);
    }

    public Vector3D pointAt(double d) {
        return new Vector3D(1.0, this.zero, d, this.direction);
    }

    public Vector1D toSubSpace(Vector<Euclidean3D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector3D toSpace(Vector<Euclidean1D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector1D toSubSpace(Point<Euclidean3D> point) {
        return new Vector1D(this.getAbscissa((Vector3D)point));
    }

    public Vector3D toSpace(Point<Euclidean1D> point) {
        return this.pointAt(((Vector1D)point).getX());
    }

    public boolean isSimilarTo(Line line) {
        double d = Vector3D.angle(this.direction, line.direction);
        return (d < this.tolerance || d > Math.PI - this.tolerance) && this.contains(line.zero);
    }

    public boolean contains(Vector3D vector3D) {
        return this.distance(vector3D) < this.tolerance;
    }

    public double distance(Vector3D vector3D) {
        Vector vector = vector3D.subtract((Vector)this.zero);
        Vector3D vector3D2 = new Vector3D(1.0, (Vector3D)vector, -((Vector3D)vector).dotProduct(this.direction), this.direction);
        return vector3D2.getNorm();
    }

    public double distance(Line line) {
        Vector3D vector3D = Vector3D.crossProduct(this.direction, line.direction);
        double d = vector3D.getNorm();
        if (d < Precision.SAFE_MIN) {
            return this.distance(line.zero);
        }
        double d2 = ((Vector3D)line.zero.subtract((Vector)this.zero)).dotProduct(vector3D) / d;
        return FastMath.abs(d2);
    }

    public Vector3D closestPoint(Line line) {
        double d = this.direction.dotProduct(line.direction);
        double d2 = 1.0 - d * d;
        if (d2 < Precision.EPSILON) {
            return this.zero;
        }
        Vector vector = line.zero.subtract((Vector)this.zero);
        double d3 = ((Vector3D)vector).dotProduct(this.direction);
        double d4 = ((Vector3D)vector).dotProduct(line.direction);
        return new Vector3D(1.0, this.zero, (d3 - d4 * d) / d2, this.direction);
    }

    public Vector3D intersection(Line line) {
        Vector3D vector3D = this.closestPoint(line);
        return line.contains(vector3D) ? vector3D : null;
    }

    public SubLine wholeLine() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }
}

