/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.util.FastMath;

public class OutlineExtractor {
    private Vector3D u;
    private Vector3D v;
    private Vector3D w;

    public OutlineExtractor(Vector3D vector3D, Vector3D vector3D2) {
        this.u = vector3D;
        this.v = vector3D2;
        this.w = Vector3D.crossProduct(vector3D, vector3D2);
    }

    public Vector2D[][] getOutline(PolyhedronsSet polyhedronsSet) {
        BoundaryProjector boundaryProjector = new BoundaryProjector(polyhedronsSet.getTolerance());
        polyhedronsSet.getTree(true).visit(boundaryProjector);
        PolygonsSet polygonsSet = boundaryProjector.getProjected();
        Vector2D[][] vector2DArray = polygonsSet.getVertices();
        for (int i = 0; i < vector2DArray.length; ++i) {
            Vector2D[] vector2DArray2 = vector2DArray[i];
            int n = vector2DArray2.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.pointIsBetween(vector2DArray2, n, n2)) {
                    for (int j = n2; j < n - 1; ++j) {
                        vector2DArray2[j] = vector2DArray2[j + 1];
                    }
                    --n;
                    continue;
                }
                ++n2;
            }
            if (n == vector2DArray2.length) continue;
            vector2DArray[i] = new Vector2D[n];
            System.arraycopy(vector2DArray2, 0, vector2DArray[i], 0, n);
        }
        return vector2DArray;
    }

    private boolean pointIsBetween(Vector2D[] vector2DArray, int n, int n2) {
        Vector2D vector2D = vector2DArray[(n2 + n - 1) % n];
        Vector2D vector2D2 = vector2DArray[n2];
        Vector2D vector2D3 = vector2DArray[(n2 + 1) % n];
        double d = vector2D2.getX() - vector2D.getX();
        double d2 = vector2D2.getY() - vector2D.getY();
        double d3 = vector2D3.getX() - vector2D2.getX();
        double d4 = vector2D3.getY() - vector2D2.getY();
        double d5 = d * d4 - d3 * d2;
        double d6 = d * d3 + d2 * d4;
        double d7 = FastMath.sqrt((d * d + d2 * d2) * (d3 * d3 + d4 * d4));
        return FastMath.abs(d5) <= 1.0E-6 * d7 && d6 >= 0.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BoundaryProjector
    implements BSPTreeVisitor<Euclidean3D> {
        private PolygonsSet projected;
        private final double tolerance;

        BoundaryProjector(double d) {
            this.projected = new PolygonsSet(new BSPTree<Euclidean2D>(Boolean.FALSE), d);
            this.tolerance = d;
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean3D> bSPTree) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean3D> bSPTree) {
            BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
            if (boundaryAttribute.getPlusOutside() != null) {
                this.addContribution(boundaryAttribute.getPlusOutside(), false);
            }
            if (boundaryAttribute.getPlusInside() != null) {
                this.addContribution(boundaryAttribute.getPlusInside(), true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean3D> bSPTree) {
        }

        /*
         * WARNING - void declaration
         */
        private void addContribution(SubHyperplane<Euclidean3D> subHyperplane, boolean bl) {
            AbstractSubHyperplane abstractSubHyperplane = (AbstractSubHyperplane)subHyperplane;
            Plane plane = (Plane)subHyperplane.getHyperplane();
            double d = plane.getNormal().dotProduct(OutlineExtractor.this.w);
            if (FastMath.abs(d) > 0.001) {
                Object object;
                Vector2D[][] vector2DArray = ((PolygonsSet)abstractSubHyperplane.getRemainingRegion()).getVertices();
                if (d < 0.0 ^ bl) {
                    void object2;
                    object = new Vector2D[vector2DArray.length][];
                    boolean i = false;
                    while (object2 < vector2DArray.length) {
                        int vector2DArray4;
                        Vector2D[] vector2DArray2 = vector2DArray[object2];
                        Vector2D[] vector2DArray3 = new Vector2D[vector2DArray2.length];
                        if (vector2DArray2[0] == null) {
                            vector2DArray3[0] = null;
                            for (vector2DArray4 = 1; vector2DArray4 < vector2DArray2.length; ++vector2DArray4) {
                                vector2DArray3[vector2DArray4] = vector2DArray2[vector2DArray2.length - vector2DArray4];
                            }
                        } else {
                            for (vector2DArray4 = 0; vector2DArray4 < vector2DArray2.length; ++vector2DArray4) {
                                vector2DArray3[vector2DArray4] = vector2DArray2[vector2DArray2.length - (vector2DArray4 + 1)];
                            }
                        }
                        object[object2] = vector2DArray3;
                        ++object2;
                    }
                    vector2DArray = object;
                }
                object = new ArrayList();
                for (Vector2D[] vector2DArray4 : vector2DArray) {
                    boolean bl2 = vector2DArray4[0] != null;
                    int n = bl2 ? vector2DArray4.length - 1 : 1;
                    Point point = plane.toSpace((Point)vector2DArray4[n]);
                    int n2 = (n + 1) % vector2DArray4.length;
                    Vector2D vector2D = new Vector2D(((Vector3D)point).dotProduct(OutlineExtractor.this.u), ((Vector3D)point).dotProduct(OutlineExtractor.this.v));
                    while (n2 < vector2DArray4.length) {
                        Line line;
                        double d2;
                        Point point2 = plane.toSpace((Point)vector2DArray4[n2]);
                        Vector2D vector2D2 = new Vector2D(((Vector3D)point2).dotProduct(OutlineExtractor.this.u), ((Vector3D)point2).dotProduct(OutlineExtractor.this.v));
                        Line line2 = new Line(vector2D, vector2D2, this.tolerance);
                        SubHyperplane<Euclidean2D> subHyperplane2 = line2.wholeHyperplane();
                        if (bl2 || n != 1) {
                            d2 = line2.getAngle() + 1.5707963267948966;
                            line = new Line(vector2D, d2, this.tolerance);
                            subHyperplane2 = subHyperplane2.split(line).getPlus();
                        }
                        if (bl2 || n2 != vector2DArray4.length - 1) {
                            d2 = line2.getAngle() + 1.5707963267948966;
                            line = new Line(vector2D2, d2, this.tolerance);
                            subHyperplane2 = subHyperplane2.split(line).getMinus();
                        }
                        ((ArrayList)object).add(subHyperplane2);
                        n = n2++;
                        point = point2;
                        vector2D = vector2D2;
                    }
                }
                PolygonsSet polygonsSet = new PolygonsSet((Collection<SubHyperplane<Euclidean2D>>)object, this.tolerance);
                this.projected = (PolygonsSet)new RegionFactory<Euclidean2D>().union(this.projected, polygonsSet);
            }
        }

        public PolygonsSet getProjected() {
            return this.projected;
        }
    }
}

