/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.SubPlane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.Embedding;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plane
implements Hyperplane<Euclidean3D>,
Embedding<Euclidean3D, Euclidean2D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private double originOffset;
    private Vector3D origin;
    private Vector3D u;
    private Vector3D v;
    private Vector3D w;
    private final double tolerance;

    public Plane(Vector3D vector3D, double d) {
        this.setNormal(vector3D);
        this.tolerance = d;
        this.originOffset = 0.0;
        this.setFrame();
    }

    public Plane(Vector3D vector3D, Vector3D vector3D2, double d) {
        this.setNormal(vector3D2);
        this.tolerance = d;
        this.originOffset = -vector3D.dotProduct(this.w);
        this.setFrame();
    }

    public Plane(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, double d) {
        this(vector3D, ((Vector3D)vector3D2.subtract((Vector)vector3D)).crossProduct(vector3D3.subtract((Vector)vector3D)), d);
    }

    @Deprecated
    public Plane(Vector3D vector3D) {
        this(vector3D, 1.0E-10);
    }

    @Deprecated
    public Plane(Vector3D vector3D, Vector3D vector3D2) {
        this(vector3D, vector3D2, 1.0E-10);
    }

    @Deprecated
    public Plane(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        this(vector3D, vector3D2, vector3D3, 1.0E-10);
    }

    public Plane(Plane plane) {
        this.originOffset = plane.originOffset;
        this.origin = plane.origin;
        this.u = plane.u;
        this.v = plane.v;
        this.w = plane.w;
        this.tolerance = plane.tolerance;
    }

    public Plane copySelf() {
        return new Plane(this);
    }

    public void reset(Vector3D vector3D, Vector3D vector3D2) {
        this.setNormal(vector3D2);
        this.originOffset = -vector3D.dotProduct(this.w);
        this.setFrame();
    }

    public void reset(Plane plane) {
        this.originOffset = plane.originOffset;
        this.origin = plane.origin;
        this.u = plane.u;
        this.v = plane.v;
        this.w = plane.w;
    }

    private void setNormal(Vector3D vector3D) {
        double d = vector3D.getNorm();
        if (d < 1.0E-10) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.w = new Vector3D(1.0 / d, vector3D);
    }

    private void setFrame() {
        this.origin = new Vector3D(-this.originOffset, this.w);
        this.u = this.w.orthogonal();
        this.v = Vector3D.crossProduct(this.w, this.u);
    }

    public Vector3D getOrigin() {
        return this.origin;
    }

    public Vector3D getNormal() {
        return this.w;
    }

    public Vector3D getU() {
        return this.u;
    }

    public Vector3D getV() {
        return this.v;
    }

    @Override
    public Point<Euclidean3D> project(Point<Euclidean3D> point) {
        return this.toSpace((Vector<Euclidean2D>)this.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public void revertSelf() {
        Vector3D vector3D = this.u;
        this.u = this.v;
        this.v = vector3D;
        this.w = this.w.negate();
        this.originOffset = -this.originOffset;
    }

    public Vector2D toSubSpace(Vector<Euclidean3D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector3D toSpace(Vector<Euclidean2D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector2D toSubSpace(Point<Euclidean3D> point) {
        Vector3D vector3D = (Vector3D)point;
        return new Vector2D(vector3D.dotProduct(this.u), vector3D.dotProduct(this.v));
    }

    public Vector3D toSpace(Point<Euclidean2D> point) {
        Vector2D vector2D = (Vector2D)point;
        return new Vector3D(vector2D.getX(), this.u, vector2D.getY(), this.v, -this.originOffset, this.w);
    }

    public Vector3D getPointAt(Vector2D vector2D, double d) {
        return new Vector3D(vector2D.getX(), this.u, vector2D.getY(), this.v, d - this.originOffset, this.w);
    }

    public boolean isSimilarTo(Plane plane) {
        double d = Vector3D.angle(this.w, plane.w);
        return d < 1.0E-10 && FastMath.abs(this.originOffset - plane.originOffset) < this.tolerance || d > 3.141592653489793 && FastMath.abs(this.originOffset + plane.originOffset) < this.tolerance;
    }

    public Plane rotate(Vector3D vector3D, Rotation rotation) {
        Vector vector = this.origin.subtract((Vector)vector3D);
        Plane plane = new Plane((Vector3D)vector3D.add((Vector)rotation.applyTo((Vector3D)vector)), rotation.applyTo(this.w), this.tolerance);
        plane.u = rotation.applyTo(this.u);
        plane.v = rotation.applyTo(this.v);
        return plane;
    }

    public Plane translate(Vector3D vector3D) {
        Plane plane = new Plane((Vector3D)this.origin.add((Vector)vector3D), this.w, this.tolerance);
        plane.u = this.u;
        plane.v = this.v;
        return plane;
    }

    public Vector3D intersection(Line line) {
        Vector3D vector3D = line.getDirection();
        double d = this.w.dotProduct(vector3D);
        if (FastMath.abs(d) < 1.0E-10) {
            return null;
        }
        Point point = line.toSpace((Point)Vector1D.ZERO);
        double d2 = -(this.originOffset + this.w.dotProduct((Vector<Euclidean3D>)point)) / d;
        return new Vector3D(1.0, (Vector3D)point, d2, vector3D);
    }

    public Line intersection(Plane plane) {
        Vector3D vector3D = Vector3D.crossProduct(this.w, plane.w);
        if (vector3D.getNorm() < this.tolerance) {
            return null;
        }
        Vector3D vector3D2 = Plane.intersection(this, plane, new Plane(vector3D, this.tolerance));
        return new Line(vector3D2, (Vector3D)vector3D2.add((Vector)vector3D), this.tolerance);
    }

    public static Vector3D intersection(Plane plane, Plane plane2, Plane plane3) {
        double d = plane.w.getX();
        double d2 = plane.w.getY();
        double d3 = plane.w.getZ();
        double d4 = plane.originOffset;
        double d5 = plane2.w.getX();
        double d6 = plane2.w.getY();
        double d7 = plane2.w.getZ();
        double d8 = plane2.originOffset;
        double d9 = plane3.w.getX();
        double d10 = plane3.w.getY();
        double d11 = plane3.w.getZ();
        double d12 = plane3.originOffset;
        double d13 = d6 * d11 - d10 * d7;
        double d14 = d7 * d9 - d11 * d5;
        double d15 = d5 * d10 - d9 * d6;
        double d16 = d * d13 + d2 * d14 + d3 * d15;
        if (FastMath.abs(d16) < 1.0E-10) {
            return null;
        }
        double d17 = 1.0 / d16;
        return new Vector3D((-d13 * d4 - (d3 * d10 - d11 * d2) * d8 - (d7 * d2 - d3 * d6) * d12) * d17, (-d14 * d4 - (d11 * d - d3 * d9) * d8 - (d3 * d5 - d7 * d) * d12) * d17, (-d15 * d4 - (d2 * d9 - d10 * d) * d8 - (d6 * d - d2 * d5) * d12) * d17);
    }

    public SubPlane wholeHyperplane() {
        return new SubPlane(this, new PolygonsSet(this.tolerance));
    }

    public PolyhedronsSet wholeSpace() {
        return new PolyhedronsSet(this.tolerance);
    }

    public boolean contains(Vector3D vector3D) {
        return FastMath.abs(this.getOffset(vector3D)) < this.tolerance;
    }

    public double getOffset(Plane plane) {
        return this.originOffset + (this.sameOrientationAs(plane) ? -plane.originOffset : plane.originOffset);
    }

    @Override
    public double getOffset(Vector<Euclidean3D> vector) {
        return this.getOffset((Point<Euclidean3D>)vector);
    }

    @Override
    public double getOffset(Point<Euclidean3D> point) {
        return ((Vector3D)point).dotProduct(this.w) + this.originOffset;
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean3D> hyperplane) {
        return ((Plane)hyperplane).w.dotProduct(this.w) > 0.0;
    }
}

