/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.euclidean.threed.CardanEulerSingularityException;
import org.apache.commons.math3.geometry.euclidean.threed.NotARotationMatrixException;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class Rotation
implements Serializable {
    public static final Rotation IDENTITY = new Rotation(1.0, 0.0, 0.0, 0.0, false);
    private static final long serialVersionUID = -2153622329907944313L;
    private final double q0;
    private final double q1;
    private final double q2;
    private final double q3;

    public Rotation(double d, double d2, double d3, double d4, boolean bl) {
        if (bl) {
            double d5 = 1.0 / FastMath.sqrt(d * d + d2 * d2 + d3 * d3 + d4 * d4);
            d *= d5;
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
    }

    @Deprecated
    public Rotation(Vector3D vector3D, double d) {
        this(vector3D, d, RotationConvention.VECTOR_OPERATOR);
    }

    public Rotation(Vector3D vector3D, double d, RotationConvention rotationConvention) {
        double d2 = vector3D.getNorm();
        if (d2 == 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_AXIS, new Object[0]);
        }
        double d3 = rotationConvention == RotationConvention.VECTOR_OPERATOR ? -0.5 * d : 0.5 * d;
        double d4 = FastMath.sin(d3) / d2;
        this.q0 = FastMath.cos(d3);
        this.q1 = d4 * vector3D.getX();
        this.q2 = d4 * vector3D.getY();
        this.q3 = d4 * vector3D.getZ();
    }

    public Rotation(double[][] dArray, double d) {
        if (dArray.length != 3 || dArray[0].length != 3 || dArray[1].length != 3 || dArray[2].length != 3) {
            throw new NotARotationMatrixException(LocalizedFormats.ROTATION_MATRIX_DIMENSIONS, dArray.length, dArray[0].length);
        }
        double[][] dArray2 = this.orthogonalizeMatrix(dArray, d);
        double d2 = dArray2[0][0] * (dArray2[1][1] * dArray2[2][2] - dArray2[2][1] * dArray2[1][2]) - dArray2[1][0] * (dArray2[0][1] * dArray2[2][2] - dArray2[2][1] * dArray2[0][2]) + dArray2[2][0] * (dArray2[0][1] * dArray2[1][2] - dArray2[1][1] * dArray2[0][2]);
        if (d2 < 0.0) {
            throw new NotARotationMatrixException(LocalizedFormats.CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT, d2);
        }
        double[] dArray3 = Rotation.mat2quat(dArray2);
        this.q0 = dArray3[0];
        this.q1 = dArray3[1];
        this.q2 = dArray3[2];
        this.q3 = dArray3[3];
    }

    public Rotation(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        Vector3D vector3D5 = vector3D.crossProduct(vector3D2).normalize();
        vector3D2 = vector3D5.crossProduct(vector3D).normalize();
        vector3D = vector3D.normalize();
        Vector3D vector3D6 = vector3D3.crossProduct(vector3D4).normalize();
        vector3D4 = vector3D6.crossProduct(vector3D3).normalize();
        vector3D3 = vector3D3.normalize();
        double[][] dArrayArray = new double[][]{{MathArrays.linearCombination(vector3D.getX(), vector3D3.getX(), vector3D2.getX(), vector3D4.getX(), vector3D5.getX(), vector3D6.getX()), MathArrays.linearCombination(vector3D.getY(), vector3D3.getX(), vector3D2.getY(), vector3D4.getX(), vector3D5.getY(), vector3D6.getX()), MathArrays.linearCombination(vector3D.getZ(), vector3D3.getX(), vector3D2.getZ(), vector3D4.getX(), vector3D5.getZ(), vector3D6.getX())}, {MathArrays.linearCombination(vector3D.getX(), vector3D3.getY(), vector3D2.getX(), vector3D4.getY(), vector3D5.getX(), vector3D6.getY()), MathArrays.linearCombination(vector3D.getY(), vector3D3.getY(), vector3D2.getY(), vector3D4.getY(), vector3D5.getY(), vector3D6.getY()), MathArrays.linearCombination(vector3D.getZ(), vector3D3.getY(), vector3D2.getZ(), vector3D4.getY(), vector3D5.getZ(), vector3D6.getY())}, {MathArrays.linearCombination(vector3D.getX(), vector3D3.getZ(), vector3D2.getX(), vector3D4.getZ(), vector3D5.getX(), vector3D6.getZ()), MathArrays.linearCombination(vector3D.getY(), vector3D3.getZ(), vector3D2.getY(), vector3D4.getZ(), vector3D5.getY(), vector3D6.getZ()), MathArrays.linearCombination(vector3D.getZ(), vector3D3.getZ(), vector3D2.getZ(), vector3D4.getZ(), vector3D5.getZ(), vector3D6.getZ())}};
        double[] dArray = Rotation.mat2quat(dArrayArray);
        this.q0 = dArray[0];
        this.q1 = dArray[1];
        this.q2 = dArray[2];
        this.q3 = dArray[3];
    }

    public Rotation(Vector3D vector3D, Vector3D vector3D2) {
        double d = vector3D.getNorm() * vector3D2.getNorm();
        if (d == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR, new Object[0]);
        }
        double d2 = vector3D.dotProduct(vector3D2);
        if (d2 < -0.999999999999998 * d) {
            Vector3D vector3D3 = vector3D.orthogonal();
            this.q0 = 0.0;
            this.q1 = -vector3D3.getX();
            this.q2 = -vector3D3.getY();
            this.q3 = -vector3D3.getZ();
        } else {
            this.q0 = FastMath.sqrt(0.5 * (1.0 + d2 / d));
            double d3 = 1.0 / (2.0 * this.q0 * d);
            Vector3D vector3D4 = vector3D2.crossProduct(vector3D);
            this.q1 = d3 * vector3D4.getX();
            this.q2 = d3 * vector3D4.getY();
            this.q3 = d3 * vector3D4.getZ();
        }
    }

    @Deprecated
    public Rotation(RotationOrder rotationOrder, double d, double d2, double d3) {
        this(rotationOrder, RotationConvention.VECTOR_OPERATOR, d, d2, d3);
    }

    public Rotation(RotationOrder rotationOrder, RotationConvention rotationConvention, double d, double d2, double d3) {
        Rotation rotation = new Rotation(rotationOrder.getA1(), d, rotationConvention);
        Rotation rotation2 = new Rotation(rotationOrder.getA2(), d2, rotationConvention);
        Rotation rotation3 = new Rotation(rotationOrder.getA3(), d3, rotationConvention);
        Rotation rotation4 = rotation.compose(rotation2.compose(rotation3, rotationConvention), rotationConvention);
        this.q0 = rotation4.q0;
        this.q1 = rotation4.q1;
        this.q2 = rotation4.q2;
        this.q3 = rotation4.q3;
    }

    private static double[] mat2quat(double[][] dArray) {
        double[] dArray2 = new double[4];
        double d = dArray[0][0] + dArray[1][1] + dArray[2][2];
        if (d > -0.19) {
            dArray2[0] = 0.5 * FastMath.sqrt(d + 1.0);
            double d2 = 0.25 / dArray2[0];
            dArray2[1] = d2 * (dArray[1][2] - dArray[2][1]);
            dArray2[2] = d2 * (dArray[2][0] - dArray[0][2]);
            dArray2[3] = d2 * (dArray[0][1] - dArray[1][0]);
        } else {
            d = dArray[0][0] - dArray[1][1] - dArray[2][2];
            if (d > -0.19) {
                dArray2[1] = 0.5 * FastMath.sqrt(d + 1.0);
                double d3 = 0.25 / dArray2[1];
                dArray2[0] = d3 * (dArray[1][2] - dArray[2][1]);
                dArray2[2] = d3 * (dArray[0][1] + dArray[1][0]);
                dArray2[3] = d3 * (dArray[0][2] + dArray[2][0]);
            } else {
                d = dArray[1][1] - dArray[0][0] - dArray[2][2];
                if (d > -0.19) {
                    dArray2[2] = 0.5 * FastMath.sqrt(d + 1.0);
                    double d4 = 0.25 / dArray2[2];
                    dArray2[0] = d4 * (dArray[2][0] - dArray[0][2]);
                    dArray2[1] = d4 * (dArray[0][1] + dArray[1][0]);
                    dArray2[3] = d4 * (dArray[2][1] + dArray[1][2]);
                } else {
                    d = dArray[2][2] - dArray[0][0] - dArray[1][1];
                    dArray2[3] = 0.5 * FastMath.sqrt(d + 1.0);
                    double d5 = 0.25 / dArray2[3];
                    dArray2[0] = d5 * (dArray[0][1] - dArray[1][0]);
                    dArray2[1] = d5 * (dArray[0][2] + dArray[2][0]);
                    dArray2[2] = d5 * (dArray[2][1] + dArray[1][2]);
                }
            }
        }
        return dArray2;
    }

    public Rotation revert() {
        return new Rotation(-this.q0, this.q1, this.q2, this.q3, false);
    }

    public double getQ0() {
        return this.q0;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getQ3() {
        return this.q3;
    }

    @Deprecated
    public Vector3D getAxis() {
        return this.getAxis(RotationConvention.VECTOR_OPERATOR);
    }

    public Vector3D getAxis(RotationConvention rotationConvention) {
        double d;
        double d2 = this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d2 == 0.0) {
            return rotationConvention == RotationConvention.VECTOR_OPERATOR ? Vector3D.PLUS_I : Vector3D.MINUS_I;
        }
        double d3 = d = rotationConvention == RotationConvention.VECTOR_OPERATOR ? 1.0 : -1.0;
        if (this.q0 < 0.0) {
            double d4 = d / FastMath.sqrt(d2);
            return new Vector3D(this.q1 * d4, this.q2 * d4, this.q3 * d4);
        }
        double d5 = -d / FastMath.sqrt(d2);
        return new Vector3D(this.q1 * d5, this.q2 * d5, this.q3 * d5);
    }

    public double getAngle() {
        if (this.q0 < -0.1 || this.q0 > 0.1) {
            return 2.0 * FastMath.asin(FastMath.sqrt(this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3));
        }
        if (this.q0 < 0.0) {
            return 2.0 * FastMath.acos(-this.q0);
        }
        return 2.0 * FastMath.acos(this.q0);
    }

    @Deprecated
    public double[] getAngles(RotationOrder rotationOrder) {
        return this.getAngles(rotationOrder, RotationConvention.VECTOR_OPERATOR);
    }

    public double[] getAngles(RotationOrder rotationOrder, RotationConvention rotationConvention) {
        if (rotationConvention == RotationConvention.VECTOR_OPERATOR) {
            if (rotationOrder == RotationOrder.XYZ) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
                Vector3D vector3D2 = this.applyInverseTo(Vector3D.PLUS_I);
                if (vector3D2.getZ() < -0.9999999999 || vector3D2.getZ() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(-vector3D.getY(), vector3D.getZ()), FastMath.asin(vector3D2.getZ()), FastMath.atan2(-vector3D2.getY(), vector3D2.getX())};
            }
            if (rotationOrder == RotationOrder.XZY) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
                Vector3D vector3D3 = this.applyInverseTo(Vector3D.PLUS_I);
                if (vector3D3.getY() < -0.9999999999 || vector3D3.getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(vector3D.getZ(), vector3D.getY()), -FastMath.asin(vector3D3.getY()), FastMath.atan2(vector3D3.getZ(), vector3D3.getX())};
            }
            if (rotationOrder == RotationOrder.YXZ) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
                Vector3D vector3D4 = this.applyInverseTo(Vector3D.PLUS_J);
                if (vector3D4.getZ() < -0.9999999999 || vector3D4.getZ() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(vector3D.getX(), vector3D.getZ()), -FastMath.asin(vector3D4.getZ()), FastMath.atan2(vector3D4.getX(), vector3D4.getY())};
            }
            if (rotationOrder == RotationOrder.YZX) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
                Vector3D vector3D5 = this.applyInverseTo(Vector3D.PLUS_J);
                if (vector3D5.getX() < -0.9999999999 || vector3D5.getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(-vector3D.getZ(), vector3D.getX()), FastMath.asin(vector3D5.getX()), FastMath.atan2(-vector3D5.getZ(), vector3D5.getY())};
            }
            if (rotationOrder == RotationOrder.ZXY) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
                Vector3D vector3D6 = this.applyInverseTo(Vector3D.PLUS_K);
                if (vector3D6.getY() < -0.9999999999 || vector3D6.getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(-vector3D.getX(), vector3D.getY()), FastMath.asin(vector3D6.getY()), FastMath.atan2(-vector3D6.getX(), vector3D6.getZ())};
            }
            if (rotationOrder == RotationOrder.ZYX) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
                Vector3D vector3D7 = this.applyInverseTo(Vector3D.PLUS_K);
                if (vector3D7.getX() < -0.9999999999 || vector3D7.getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(true);
                }
                return new double[]{FastMath.atan2(vector3D.getY(), vector3D.getX()), -FastMath.asin(vector3D7.getX()), FastMath.atan2(vector3D7.getY(), vector3D7.getZ())};
            }
            if (rotationOrder == RotationOrder.XYX) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
                Vector3D vector3D8 = this.applyInverseTo(Vector3D.PLUS_I);
                if (vector3D8.getX() < -0.9999999999 || vector3D8.getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(vector3D.getY(), -vector3D.getZ()), FastMath.acos(vector3D8.getX()), FastMath.atan2(vector3D8.getY(), vector3D8.getZ())};
            }
            if (rotationOrder == RotationOrder.XZX) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
                Vector3D vector3D9 = this.applyInverseTo(Vector3D.PLUS_I);
                if (vector3D9.getX() < -0.9999999999 || vector3D9.getX() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(vector3D.getZ(), vector3D.getY()), FastMath.acos(vector3D9.getX()), FastMath.atan2(vector3D9.getZ(), -vector3D9.getY())};
            }
            if (rotationOrder == RotationOrder.YXY) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
                Vector3D vector3D10 = this.applyInverseTo(Vector3D.PLUS_J);
                if (vector3D10.getY() < -0.9999999999 || vector3D10.getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(vector3D.getX(), vector3D.getZ()), FastMath.acos(vector3D10.getY()), FastMath.atan2(vector3D10.getX(), -vector3D10.getZ())};
            }
            if (rotationOrder == RotationOrder.YZY) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
                Vector3D vector3D11 = this.applyInverseTo(Vector3D.PLUS_J);
                if (vector3D11.getY() < -0.9999999999 || vector3D11.getY() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(vector3D.getZ(), -vector3D.getX()), FastMath.acos(vector3D11.getY()), FastMath.atan2(vector3D11.getZ(), vector3D11.getX())};
            }
            if (rotationOrder == RotationOrder.ZXZ) {
                Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
                Vector3D vector3D12 = this.applyInverseTo(Vector3D.PLUS_K);
                if (vector3D12.getZ() < -0.9999999999 || vector3D12.getZ() > 0.9999999999) {
                    throw new CardanEulerSingularityException(false);
                }
                return new double[]{FastMath.atan2(vector3D.getX(), -vector3D.getY()), FastMath.acos(vector3D12.getZ()), FastMath.atan2(vector3D12.getX(), vector3D12.getY())};
            }
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
            Vector3D vector3D13 = this.applyInverseTo(Vector3D.PLUS_K);
            if (vector3D13.getZ() < -0.9999999999 || vector3D13.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(vector3D.getY(), vector3D.getX()), FastMath.acos(vector3D13.getZ()), FastMath.atan2(vector3D13.getY(), -vector3D13.getX())};
        }
        if (rotationOrder == RotationOrder.XYZ) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
            Vector3D vector3D14 = this.applyInverseTo(Vector3D.PLUS_K);
            if (vector3D14.getX() < -0.9999999999 || vector3D14.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(-vector3D14.getY(), vector3D14.getZ()), FastMath.asin(vector3D14.getX()), FastMath.atan2(-vector3D.getY(), vector3D.getX())};
        }
        if (rotationOrder == RotationOrder.XZY) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
            Vector3D vector3D15 = this.applyInverseTo(Vector3D.PLUS_J);
            if (vector3D15.getX() < -0.9999999999 || vector3D15.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(vector3D15.getZ(), vector3D15.getY()), -FastMath.asin(vector3D15.getX()), FastMath.atan2(vector3D.getZ(), vector3D.getX())};
        }
        if (rotationOrder == RotationOrder.YXZ) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
            Vector3D vector3D16 = this.applyInverseTo(Vector3D.PLUS_K);
            if (vector3D16.getY() < -0.9999999999 || vector3D16.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(vector3D16.getX(), vector3D16.getZ()), -FastMath.asin(vector3D16.getY()), FastMath.atan2(vector3D.getX(), vector3D.getY())};
        }
        if (rotationOrder == RotationOrder.YZX) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
            Vector3D vector3D17 = this.applyInverseTo(Vector3D.PLUS_I);
            if (vector3D17.getY() < -0.9999999999 || vector3D17.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(-vector3D17.getZ(), vector3D17.getX()), FastMath.asin(vector3D17.getY()), FastMath.atan2(-vector3D.getZ(), vector3D.getY())};
        }
        if (rotationOrder == RotationOrder.ZXY) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
            Vector3D vector3D18 = this.applyInverseTo(Vector3D.PLUS_J);
            if (vector3D18.getZ() < -0.9999999999 || vector3D18.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(-vector3D18.getX(), vector3D18.getY()), FastMath.asin(vector3D18.getZ()), FastMath.atan2(-vector3D.getX(), vector3D.getZ())};
        }
        if (rotationOrder == RotationOrder.ZYX) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
            Vector3D vector3D19 = this.applyInverseTo(Vector3D.PLUS_I);
            if (vector3D19.getZ() < -0.9999999999 || vector3D19.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{FastMath.atan2(vector3D19.getY(), vector3D19.getX()), -FastMath.asin(vector3D19.getZ()), FastMath.atan2(vector3D.getY(), vector3D.getZ())};
        }
        if (rotationOrder == RotationOrder.XYX) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
            Vector3D vector3D20 = this.applyInverseTo(Vector3D.PLUS_I);
            if (vector3D20.getX() < -0.9999999999 || vector3D20.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(vector3D20.getY(), -vector3D20.getZ()), FastMath.acos(vector3D20.getX()), FastMath.atan2(vector3D.getY(), vector3D.getZ())};
        }
        if (rotationOrder == RotationOrder.XZX) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_I);
            Vector3D vector3D21 = this.applyInverseTo(Vector3D.PLUS_I);
            if (vector3D21.getX() < -0.9999999999 || vector3D21.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(vector3D21.getZ(), vector3D21.getY()), FastMath.acos(vector3D21.getX()), FastMath.atan2(vector3D.getZ(), -vector3D.getY())};
        }
        if (rotationOrder == RotationOrder.YXY) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
            Vector3D vector3D22 = this.applyInverseTo(Vector3D.PLUS_J);
            if (vector3D22.getY() < -0.9999999999 || vector3D22.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(vector3D22.getX(), vector3D22.getZ()), FastMath.acos(vector3D22.getY()), FastMath.atan2(vector3D.getX(), -vector3D.getZ())};
        }
        if (rotationOrder == RotationOrder.YZY) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_J);
            Vector3D vector3D23 = this.applyInverseTo(Vector3D.PLUS_J);
            if (vector3D23.getY() < -0.9999999999 || vector3D23.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(vector3D23.getZ(), -vector3D23.getX()), FastMath.acos(vector3D23.getY()), FastMath.atan2(vector3D.getZ(), vector3D.getX())};
        }
        if (rotationOrder == RotationOrder.ZXZ) {
            Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
            Vector3D vector3D24 = this.applyInverseTo(Vector3D.PLUS_K);
            if (vector3D24.getZ() < -0.9999999999 || vector3D24.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{FastMath.atan2(vector3D24.getX(), -vector3D24.getY()), FastMath.acos(vector3D24.getZ()), FastMath.atan2(vector3D.getX(), vector3D.getY())};
        }
        Vector3D vector3D = this.applyTo(Vector3D.PLUS_K);
        Vector3D vector3D25 = this.applyInverseTo(Vector3D.PLUS_K);
        if (vector3D25.getZ() < -0.9999999999 || vector3D25.getZ() > 0.9999999999) {
            throw new CardanEulerSingularityException(false);
        }
        return new double[]{FastMath.atan2(vector3D25.getY(), vector3D25.getX()), FastMath.acos(vector3D25.getZ()), FastMath.atan2(vector3D.getY(), -vector3D.getX())};
    }

    public double[][] getMatrix() {
        double d = this.q0 * this.q0;
        double d2 = this.q0 * this.q1;
        double d3 = this.q0 * this.q2;
        double d4 = this.q0 * this.q3;
        double d5 = this.q1 * this.q1;
        double d6 = this.q1 * this.q2;
        double d7 = this.q1 * this.q3;
        double d8 = this.q2 * this.q2;
        double d9 = this.q2 * this.q3;
        double d10 = this.q3 * this.q3;
        double[][] dArrayArray = new double[][]{new double[3], new double[3], new double[3]};
        dArrayArray[0][0] = 2.0 * (d + d5) - 1.0;
        dArrayArray[1][0] = 2.0 * (d6 - d4);
        dArrayArray[2][0] = 2.0 * (d7 + d3);
        dArrayArray[0][1] = 2.0 * (d6 + d4);
        dArrayArray[1][1] = 2.0 * (d + d8) - 1.0;
        dArrayArray[2][1] = 2.0 * (d9 - d2);
        dArrayArray[0][2] = 2.0 * (d7 - d3);
        dArrayArray[1][2] = 2.0 * (d9 + d2);
        dArrayArray[2][2] = 2.0 * (d + d10) - 1.0;
        return dArrayArray;
    }

    public Vector3D applyTo(Vector3D vector3D) {
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        return new Vector3D(2.0 * (this.q0 * (d * this.q0 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d, 2.0 * (this.q0 * (d2 * this.q0 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2, 2.0 * (this.q0 * (d3 * this.q0 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3);
    }

    public void applyTo(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        dArray2[0] = 2.0 * (this.q0 * (d * this.q0 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d;
        dArray2[1] = 2.0 * (this.q0 * (d2 * this.q0 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2;
        dArray2[2] = 2.0 * (this.q0 * (d3 * this.q0 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3;
    }

    public Vector3D applyInverseTo(Vector3D vector3D) {
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        double d5 = -this.q0;
        return new Vector3D(2.0 * (d5 * (d * d5 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d, 2.0 * (d5 * (d2 * d5 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2, 2.0 * (d5 * (d3 * d5 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3);
    }

    public void applyInverseTo(double[] dArray, double[] dArray2) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        double d5 = -this.q0;
        dArray2[0] = 2.0 * (d5 * (d * d5 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d;
        dArray2[1] = 2.0 * (d5 * (d2 * d5 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2;
        dArray2[2] = 2.0 * (d5 * (d3 * d5 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3;
    }

    public Rotation applyTo(Rotation rotation) {
        return this.compose(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public Rotation compose(Rotation rotation, RotationConvention rotationConvention) {
        return rotationConvention == RotationConvention.VECTOR_OPERATOR ? this.composeInternal(rotation) : rotation.composeInternal(this);
    }

    private Rotation composeInternal(Rotation rotation) {
        return new Rotation(rotation.q0 * this.q0 - (rotation.q1 * this.q1 + rotation.q2 * this.q2 + rotation.q3 * this.q3), rotation.q1 * this.q0 + rotation.q0 * this.q1 + (rotation.q2 * this.q3 - rotation.q3 * this.q2), rotation.q2 * this.q0 + rotation.q0 * this.q2 + (rotation.q3 * this.q1 - rotation.q1 * this.q3), rotation.q3 * this.q0 + rotation.q0 * this.q3 + (rotation.q1 * this.q2 - rotation.q2 * this.q1), false);
    }

    public Rotation applyInverseTo(Rotation rotation) {
        return this.composeInverse(rotation, RotationConvention.VECTOR_OPERATOR);
    }

    public Rotation composeInverse(Rotation rotation, RotationConvention rotationConvention) {
        return rotationConvention == RotationConvention.VECTOR_OPERATOR ? this.composeInverseInternal(rotation) : rotation.composeInternal(this.revert());
    }

    private Rotation composeInverseInternal(Rotation rotation) {
        return new Rotation(-rotation.q0 * this.q0 - (rotation.q1 * this.q1 + rotation.q2 * this.q2 + rotation.q3 * this.q3), -rotation.q1 * this.q0 + rotation.q0 * this.q1 + (rotation.q2 * this.q3 - rotation.q3 * this.q2), -rotation.q2 * this.q0 + rotation.q0 * this.q2 + (rotation.q3 * this.q1 - rotation.q1 * this.q3), -rotation.q3 * this.q0 + rotation.q0 * this.q3 + (rotation.q1 * this.q2 - rotation.q2 * this.q1), false);
    }

    private double[][] orthogonalizeMatrix(double[][] dArray, double d) {
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        double[] dArray4 = dArray[2];
        double d2 = dArray2[0];
        double d3 = dArray2[1];
        double d4 = dArray2[2];
        double d5 = dArray3[0];
        double d6 = dArray3[1];
        double d7 = dArray3[2];
        double d8 = dArray4[0];
        double d9 = dArray4[1];
        double d10 = dArray4[2];
        double d11 = 0.0;
        double[][] dArray5 = new double[3][3];
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        double[] dArray8 = dArray5[2];
        int n = 0;
        while (++n < 11) {
            double d12 = dArray2[0] * d2 + dArray3[0] * d5 + dArray4[0] * d8;
            double d13 = dArray2[1] * d2 + dArray3[1] * d5 + dArray4[1] * d8;
            double d14 = dArray2[2] * d2 + dArray3[2] * d5 + dArray4[2] * d8;
            double d15 = dArray2[0] * d3 + dArray3[0] * d6 + dArray4[0] * d9;
            double d16 = dArray2[1] * d3 + dArray3[1] * d6 + dArray4[1] * d9;
            double d17 = dArray2[2] * d3 + dArray3[2] * d6 + dArray4[2] * d9;
            double d18 = dArray2[0] * d4 + dArray3[0] * d7 + dArray4[0] * d10;
            double d19 = dArray2[1] * d4 + dArray3[1] * d7 + dArray4[1] * d10;
            double d20 = dArray2[2] * d4 + dArray3[2] * d7 + dArray4[2] * d10;
            dArray6[0] = d2 - 0.5 * (d2 * d12 + d3 * d13 + d4 * d14 - dArray2[0]);
            dArray6[1] = d3 - 0.5 * (d2 * d15 + d3 * d16 + d4 * d17 - dArray2[1]);
            dArray6[2] = d4 - 0.5 * (d2 * d18 + d3 * d19 + d4 * d20 - dArray2[2]);
            dArray7[0] = d5 - 0.5 * (d5 * d12 + d6 * d13 + d7 * d14 - dArray3[0]);
            dArray7[1] = d6 - 0.5 * (d5 * d15 + d6 * d16 + d7 * d17 - dArray3[1]);
            dArray7[2] = d7 - 0.5 * (d5 * d18 + d6 * d19 + d7 * d20 - dArray3[2]);
            dArray8[0] = d8 - 0.5 * (d8 * d12 + d9 * d13 + d10 * d14 - dArray4[0]);
            dArray8[1] = d9 - 0.5 * (d8 * d15 + d9 * d16 + d10 * d17 - dArray4[1]);
            dArray8[2] = d10 - 0.5 * (d8 * d18 + d9 * d19 + d10 * d20 - dArray4[2]);
            double d21 = dArray6[0] - dArray2[0];
            double d22 = dArray6[1] - dArray2[1];
            double d23 = dArray6[2] - dArray2[2];
            double d24 = dArray7[0] - dArray3[0];
            double d25 = dArray7[1] - dArray3[1];
            double d26 = dArray7[2] - dArray3[2];
            double d27 = dArray8[0] - dArray4[0];
            double d28 = dArray8[1] - dArray4[1];
            double d29 = dArray8[2] - dArray4[2];
            double d30 = d21 * d21 + d22 * d22 + d23 * d23 + d24 * d24 + d25 * d25 + d26 * d26 + d27 * d27 + d28 * d28 + d29 * d29;
            if (FastMath.abs(d30 - d11) <= d) {
                return dArray5;
            }
            d2 = dArray6[0];
            d3 = dArray6[1];
            d4 = dArray6[2];
            d5 = dArray7[0];
            d6 = dArray7[1];
            d7 = dArray7[2];
            d8 = dArray8[0];
            d9 = dArray8[1];
            d10 = dArray8[2];
            d11 = d30;
        }
        throw new NotARotationMatrixException(LocalizedFormats.UNABLE_TO_ORTHOGONOLIZE_MATRIX, n - 1);
    }

    public static double distance(Rotation rotation, Rotation rotation2) {
        return rotation.composeInverseInternal(rotation2).getAngle();
    }
}

