/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;

public class SphericalCoordinates
implements Serializable {
    private static final long serialVersionUID = 20130206L;
    private final Vector3D v;
    private final double r;
    private final double theta;
    private final double phi;
    private double[][] jacobian;
    private double[][] rHessian;
    private double[][] thetaHessian;
    private double[][] phiHessian;

    public SphericalCoordinates(Vector3D vector3D) {
        this.v = vector3D;
        this.r = vector3D.getNorm();
        this.theta = vector3D.getAlpha();
        this.phi = FastMath.acos(vector3D.getZ() / this.r);
    }

    public SphericalCoordinates(double d, double d2, double d3) {
        double d4 = FastMath.cos(d2);
        double d5 = FastMath.sin(d2);
        double d6 = FastMath.cos(d3);
        double d7 = FastMath.sin(d3);
        this.r = d;
        this.theta = d2;
        this.phi = d3;
        this.v = new Vector3D(d * d4 * d7, d * d5 * d7, d * d6);
    }

    public Vector3D getCartesian() {
        return this.v;
    }

    public double getR() {
        return this.r;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getPhi() {
        return this.phi;
    }

    public double[] toCartesianGradient(double[] dArray) {
        this.computeJacobian();
        return new double[]{dArray[0] * this.jacobian[0][0] + dArray[1] * this.jacobian[1][0] + dArray[2] * this.jacobian[2][0], dArray[0] * this.jacobian[0][1] + dArray[1] * this.jacobian[1][1] + dArray[2] * this.jacobian[2][1], dArray[0] * this.jacobian[0][2] + dArray[2] * this.jacobian[2][2]};
    }

    public double[][] toCartesianHessian(double[][] dArray, double[] dArray2) {
        this.computeJacobian();
        this.computeHessians();
        double[][] dArray3 = new double[3][3];
        double[][] dArray4 = new double[3][3];
        dArray3[0][0] = dArray[0][0] * this.jacobian[0][0] + dArray[1][0] * this.jacobian[1][0] + dArray[2][0] * this.jacobian[2][0];
        dArray3[0][1] = dArray[0][0] * this.jacobian[0][1] + dArray[1][0] * this.jacobian[1][1] + dArray[2][0] * this.jacobian[2][1];
        dArray3[0][2] = dArray[0][0] * this.jacobian[0][2] + dArray[2][0] * this.jacobian[2][2];
        dArray3[1][0] = dArray[1][0] * this.jacobian[0][0] + dArray[1][1] * this.jacobian[1][0] + dArray[2][1] * this.jacobian[2][0];
        dArray3[1][1] = dArray[1][0] * this.jacobian[0][1] + dArray[1][1] * this.jacobian[1][1] + dArray[2][1] * this.jacobian[2][1];
        dArray3[2][0] = dArray[2][0] * this.jacobian[0][0] + dArray[2][1] * this.jacobian[1][0] + dArray[2][2] * this.jacobian[2][0];
        dArray3[2][1] = dArray[2][0] * this.jacobian[0][1] + dArray[2][1] * this.jacobian[1][1] + dArray[2][2] * this.jacobian[2][1];
        dArray3[2][2] = dArray[2][0] * this.jacobian[0][2] + dArray[2][2] * this.jacobian[2][2];
        dArray4[0][0] = this.jacobian[0][0] * dArray3[0][0] + this.jacobian[1][0] * dArray3[1][0] + this.jacobian[2][0] * dArray3[2][0];
        dArray4[1][0] = this.jacobian[0][1] * dArray3[0][0] + this.jacobian[1][1] * dArray3[1][0] + this.jacobian[2][1] * dArray3[2][0];
        dArray4[2][0] = this.jacobian[0][2] * dArray3[0][0] + this.jacobian[2][2] * dArray3[2][0];
        dArray4[1][1] = this.jacobian[0][1] * dArray3[0][1] + this.jacobian[1][1] * dArray3[1][1] + this.jacobian[2][1] * dArray3[2][1];
        dArray4[2][1] = this.jacobian[0][2] * dArray3[0][1] + this.jacobian[2][2] * dArray3[2][1];
        dArray4[2][2] = this.jacobian[0][2] * dArray3[0][2] + this.jacobian[2][2] * dArray3[2][2];
        double[] dArray5 = dArray4[0];
        dArray5[0] = dArray5[0] + (dArray2[0] * this.rHessian[0][0] + dArray2[1] * this.thetaHessian[0][0] + dArray2[2] * this.phiHessian[0][0]);
        double[] dArray6 = dArray4[1];
        dArray6[0] = dArray6[0] + (dArray2[0] * this.rHessian[1][0] + dArray2[1] * this.thetaHessian[1][0] + dArray2[2] * this.phiHessian[1][0]);
        double[] dArray7 = dArray4[2];
        dArray7[0] = dArray7[0] + (dArray2[0] * this.rHessian[2][0] + dArray2[2] * this.phiHessian[2][0]);
        double[] dArray8 = dArray4[1];
        dArray8[1] = dArray8[1] + (dArray2[0] * this.rHessian[1][1] + dArray2[1] * this.thetaHessian[1][1] + dArray2[2] * this.phiHessian[1][1]);
        double[] dArray9 = dArray4[2];
        dArray9[1] = dArray9[1] + (dArray2[0] * this.rHessian[2][1] + dArray2[2] * this.phiHessian[2][1]);
        double[] dArray10 = dArray4[2];
        dArray10[2] = dArray10[2] + (dArray2[0] * this.rHessian[2][2] + dArray2[2] * this.phiHessian[2][2]);
        dArray4[0][1] = dArray4[1][0];
        dArray4[0][2] = dArray4[2][0];
        dArray4[1][2] = dArray4[2][1];
        return dArray4;
    }

    private void computeJacobian() {
        if (this.jacobian == null) {
            double d = this.v.getX();
            double d2 = this.v.getY();
            double d3 = this.v.getZ();
            double d4 = d * d + d2 * d2;
            double d5 = FastMath.sqrt(d4);
            double d6 = d4 + d3 * d3;
            this.jacobian = new double[3][3];
            this.jacobian[0][0] = d / this.r;
            this.jacobian[0][1] = d2 / this.r;
            this.jacobian[0][2] = d3 / this.r;
            this.jacobian[1][0] = -d2 / d4;
            this.jacobian[1][1] = d / d4;
            this.jacobian[2][0] = d * d3 / (d5 * d6);
            this.jacobian[2][1] = d2 * d3 / (d5 * d6);
            this.jacobian[2][2] = -d5 / d6;
        }
    }

    private void computeHessians() {
        if (this.rHessian == null) {
            double d = this.v.getX();
            double d2 = this.v.getY();
            double d3 = this.v.getZ();
            double d4 = d * d;
            double d5 = d2 * d2;
            double d6 = d3 * d3;
            double d7 = d4 + d5;
            double d8 = FastMath.sqrt(d7);
            double d9 = d7 + d6;
            double d10 = d / this.r;
            double d11 = d2 / this.r;
            double d12 = d3 / this.r;
            double d13 = d / d7;
            double d14 = d2 / d7;
            double d15 = d10 / d9;
            double d16 = d11 / d9;
            double d17 = d12 / d9;
            this.rHessian = new double[3][3];
            this.rHessian[0][0] = d2 * d16 + d3 * d17;
            this.rHessian[1][0] = -d * d16;
            this.rHessian[2][0] = -d3 * d15;
            this.rHessian[1][1] = d * d15 + d3 * d17;
            this.rHessian[2][1] = -d2 * d17;
            this.rHessian[2][2] = d * d15 + d2 * d16;
            this.rHessian[0][1] = this.rHessian[1][0];
            this.rHessian[0][2] = this.rHessian[2][0];
            this.rHessian[1][2] = this.rHessian[2][1];
            this.thetaHessian = new double[2][2];
            this.thetaHessian[0][0] = 2.0 * d13 * d14;
            this.thetaHessian[1][0] = d14 * d14 - d13 * d13;
            this.thetaHessian[1][1] = -2.0 * d13 * d14;
            this.thetaHessian[0][1] = this.thetaHessian[1][0];
            double d18 = d8 * d9;
            double d19 = d8 * d18;
            double d20 = d18 * d9;
            double d21 = d20 * d7;
            double d22 = 3.0 * d7 + d6;
            this.phiHessian = new double[3][3];
            this.phiHessian[0][0] = d3 * (d19 - d4 * d22) / d21;
            this.phiHessian[1][0] = -d * d2 * d3 * d22 / d21;
            this.phiHessian[2][0] = d * (d7 - d6) / d20;
            this.phiHessian[1][1] = d3 * (d19 - d5 * d22) / d21;
            this.phiHessian[2][1] = d2 * (d7 - d6) / d20;
            this.phiHessian[2][2] = 2.0 * d8 * d17 / this.r;
            this.phiHessian[0][1] = this.phiHessian[1][0];
            this.phiHessian[0][2] = this.phiHessian[2][0];
            this.phiHessian[1][2] = this.phiHessian[2][1];
        }
    }

    private Object writeReplace() {
        return new DataTransferObject(this.v.getX(), this.v.getY(), this.v.getZ());
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20130206L;
        private final double x;
        private final double y;
        private final double z;

        DataTransferObject(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        private Object readResolve() {
            return new SphericalCoordinates(new Vector3D(this.x, this.y, this.z));
        }
    }
}

