/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.SubLine;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

class NestedLoops {
    private Vector2D[] loop;
    private List<NestedLoops> surrounded;
    private Region<Euclidean2D> polygon;
    private boolean originalIsClockwise;
    private final double tolerance;

    NestedLoops(double d) {
        this.surrounded = new ArrayList<NestedLoops>();
        this.tolerance = d;
    }

    private NestedLoops(Vector2D[] vector2DArray, double d) {
        if (vector2DArray[0] == null) {
            throw new MathIllegalArgumentException(LocalizedFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
        }
        this.loop = vector2DArray;
        this.surrounded = new ArrayList<NestedLoops>();
        this.tolerance = d;
        ArrayList<SubHyperplane<Euclidean2D>> arrayList = new ArrayList<SubHyperplane<Euclidean2D>>();
        Vector2D vector2D = vector2DArray[vector2DArray.length - 1];
        for (int i = 0; i < vector2DArray.length; ++i) {
            Vector2D vector2D2 = vector2D;
            vector2D = vector2DArray[i];
            Line line = new Line(vector2D2, vector2D, d);
            IntervalsSet intervalsSet = new IntervalsSet(((Vector1D)line.toSubSpace((Point)vector2D2)).getX(), ((Vector1D)line.toSubSpace((Point)vector2D)).getX(), d);
            arrayList.add(new SubLine(line, intervalsSet));
        }
        this.polygon = new PolygonsSet((Collection<SubHyperplane<Euclidean2D>>)arrayList, d);
        if (Double.isInfinite(this.polygon.getSize())) {
            this.polygon = new RegionFactory<Euclidean2D>().getComplement(this.polygon);
            this.originalIsClockwise = false;
        } else {
            this.originalIsClockwise = true;
        }
    }

    public void add(Vector2D[] vector2DArray) {
        this.add(new NestedLoops(vector2DArray, this.tolerance));
    }

    private void add(NestedLoops nestedLoops) {
        for (NestedLoops object2 : this.surrounded) {
            if (!object2.polygon.contains(nestedLoops.polygon)) continue;
            object2.add(nestedLoops);
            return;
        }
        Object object = this.surrounded.iterator();
        while (object.hasNext()) {
            NestedLoops nestedLoops2 = object.next();
            if (!nestedLoops.polygon.contains(nestedLoops2.polygon)) continue;
            nestedLoops.surrounded.add(nestedLoops2);
            object.remove();
        }
        object = new RegionFactory();
        for (NestedLoops nestedLoops3 : this.surrounded) {
            if (((RegionFactory)object).intersection(nestedLoops.polygon, nestedLoops3.polygon).isEmpty()) continue;
            throw new MathIllegalArgumentException(LocalizedFormats.CROSSING_BOUNDARY_LOOPS, new Object[0]);
        }
        this.surrounded.add(nestedLoops);
    }

    public void correctOrientation() {
        for (NestedLoops nestedLoops : this.surrounded) {
            nestedLoops.setClockWise(true);
        }
    }

    private void setClockWise(boolean bl) {
        if (this.originalIsClockwise ^ bl) {
            int n = -1;
            int n2 = this.loop.length;
            while (++n < --n2) {
                Vector2D vector2D = this.loop[n];
                this.loop[n] = this.loop[n2];
                this.loop[n2] = vector2D;
            }
        }
        for (NestedLoops nestedLoops : this.surrounded) {
            nestedLoops.setClockWise(!bl);
        }
    }
}

