/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Segment;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.AbstractRegion;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.NodesSet;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonsSet
extends AbstractRegion<Euclidean2D, Euclidean1D> {
    private static final double DEFAULT_TOLERANCE = 1.0E-10;
    private Vector2D[][] vertices;

    public PolygonsSet(double d) {
        super(d);
    }

    public PolygonsSet(BSPTree<Euclidean2D> bSPTree, double d) {
        super(bSPTree, d);
    }

    public PolygonsSet(Collection<SubHyperplane<Euclidean2D>> collection, double d) {
        super(collection, d);
    }

    public PolygonsSet(double d, double d2, double d3, double d4, double d5) {
        super(PolygonsSet.boxBoundary(d, d2, d3, d4, d5), d5);
    }

    public PolygonsSet(double d, Vector2D ... vector2DArray) {
        super(PolygonsSet.verticesToTree(d, vector2DArray), d);
    }

    @Deprecated
    public PolygonsSet() {
        this(1.0E-10);
    }

    @Deprecated
    public PolygonsSet(BSPTree<Euclidean2D> bSPTree) {
        this(bSPTree, 1.0E-10);
    }

    @Deprecated
    public PolygonsSet(Collection<SubHyperplane<Euclidean2D>> collection) {
        this(collection, 1.0E-10);
    }

    @Deprecated
    public PolygonsSet(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 1.0E-10);
    }

    private static Line[] boxBoundary(double d, double d2, double d3, double d4, double d5) {
        if (d >= d2 - d5 || d3 >= d4 - d5) {
            return null;
        }
        Vector2D vector2D = new Vector2D(d, d3);
        Vector2D vector2D2 = new Vector2D(d, d4);
        Vector2D vector2D3 = new Vector2D(d2, d3);
        Vector2D vector2D4 = new Vector2D(d2, d4);
        return new Line[]{new Line(vector2D, vector2D3, d5), new Line(vector2D3, vector2D4, d5), new Line(vector2D4, vector2D2, d5), new Line(vector2D2, vector2D, d5)};
    }

    private static BSPTree<Euclidean2D> verticesToTree(double d, Vector2D ... vector2DArray) {
        int n = vector2DArray.length;
        if (n == 0) {
            return new BSPTree<Euclidean2D>(Boolean.TRUE);
        }
        Vertex[] vertexArray = new Vertex[n];
        for (int i = 0; i < n; ++i) {
            vertexArray[i] = new Vertex(vector2DArray[i]);
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>(n);
        for (int i = 0; i < n; ++i) {
            Vertex vertex = vertexArray[i];
            Vertex vertex2 = vertexArray[(i + 1) % n];
            Line line = vertex.sharedLineWith(vertex2);
            if (line == null) {
                line = new Line(vertex.getLocation(), vertex2.getLocation(), d);
            }
            arrayList.add(new Edge(vertex, vertex2, line));
            for (Vertex vertex3 : vertexArray) {
                if (vertex3 == vertex || vertex3 == vertex2 || !(FastMath.abs(line.getOffset(vertex3.getLocation())) <= d)) continue;
                vertex3.bindWith(line);
            }
        }
        BSPTree<Euclidean2D> bSPTree = new BSPTree<Euclidean2D>();
        PolygonsSet.insertEdges(d, bSPTree, arrayList);
        return bSPTree;
    }

    private static void insertEdges(double d, BSPTree<Euclidean2D> bSPTree, List<Edge> list) {
        int n = 0;
        Edge edge = null;
        while (edge == null && n < list.size()) {
            if ((edge = list.get(n++)).getNode() == null) {
                if (bSPTree.insertCut(edge.getLine())) {
                    edge.setNode(bSPTree);
                    continue;
                }
                edge = null;
                continue;
            }
            edge = null;
        }
        if (edge == null) {
            BSPTree<Euclidean2D> bSPTree2 = bSPTree.getParent();
            if (bSPTree2 == null || bSPTree == bSPTree2.getMinus()) {
                bSPTree.setAttribute(Boolean.TRUE);
            } else {
                bSPTree.setAttribute(Boolean.FALSE);
            }
            return;
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
        block5: for (Edge edge2 : list) {
            Side side;
            if (edge2 == edge) continue;
            double d2 = edge.getLine().getOffset(edge2.getStart().getLocation());
            double d3 = edge.getLine().getOffset(edge2.getEnd().getLocation());
            Side side2 = FastMath.abs(d2) <= d ? Side.HYPER : (side = d2 < 0.0 ? Side.MINUS : Side.PLUS);
            Side side3 = FastMath.abs(d3) <= d ? Side.HYPER : (d3 < 0.0 ? Side.MINUS : Side.PLUS);
            switch (side) {
                case PLUS: {
                    Vertex vertex;
                    if (side3 == Side.MINUS) {
                        vertex = edge2.split(edge.getLine());
                        arrayList2.add(vertex.getOutgoing());
                        arrayList.add(vertex.getIncoming());
                        continue block5;
                    }
                    arrayList.add(edge2);
                    continue block5;
                }
                case MINUS: {
                    Vertex vertex;
                    if (side3 == Side.PLUS) {
                        vertex = edge2.split(edge.getLine());
                        arrayList2.add(vertex.getIncoming());
                        arrayList.add(vertex.getOutgoing());
                        continue block5;
                    }
                    arrayList2.add(edge2);
                    continue block5;
                }
            }
            if (side3 == Side.PLUS) {
                arrayList.add(edge2);
                continue;
            }
            if (side3 != Side.MINUS) continue;
            arrayList2.add(edge2);
        }
        if (!arrayList.isEmpty()) {
            PolygonsSet.insertEdges(d, bSPTree.getPlus(), arrayList);
        } else {
            bSPTree.getPlus().setAttribute(Boolean.FALSE);
        }
        if (!arrayList2.isEmpty()) {
            PolygonsSet.insertEdges(d, bSPTree.getMinus(), arrayList2);
        } else {
            bSPTree.getMinus().setAttribute(Boolean.TRUE);
        }
    }

    public PolygonsSet buildNew(BSPTree<Euclidean2D> bSPTree) {
        return new PolygonsSet(bSPTree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        Vector2D[][] vector2DArray = this.getVertices();
        if (vector2DArray.length == 0) {
            BSPTree bSPTree = this.getTree(false);
            if (bSPTree.getCut() == null && ((Boolean)bSPTree.getAttribute()).booleanValue()) {
                this.setSize(Double.POSITIVE_INFINITY);
                this.setBarycenter(Vector2D.NaN);
            } else {
                this.setSize(0.0);
                this.setBarycenter(new Vector2D(0.0, 0.0));
            }
        } else if (vector2DArray[0][0] == null) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector2D.NaN);
        } else {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Vector2D[] vector2DArray2 : vector2DArray) {
                double d4 = vector2DArray2[vector2DArray2.length - 1].getX();
                double d5 = vector2DArray2[vector2DArray2.length - 1].getY();
                for (Vector2D vector2D : vector2DArray2) {
                    double d6 = d4;
                    double d7 = d5;
                    d4 = vector2D.getX();
                    d5 = vector2D.getY();
                    double d8 = d6 * d5 - d7 * d4;
                    d += d8;
                    d2 += d8 * (d6 + d4);
                    d3 += d8 * (d7 + d5);
                }
            }
            if (d < 0.0) {
                this.setSize(Double.POSITIVE_INFINITY);
                this.setBarycenter(Vector2D.NaN);
            } else {
                this.setSize(d / 2.0);
                this.setBarycenter(new Vector2D(d2 / (3.0 * d), d3 / (3.0 * d)));
            }
        }
    }

    public Vector2D[][] getVertices() {
        if (this.vertices == null) {
            if (this.getTree(false).getCut() == null) {
                this.vertices = new Vector2D[0][];
            } else {
                SegmentsBuilder segmentsBuilder = new SegmentsBuilder(this.getTolerance());
                this.getTree(true).visit(segmentsBuilder);
                List<ConnectableSegment> list = segmentsBuilder.getSegments();
                int n = list.size();
                if ((n -= this.naturalFollowerConnections(list)) > 0) {
                    n -= this.splitEdgeConnections(list);
                }
                if (n > 0) {
                    n -= this.closeVerticesConnections(list);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ConnectableSegment connectableSegment = this.getUnprocessed(list);
                while (connectableSegment != null) {
                    List<Segment> list2 = this.followLoop(connectableSegment);
                    if (list2 != null) {
                        if (list2.get(0).getStart() == null) {
                            arrayList.add(0, list2);
                        } else {
                            arrayList.add(list2);
                        }
                    }
                    connectableSegment = this.getUnprocessed(list);
                }
                this.vertices = new Vector2D[arrayList.size()][];
                int n2 = 0;
                for (List list3 : arrayList) {
                    int n3;
                    Vector2D[] vector2DArray;
                    if (list3.size() < 2 || list3.size() == 2 && ((Segment)list3.get(0)).getStart() == null && ((Segment)list3.get(1)).getEnd() == null) {
                        vector2DArray = ((Segment)list3.get(0)).getLine();
                        this.vertices[n2++] = new Vector2D[]{null, vector2DArray.toSpace((Point)new Vector1D(-3.4028234663852886E38)), vector2DArray.toSpace((Point)new Vector1D(3.4028234663852886E38))};
                        continue;
                    }
                    if (((Segment)list3.get(0)).getStart() == null) {
                        vector2DArray = new Vector2D[list3.size() + 2];
                        n3 = 0;
                        for (Segment segment : list3) {
                            double d;
                            if (n3 == 0) {
                                d = ((Vector1D)segment.getLine().toSubSpace((Point)segment.getEnd())).getX();
                                d -= FastMath.max(1.0, FastMath.abs(d / 2.0));
                                vector2DArray[n3++] = null;
                                vector2DArray[n3++] = segment.getLine().toSpace((Point)new Vector1D(d));
                            }
                            if (n3 < vector2DArray.length - 1) {
                                vector2DArray[n3++] = segment.getEnd();
                            }
                            if (n3 != vector2DArray.length - 1) continue;
                            d = ((Vector1D)segment.getLine().toSubSpace((Point)segment.getStart())).getX();
                            d += FastMath.max(1.0, FastMath.abs(d / 2.0));
                            vector2DArray[n3++] = segment.getLine().toSpace((Point)new Vector1D(d));
                        }
                        this.vertices[n2++] = vector2DArray;
                        continue;
                    }
                    vector2DArray = new Vector2D[list3.size()];
                    n3 = 0;
                    for (Segment segment : list3) {
                        vector2DArray[n3++] = segment.getStart();
                    }
                    this.vertices[n2++] = vector2DArray;
                }
            }
        }
        return (Vector2D[][])this.vertices.clone();
    }

    private int naturalFollowerConnections(List<ConnectableSegment> list) {
        int n = 0;
        block0: for (ConnectableSegment connectableSegment : list) {
            if (connectableSegment.getNext() != null) continue;
            BSPTree<Euclidean2D> bSPTree = connectableSegment.getNode();
            BSPTree<Euclidean2D> bSPTree2 = connectableSegment.getEndNode();
            for (ConnectableSegment connectableSegment2 : list) {
                if (connectableSegment2.getPrevious() != null || connectableSegment2.getNode() != bSPTree2 || connectableSegment2.getStartNode() != bSPTree) continue;
                connectableSegment.setNext(connectableSegment2);
                connectableSegment2.setPrevious(connectableSegment);
                ++n;
                continue block0;
            }
        }
        return n;
    }

    private int splitEdgeConnections(List<ConnectableSegment> list) {
        int n = 0;
        block0: for (ConnectableSegment connectableSegment : list) {
            if (connectableSegment.getNext() != null) continue;
            Hyperplane<Euclidean2D> hyperplane = connectableSegment.getNode().getCut().getHyperplane();
            BSPTree<Euclidean2D> bSPTree = connectableSegment.getEndNode();
            for (ConnectableSegment connectableSegment2 : list) {
                if (connectableSegment2.getPrevious() != null || connectableSegment2.getNode().getCut().getHyperplane() != hyperplane || connectableSegment2.getStartNode() != bSPTree) continue;
                connectableSegment.setNext(connectableSegment2);
                connectableSegment2.setPrevious(connectableSegment);
                ++n;
                continue block0;
            }
        }
        return n;
    }

    private int closeVerticesConnections(List<ConnectableSegment> list) {
        int n = 0;
        for (ConnectableSegment connectableSegment : list) {
            if (connectableSegment.getNext() != null || connectableSegment.getEnd() == null) continue;
            Vector2D vector2D = connectableSegment.getEnd();
            ConnectableSegment connectableSegment2 = null;
            double d = Double.POSITIVE_INFINITY;
            for (ConnectableSegment connectableSegment3 : list) {
                double d2;
                if (connectableSegment3.getPrevious() != null || connectableSegment3.getStart() == null || !((d2 = Vector2D.distance(vector2D, connectableSegment3.getStart())) < d)) continue;
                connectableSegment2 = connectableSegment3;
                d = d2;
            }
            if (!(d <= this.getTolerance())) continue;
            connectableSegment.setNext(connectableSegment2);
            connectableSegment2.setPrevious(connectableSegment);
            ++n;
        }
        return n;
    }

    private ConnectableSegment getUnprocessed(List<ConnectableSegment> list) {
        for (ConnectableSegment connectableSegment : list) {
            if (connectableSegment.isProcessed()) continue;
            return connectableSegment;
        }
        return null;
    }

    private List<Segment> followLoop(ConnectableSegment connectableSegment) {
        ConnectableSegment connectableSegment2;
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(connectableSegment);
        connectableSegment.setProcessed(true);
        for (connectableSegment2 = connectableSegment.getNext(); connectableSegment2 != connectableSegment && connectableSegment2 != null; connectableSegment2 = connectableSegment2.getNext()) {
            arrayList.add(connectableSegment2);
            connectableSegment2.setProcessed(true);
        }
        if (connectableSegment2 == null) {
            for (ConnectableSegment connectableSegment3 = connectableSegment.getPrevious(); connectableSegment3 != null; connectableSegment3 = connectableSegment3.getPrevious()) {
                arrayList.add(0, connectableSegment3);
                connectableSegment3.setProcessed(true);
            }
        }
        this.filterSpuriousVertices(arrayList);
        if (arrayList.size() == 2 && ((Segment)arrayList.get(0)).getStart() != null) {
            return null;
        }
        return arrayList;
    }

    private void filterSpuriousVertices(List<Segment> list) {
        for (int i = 0; i < list.size(); ++i) {
            Segment segment = list.get(i);
            int n = (i + 1) % list.size();
            Segment segment2 = list.get(n);
            if (segment2 == null || !Precision.equals(segment.getLine().getAngle(), segment2.getLine().getAngle(), Precision.EPSILON)) continue;
            list.set(n, new Segment(segment.getStart(), segment2.getEnd(), segment.getLine()));
            list.remove(i--);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SegmentsBuilder
    implements BSPTreeVisitor<Euclidean2D> {
        private final double tolerance;
        private final List<ConnectableSegment> segments;

        SegmentsBuilder(double d) {
            this.tolerance = d;
            this.segments = new ArrayList<ConnectableSegment>();
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean2D> bSPTree) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean2D> bSPTree) {
            BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
            NodesSet<Euclidean2D> nodesSet = boundaryAttribute.getSplitters();
            if (boundaryAttribute.getPlusOutside() != null) {
                this.addContribution(boundaryAttribute.getPlusOutside(), bSPTree, nodesSet, false);
            }
            if (boundaryAttribute.getPlusInside() != null) {
                this.addContribution(boundaryAttribute.getPlusInside(), bSPTree, nodesSet, true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean2D> bSPTree) {
        }

        private void addContribution(SubHyperplane<Euclidean2D> subHyperplane, BSPTree<Euclidean2D> bSPTree, Iterable<BSPTree<Euclidean2D>> iterable, boolean bl) {
            AbstractSubHyperplane abstractSubHyperplane = (AbstractSubHyperplane)subHyperplane;
            Line line = (Line)subHyperplane.getHyperplane();
            List<Interval> list = ((IntervalsSet)abstractSubHyperplane.getRemainingRegion()).asList();
            for (Interval interval : list) {
                Point point = Double.isInfinite(interval.getInf()) ? null : line.toSpace((Point)new Vector1D(interval.getInf()));
                Point point2 = Double.isInfinite(interval.getSup()) ? null : line.toSpace((Point)new Vector1D(interval.getSup()));
                BSPTree<Euclidean2D> bSPTree2 = this.selectClosest((Vector2D)point, iterable);
                BSPTree<Euclidean2D> bSPTree3 = this.selectClosest((Vector2D)point2, iterable);
                if (bl) {
                    this.segments.add(new ConnectableSegment((Vector2D)point2, (Vector2D)point, line.getReverse(), bSPTree, bSPTree3, bSPTree2));
                    continue;
                }
                this.segments.add(new ConnectableSegment((Vector2D)point, (Vector2D)point2, line, bSPTree, bSPTree2, bSPTree3));
            }
        }

        private BSPTree<Euclidean2D> selectClosest(Vector2D vector2D, Iterable<BSPTree<Euclidean2D>> iterable) {
            BSPTree<Euclidean2D> bSPTree = null;
            double d = Double.POSITIVE_INFINITY;
            for (BSPTree<Euclidean2D> bSPTree2 : iterable) {
                double d2 = FastMath.abs(bSPTree2.getCut().getHyperplane().getOffset(vector2D));
                if (!(d2 < d)) continue;
                bSPTree = bSPTree2;
                d = d2;
            }
            return d <= this.tolerance ? bSPTree : null;
        }

        public List<ConnectableSegment> getSegments() {
            return this.segments;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectableSegment
    extends Segment {
        private final BSPTree<Euclidean2D> node;
        private final BSPTree<Euclidean2D> startNode;
        private final BSPTree<Euclidean2D> endNode;
        private ConnectableSegment previous;
        private ConnectableSegment next;
        private boolean processed;

        ConnectableSegment(Vector2D vector2D, Vector2D vector2D2, Line line, BSPTree<Euclidean2D> bSPTree, BSPTree<Euclidean2D> bSPTree2, BSPTree<Euclidean2D> bSPTree3) {
            super(vector2D, vector2D2, line);
            this.node = bSPTree;
            this.startNode = bSPTree2;
            this.endNode = bSPTree3;
            this.previous = null;
            this.next = null;
            this.processed = false;
        }

        public BSPTree<Euclidean2D> getNode() {
            return this.node;
        }

        public BSPTree<Euclidean2D> getStartNode() {
            return this.startNode;
        }

        public BSPTree<Euclidean2D> getEndNode() {
            return this.endNode;
        }

        public ConnectableSegment getPrevious() {
            return this.previous;
        }

        public void setPrevious(ConnectableSegment connectableSegment) {
            this.previous = connectableSegment;
        }

        public ConnectableSegment getNext() {
            return this.next;
        }

        public void setNext(ConnectableSegment connectableSegment) {
            this.next = connectableSegment;
        }

        public void setProcessed(boolean bl) {
            this.processed = bl;
        }

        public boolean isProcessed() {
            return this.processed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Edge {
        private final Vertex start;
        private final Vertex end;
        private final Line line;
        private BSPTree<Euclidean2D> node;

        Edge(Vertex vertex, Vertex vertex2, Line line) {
            this.start = vertex;
            this.end = vertex2;
            this.line = line;
            this.node = null;
            vertex.setOutgoing(this);
            vertex2.setIncoming(this);
        }

        public Vertex getStart() {
            return this.start;
        }

        public Vertex getEnd() {
            return this.end;
        }

        public Line getLine() {
            return this.line;
        }

        public void setNode(BSPTree<Euclidean2D> bSPTree) {
            this.node = bSPTree;
        }

        public BSPTree<Euclidean2D> getNode() {
            return this.node;
        }

        public Vertex split(Line line) {
            Vertex vertex = new Vertex(this.line.intersection(line));
            vertex.bindWith(line);
            Edge edge = new Edge(this.start, vertex, this.line);
            Edge edge2 = new Edge(vertex, this.end, this.line);
            edge.node = this.node;
            edge2.node = this.node;
            return vertex;
        }
    }

    private static class Vertex {
        private final Vector2D location;
        private Edge incoming;
        private Edge outgoing;
        private final List<Line> lines;

        Vertex(Vector2D vector2D) {
            this.location = vector2D;
            this.incoming = null;
            this.outgoing = null;
            this.lines = new ArrayList<Line>();
        }

        public Vector2D getLocation() {
            return this.location;
        }

        public void bindWith(Line line) {
            this.lines.add(line);
        }

        public Line sharedLineWith(Vertex vertex) {
            for (Line line : this.lines) {
                for (Line line2 : vertex.lines) {
                    if (line != line2) continue;
                    return line;
                }
            }
            return null;
        }

        public void setIncoming(Edge edge) {
            this.incoming = edge;
            this.bindWith(edge.getLine());
        }

        public Edge getIncoming() {
            return this.incoming;
        }

        public void setOutgoing(Edge edge) {
            this.outgoing = edge;
            this.bindWith(edge.getLine());
        }

        public Edge getOutgoing() {
            return this.outgoing;
        }
    }
}

