/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod;

import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;

public class Segment {
    private final Vector2D start;
    private final Vector2D end;
    private final Line line;

    public Segment(Vector2D vector2D, Vector2D vector2D2, Line line) {
        this.start = vector2D;
        this.end = vector2D2;
        this.line = line;
    }

    public Vector2D getStart() {
        return this.start;
    }

    public Vector2D getEnd() {
        return this.end;
    }

    public Line getLine() {
        return this.line;
    }

    public double distance(Vector2D vector2D) {
        double d = this.end.getX() - this.start.getX();
        double d2 = this.end.getY() - this.start.getY();
        double d3 = ((vector2D.getX() - this.start.getX()) * d + (vector2D.getY() - this.start.getY()) * d2) / (d * d + d2 * d2);
        if (d3 < 0.0 || d3 > 1.0) {
            double d4 = this.getStart().distance(vector2D);
            double d5 = this.getEnd().distance(vector2D);
            return FastMath.min(d4, d5);
        }
        double d6 = this.start.getX() + d3 * d;
        double d7 = this.start.getY() + d3 * d2;
        Vector2D vector2D2 = new Vector2D(d6, d7);
        return vector2D2.distance(vector2D);
    }
}

