/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod.hull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AklToussaintHeuristic {
    private AklToussaintHeuristic() {
    }

    public static Collection<Vector2D> reducePoints(Collection<Vector2D> collection) {
        int n = 0;
        Vector2D vector2D = null;
        Vector2D vector2D2 = null;
        Vector2D vector2D3 = null;
        Vector2D vector2D4 = null;
        for (Vector2D serializable2 : collection) {
            if (vector2D == null || serializable2.getX() < vector2D.getX()) {
                vector2D = serializable2;
            }
            if (vector2D2 == null || serializable2.getX() > vector2D2.getX()) {
                vector2D2 = serializable2;
            }
            if (vector2D3 == null || serializable2.getY() < vector2D3.getY()) {
                vector2D3 = serializable2;
            }
            if (vector2D4 == null || serializable2.getY() > vector2D4.getY()) {
                vector2D4 = serializable2;
            }
            ++n;
        }
        if (n < 4) {
            return collection;
        }
        List<Vector2D> list = AklToussaintHeuristic.buildQuadrilateral(vector2D3, vector2D2, vector2D4, vector2D);
        if (list.size() < 3) {
            return collection;
        }
        ArrayList<Vector2D> arrayList = new ArrayList<Vector2D>(list);
        for (Vector2D vector2D5 : collection) {
            if (AklToussaintHeuristic.insideQuadrilateral(vector2D5, list)) continue;
            arrayList.add(vector2D5);
        }
        return arrayList;
    }

    private static List<Vector2D> buildQuadrilateral(Vector2D ... vector2DArray) {
        ArrayList<Vector2D> arrayList = new ArrayList<Vector2D>();
        for (Vector2D vector2D : vector2DArray) {
            if (arrayList.contains(vector2D)) continue;
            arrayList.add(vector2D);
        }
        return arrayList;
    }

    private static boolean insideQuadrilateral(Vector2D vector2D, List<Vector2D> list) {
        Vector2D vector2D2 = list.get(0);
        Vector2D vector2D3 = list.get(1);
        if (vector2D.equals(vector2D2) || vector2D.equals(vector2D3)) {
            return true;
        }
        double d = vector2D.crossProduct(vector2D2, vector2D3);
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            vector2D2 = vector2D3;
            vector2D3 = list.get(i + 1 == n ? 0 : i + 1);
            if (vector2D.equals(vector2D2) || vector2D.equals(vector2D3)) {
                return true;
            }
            if (!(d * vector2D.crossProduct(vector2D2, vector2D3) < 0.0)) continue;
            return false;
        }
        return true;
    }
}

