/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod.hull;

import java.io.Serializable;
import org.apache.commons.math3.exception.InsufficientDataException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Segment;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.hull.ConvexHull;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvexHull2D
implements ConvexHull<Euclidean2D, Vector2D>,
Serializable {
    private static final long serialVersionUID = 20140129L;
    private final Vector2D[] vertices;
    private final double tolerance;
    private transient Segment[] lineSegments;

    public ConvexHull2D(Vector2D[] vector2DArray, double d) {
        this.tolerance = d;
        if (!this.isConvex(vector2DArray)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_CONVEX, new Object[0]);
        }
        this.vertices = (Vector2D[])vector2DArray.clone();
    }

    private boolean isConvex(Vector2D[] vector2DArray) {
        if (vector2DArray.length < 3) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < vector2DArray.length; ++i) {
            Vector2D vector2D = vector2DArray[i == 0 ? vector2DArray.length - 1 : i - 1];
            Vector2D vector2D2 = vector2DArray[i];
            Vector2D vector2D3 = vector2DArray[i == vector2DArray.length - 1 ? 0 : i + 1];
            Vector vector = vector2D2.subtract((Vector)vector2D);
            Vector vector2 = vector2D3.subtract((Vector)vector2D2);
            double d = MathArrays.linearCombination(((Vector2D)vector).getX(), ((Vector2D)vector2).getY(), -((Vector2D)vector).getY(), ((Vector2D)vector2).getX());
            int n2 = Precision.compareTo(d, 0.0, this.tolerance);
            if ((double)n2 == 0.0) continue;
            if ((double)n != 0.0 && n2 != n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    public Vector2D[] getVertices() {
        return (Vector2D[])this.vertices.clone();
    }

    public Segment[] getLineSegments() {
        return (Segment[])this.retrieveLineSegments().clone();
    }

    private Segment[] retrieveLineSegments() {
        if (this.lineSegments == null) {
            int n = this.vertices.length;
            if (n <= 1) {
                this.lineSegments = new Segment[0];
            } else if (n == 2) {
                this.lineSegments = new Segment[1];
                Vector2D vector2D = this.vertices[0];
                Vector2D vector2D2 = this.vertices[1];
                this.lineSegments[0] = new Segment(vector2D, vector2D2, new Line(vector2D, vector2D2, this.tolerance));
            } else {
                this.lineSegments = new Segment[n];
                Vector2D vector2D = null;
                Vector2D vector2D3 = null;
                int n2 = 0;
                for (Vector2D vector2D4 : this.vertices) {
                    if (vector2D3 == null) {
                        vector2D = vector2D4;
                        vector2D3 = vector2D4;
                        continue;
                    }
                    this.lineSegments[n2++] = new Segment(vector2D3, vector2D4, new Line(vector2D3, vector2D4, this.tolerance));
                    vector2D3 = vector2D4;
                }
                this.lineSegments[n2] = new Segment(vector2D3, vector2D, new Line(vector2D3, vector2D, this.tolerance));
            }
        }
        return this.lineSegments;
    }

    @Override
    public Region<Euclidean2D> createRegion() {
        if (this.vertices.length < 3) {
            throw new InsufficientDataException();
        }
        RegionFactory regionFactory = new RegionFactory();
        Segment[] segmentArray = this.retrieveLineSegments();
        Line[] lineArray = new Line[segmentArray.length];
        for (int i = 0; i < segmentArray.length; ++i) {
            lineArray[i] = segmentArray[i].getLine();
        }
        return regionFactory.buildConvex(lineArray);
    }
}

