/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod.hull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.AbstractConvexHullGenerator2D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonotoneChain
extends AbstractConvexHullGenerator2D {
    public MonotoneChain() {
        this(false);
    }

    public MonotoneChain(boolean bl) {
        super(bl);
    }

    public MonotoneChain(boolean bl, double d) {
        super(bl, d);
    }

    @Override
    public Collection<Vector2D> findHullVertices(Collection<Vector2D> collection) {
        int n;
        ArrayList<Vector2D> arrayList = new ArrayList<Vector2D>(collection);
        Collections.sort(arrayList, new Comparator<Vector2D>(){

            @Override
            public int compare(Vector2D vector2D, Vector2D vector2D2) {
                double d = MonotoneChain.this.getTolerance();
                int n = Precision.compareTo(vector2D.getX(), vector2D2.getX(), d);
                if (n == 0) {
                    return Precision.compareTo(vector2D.getY(), vector2D2.getY(), d);
                }
                return n;
            }
        });
        ArrayList<Vector2D> arrayList2 = new ArrayList<Vector2D>();
        for (Vector2D vector2D : arrayList) {
            this.updateHull(vector2D, arrayList2);
        }
        ArrayList arrayList3 = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Vector2D vector2D = (Vector2D)arrayList.get(i);
            this.updateHull(vector2D, arrayList3);
        }
        ArrayList<Vector2D> arrayList4 = new ArrayList<Vector2D>(arrayList2.size() + arrayList3.size() - 2);
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            arrayList4.add((Vector2D)arrayList2.get(n));
        }
        for (n = 0; n < arrayList3.size() - 1; ++n) {
            arrayList4.add((Vector2D)arrayList3.get(n));
        }
        if (arrayList4.isEmpty() && !arrayList2.isEmpty()) {
            arrayList4.add((Vector2D)arrayList2.get(0));
        }
        return arrayList4;
    }

    private void updateHull(Vector2D vector2D, List<Vector2D> list) {
        Vector2D vector2D2;
        double d = this.getTolerance();
        if (list.size() == 1 && (vector2D2 = list.get(0)).distance(vector2D) < d) {
            return;
        }
        while (list.size() >= 2) {
            Vector2D vector2D3;
            int n = list.size();
            Vector2D vector2D4 = list.get(n - 2);
            double d2 = new Line(vector2D4, vector2D3 = list.get(n - 1), d).getOffset(vector2D);
            if (FastMath.abs(d2) < d) {
                double d3 = vector2D4.distance(vector2D);
                if (d3 < d || vector2D3.distance(vector2D) < d) {
                    return;
                }
                double d4 = vector2D4.distance(vector2D3);
                if (this.isIncludeCollinearPoints()) {
                    int n2 = d3 < d4 ? n - 1 : n;
                    list.add(n2, vector2D);
                } else if (d3 > d4) {
                    list.remove(n - 1);
                    list.add(vector2D);
                }
                return;
            }
            if (!(d2 > 0.0)) break;
            list.remove(n - 1);
        }
        list.add(vector2D);
    }
}

