/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.BoundaryProjection;
import org.apache.commons.math3.geometry.partitioning.Embedding;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoundaryProjector<S extends Space, T extends Space>
implements BSPTreeVisitor<S> {
    private final Point<S> original;
    private Point<S> projected;
    private BSPTree<S> leaf;
    private double offset;

    BoundaryProjector(Point<S> point) {
        this.original = point;
        this.projected = null;
        this.leaf = null;
        this.offset = Double.POSITIVE_INFINITY;
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S> bSPTree) {
        if (bSPTree.getCut().getHyperplane().getOffset(this.original) <= 0.0) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }
        return BSPTreeVisitor.Order.PLUS_SUB_MINUS;
    }

    @Override
    public void visitInternalNode(BSPTree<S> bSPTree) {
        Hyperplane<S> hyperplane = bSPTree.getCut().getHyperplane();
        double d = hyperplane.getOffset(this.original);
        if (FastMath.abs(d) < this.offset) {
            Point<S> point = hyperplane.project(this.original);
            List<Region<T>> list = this.boundaryRegions(bSPTree);
            boolean bl = false;
            for (Region<T> region : list) {
                if (bl || !this.belongsToPart(point, hyperplane, region)) continue;
                this.projected = point;
                this.offset = FastMath.abs(d);
                bl = true;
            }
            if (!bl) {
                for (Region<T> region : list) {
                    double d2;
                    Point<S> point2 = this.singularProjection(point, hyperplane, region);
                    if (point2 == null || !((d2 = this.original.distance(point2)) < this.offset)) continue;
                    this.projected = point2;
                    this.offset = d2;
                }
            }
        }
    }

    @Override
    public void visitLeafNode(BSPTree<S> bSPTree) {
        if (this.leaf == null) {
            this.leaf = bSPTree;
        }
    }

    public BoundaryProjection<S> getProjection() {
        this.offset = FastMath.copySign(this.offset, (Boolean)this.leaf.getAttribute() != false ? -1.0 : 1.0);
        return new BoundaryProjection<S>(this.original, this.projected, this.offset);
    }

    private List<Region<T>> boundaryRegions(BSPTree<S> bSPTree) {
        ArrayList<Region<T>> arrayList = new ArrayList<Region<T>>(2);
        BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
        this.addRegion(boundaryAttribute.getPlusInside(), arrayList);
        this.addRegion(boundaryAttribute.getPlusOutside(), arrayList);
        return arrayList;
    }

    private void addRegion(SubHyperplane<S> subHyperplane, List<Region<T>> list) {
        Region region;
        if (subHyperplane != null && (region = ((AbstractSubHyperplane)subHyperplane).getRemainingRegion()) != null) {
            list.add(region);
        }
    }

    private boolean belongsToPart(Point<S> point, Hyperplane<S> hyperplane, Region<T> region) {
        Embedding embedding = (Embedding)((Object)hyperplane);
        return region.checkPoint(embedding.toSubSpace(point)) != Region.Location.OUTSIDE;
    }

    private Point<S> singularProjection(Point<S> point, Hyperplane<S> hyperplane, Region<T> region) {
        Embedding embedding = (Embedding)((Object)hyperplane);
        BoundaryProjection<T> boundaryProjection = region.projectToBoundary(embedding.toSubSpace(point));
        return boundaryProjection.getProjected() == null ? null : embedding.toSpace(boundaryProjection.getProjected());
    }
}

