/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BoundarySizeVisitor<S extends Space>
implements BSPTreeVisitor<S> {
    private double boundarySize = 0.0;

    BoundarySizeVisitor() {
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S> bSPTree) {
        return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<S> bSPTree) {
        BoundaryAttribute boundaryAttribute = (BoundaryAttribute)bSPTree.getAttribute();
        if (boundaryAttribute.getPlusOutside() != null) {
            this.boundarySize += boundaryAttribute.getPlusOutside().getSize();
        }
        if (boundaryAttribute.getPlusInside() != null) {
            this.boundarySize += boundaryAttribute.getPlusInside().getSize();
        }
    }

    @Override
    public void visitLeafNode(BSPTree<S> bSPTree) {
    }

    public double getSize() {
        return this.boundarySize;
    }
}

