/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.NodesSet;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Characterization<S extends Space> {
    private SubHyperplane<S> outsideTouching = null;
    private SubHyperplane<S> insideTouching = null;
    private final NodesSet<S> outsideSplitters = new NodesSet();
    private final NodesSet<S> insideSplitters = new NodesSet();

    Characterization(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane) {
        this.characterize(bSPTree, subHyperplane, new ArrayList<BSPTree<S>>());
    }

    private void characterize(BSPTree<S> bSPTree, SubHyperplane<S> subHyperplane, List<BSPTree<S>> list) {
        if (bSPTree.getCut() == null) {
            boolean bl = (Boolean)bSPTree.getAttribute();
            if (bl) {
                this.addInsideTouching(subHyperplane, list);
            } else {
                this.addOutsideTouching(subHyperplane, list);
            }
        } else {
            Hyperplane<S> hyperplane = bSPTree.getCut().getHyperplane();
            SubHyperplane.SplitSubHyperplane<S> splitSubHyperplane = subHyperplane.split(hyperplane);
            switch (splitSubHyperplane.getSide()) {
                case PLUS: {
                    this.characterize(bSPTree.getPlus(), subHyperplane, list);
                    break;
                }
                case MINUS: {
                    this.characterize(bSPTree.getMinus(), subHyperplane, list);
                    break;
                }
                case BOTH: {
                    list.add(bSPTree);
                    this.characterize(bSPTree.getPlus(), splitSubHyperplane.getPlus(), list);
                    this.characterize(bSPTree.getMinus(), splitSubHyperplane.getMinus(), list);
                    list.remove(list.size() - 1);
                    break;
                }
                default: {
                    throw new MathInternalError();
                }
            }
        }
    }

    private void addOutsideTouching(SubHyperplane<S> subHyperplane, List<BSPTree<S>> list) {
        this.outsideTouching = this.outsideTouching == null ? subHyperplane : this.outsideTouching.reunite(subHyperplane);
        this.outsideSplitters.addAll(list);
    }

    private void addInsideTouching(SubHyperplane<S> subHyperplane, List<BSPTree<S>> list) {
        this.insideTouching = this.insideTouching == null ? subHyperplane : this.insideTouching.reunite(subHyperplane);
        this.insideSplitters.addAll(list);
    }

    public boolean touchOutside() {
        return this.outsideTouching != null && !this.outsideTouching.isEmpty();
    }

    public SubHyperplane<S> outsideTouching() {
        return this.outsideTouching;
    }

    public NodesSet<S> getOutsideSplitters() {
        return this.outsideSplitters;
    }

    public boolean touchInside() {
        return this.insideTouching != null && !this.insideTouching.isEmpty();
    }

    public SubHyperplane<S> insideTouching() {
        return this.insideTouching;
    }

    public NodesSet<S> getInsideSplitters() {
        return this.insideSplitters;
    }
}

