/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.partitioning.utilities;

import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OrderedTuple
implements Comparable<OrderedTuple> {
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long IMPLICIT_ONE = 0x10000000000000L;
    private double[] components;
    private int offset;
    private int lsb;
    private long[] encoding;
    private boolean posInf;
    private boolean negInf;
    private boolean nan;

    public OrderedTuple(double ... dArray) {
        this.components = (double[])dArray.clone();
        int n = Integer.MIN_VALUE;
        this.lsb = Integer.MAX_VALUE;
        this.posInf = false;
        this.negInf = false;
        this.nan = false;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isInfinite(dArray[i])) {
                if (dArray[i] < 0.0) {
                    this.negInf = true;
                    continue;
                }
                this.posInf = true;
                continue;
            }
            if (Double.isNaN(dArray[i])) {
                this.nan = true;
                continue;
            }
            long l = Double.doubleToLongBits(dArray[i]);
            long l2 = OrderedTuple.mantissa(l);
            if (l2 == 0L) continue;
            int n2 = OrderedTuple.exponent(l);
            n = FastMath.max(n, n2 + OrderedTuple.computeMSB(l2));
            this.lsb = FastMath.min(this.lsb, n2 + OrderedTuple.computeLSB(l2));
        }
        if (this.posInf && this.negInf) {
            this.posInf = false;
            this.negInf = false;
            this.nan = true;
        }
        if (this.lsb <= n) {
            this.encode(n + 16);
        } else {
            this.encoding = new long[]{0L};
        }
    }

    private void encode(int n) {
        this.offset = n + 31;
        this.offset -= this.offset % 32;
        if (this.encoding != null && this.encoding.length == 1 && this.encoding[0] == 0L) {
            return;
        }
        int n2 = this.offset + 1 - this.lsb;
        int n3 = (n2 + 62) / 63;
        this.encoding = new long[this.components.length * n3];
        int n4 = 0;
        int n5 = 62;
        long l = 0L;
        int n6 = this.offset;
        while (n4 < this.encoding.length) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.getBit(i, n6) != 0) {
                    l |= 1L << n5;
                }
                if (n5-- != 0) continue;
                this.encoding[n4++] = l;
                l = 0L;
                n5 = 62;
            }
            --n6;
        }
    }

    @Override
    public int compareTo(OrderedTuple orderedTuple) {
        if (this.components.length == orderedTuple.components.length) {
            if (this.nan) {
                return 1;
            }
            if (orderedTuple.nan) {
                return -1;
            }
            if (this.negInf || orderedTuple.posInf) {
                return -1;
            }
            if (this.posInf || orderedTuple.negInf) {
                return 1;
            }
            if (this.offset < orderedTuple.offset) {
                this.encode(orderedTuple.offset);
            } else if (this.offset > orderedTuple.offset) {
                orderedTuple.encode(this.offset);
            }
            int n = FastMath.min(this.encoding.length, orderedTuple.encoding.length);
            for (int i = 0; i < n; ++i) {
                if (this.encoding[i] < orderedTuple.encoding[i]) {
                    return -1;
                }
                if (this.encoding[i] <= orderedTuple.encoding[i]) continue;
                return 1;
            }
            if (this.encoding.length < orderedTuple.encoding.length) {
                return -1;
            }
            if (this.encoding.length > orderedTuple.encoding.length) {
                return 1;
            }
            return 0;
        }
        return this.components.length - orderedTuple.components.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OrderedTuple) {
            return this.compareTo((OrderedTuple)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = 37;
        int n2 = 97;
        int n3 = 71;
        int n4 = Arrays.hashCode(this.components);
        n4 = n4 * 37 + this.offset;
        n4 = n4 * 37 + this.lsb;
        n4 = n4 * 37 + (this.posInf ? 97 : 71);
        n4 = n4 * 37 + (this.negInf ? 97 : 71);
        n4 = n4 * 37 + (this.nan ? 97 : 71);
        return n4;
    }

    public double[] getComponents() {
        return (double[])this.components.clone();
    }

    private static long sign(long l) {
        return l & Long.MIN_VALUE;
    }

    private static int exponent(long l) {
        return (int)((l & 0x7FF0000000000000L) >> 52) - 1075;
    }

    private static long mantissa(long l) {
        return (l & 0x7FF0000000000000L) == 0L ? (l & 0xFFFFFFFFFFFFFL) << 1 : 0x10000000000000L | l & 0xFFFFFFFFFFFFFL;
    }

    private static int computeMSB(long l) {
        long l2 = l;
        long l3 = 0xFFFFFFFFL;
        int n = 32;
        int n2 = 0;
        while (n != 0) {
            if ((l2 & l3) != l2) {
                n2 |= n;
                l2 >>= n;
            }
            l3 >>= (n >>= 1);
        }
        return n2;
    }

    private static int computeLSB(long l) {
        long l2 = l;
        long l3 = -4294967296L;
        int n = 32;
        int n2 = 0;
        while (n != 0) {
            if ((l2 & l3) == l2) {
                n2 |= n;
                l2 >>= n;
            }
            l3 >>= (n >>= 1);
        }
        return n2;
    }

    private int getBit(int n, int n2) {
        long l = Double.doubleToLongBits(this.components[n]);
        int n3 = OrderedTuple.exponent(l);
        if (n2 < n3 || n2 > this.offset) {
            return 0;
        }
        if (n2 == this.offset) {
            return OrderedTuple.sign(l) == 0L ? 1 : 0;
        }
        if (n2 > n3 + 52) {
            return OrderedTuple.sign(l) == 0L ? 0 : 1;
        }
        long l2 = OrderedTuple.sign(l) == 0L ? OrderedTuple.mantissa(l) : -OrderedTuple.mantissa(l);
        return (int)(l2 >> n2 - n3 & 1L);
    }
}

