/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.oned;

import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Space;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S1Point
implements Point<Sphere1D> {
    public static final S1Point NaN = new S1Point(Double.NaN, Vector2D.NaN);
    private static final long serialVersionUID = 20131218L;
    private final double alpha;
    private final Vector2D vector;

    public S1Point(double d) {
        this(MathUtils.normalizeAngle(d, Math.PI), new Vector2D(FastMath.cos(d), FastMath.sin(d)));
    }

    private S1Point(double d, Vector2D vector2D) {
        this.alpha = d;
        this.vector = vector2D;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public Vector2D getVector() {
        return this.vector;
    }

    @Override
    public Space getSpace() {
        return Sphere1D.getInstance();
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.alpha);
    }

    @Override
    public double distance(Point<Sphere1D> point) {
        return S1Point.distance(this, (S1Point)point);
    }

    public static double distance(S1Point s1Point, S1Point s1Point2) {
        return Vector2D.angle(s1Point.vector, s1Point2.vector);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof S1Point) {
            S1Point s1Point = (S1Point)object;
            if (s1Point.isNaN()) {
                return this.isNaN();
            }
            return this.alpha == s1Point.alpha;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 1759 * MathUtils.hash(this.alpha);
    }
}

