/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.twod;

import java.util.List;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.spherical.oned.Arc;
import org.apache.commons.math3.geometry.spherical.twod.Circle;
import org.apache.commons.math3.geometry.spherical.twod.S2Point;
import org.apache.commons.math3.geometry.spherical.twod.Vertex;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge {
    private final Vertex start;
    private Vertex end;
    private final double length;
    private final Circle circle;

    Edge(Vertex vertex, Vertex vertex2, double d, Circle circle) {
        this.start = vertex;
        this.end = vertex2;
        this.length = d;
        this.circle = circle;
        vertex.setOutgoing(this);
        vertex2.setIncoming(this);
    }

    public Vertex getStart() {
        return this.start;
    }

    public Vertex getEnd() {
        return this.end;
    }

    public double getLength() {
        return this.length;
    }

    public Circle getCircle() {
        return this.circle;
    }

    public Vector3D getPointAt(double d) {
        return this.circle.getPointAt(d + this.circle.getPhase(this.start.getLocation().getVector()));
    }

    void setNextEdge(Edge edge) {
        this.end = edge.getStart();
        this.end.setIncoming(this);
        this.end.bindWith(this.getCircle());
    }

    void split(Circle circle, List<Edge> list, List<Edge> list2) {
        double d = this.circle.getPhase(this.start.getLocation().getVector());
        Arc arc = this.circle.getInsideArc(circle);
        double d2 = MathUtils.normalizeAngle(arc.getInf(), d + Math.PI) - d;
        double d3 = d2 + arc.getSize();
        double d4 = d3 - Math.PI * 2;
        double d5 = this.circle.getTolerance();
        Vertex vertex = this.start;
        if (d4 >= this.length - d5) {
            list2.add(this);
        } else {
            double d6 = 0.0;
            if (d4 >= 0.0) {
                vertex = this.addSubEdge(vertex, new Vertex(new S2Point(this.circle.getPointAt(d + d4))), d4, list2, circle);
                d6 = d4;
            }
            if (d2 >= this.length - d5) {
                if (d4 >= 0.0) {
                    vertex = this.addSubEdge(vertex, this.end, this.length - d6, list, circle);
                } else {
                    list.add(this);
                }
            } else {
                vertex = this.addSubEdge(vertex, new Vertex(new S2Point(this.circle.getPointAt(d + d2))), d2 - d6, list, circle);
                d6 = d2;
                if (d3 >= this.length - d5) {
                    vertex = this.addSubEdge(vertex, this.end, this.length - d6, list2, circle);
                } else {
                    vertex = this.addSubEdge(vertex, new Vertex(new S2Point(this.circle.getPointAt(d + d2))), d2 - d6, list2, circle);
                    d6 = d2;
                    vertex = this.addSubEdge(vertex, this.end, this.length - d6, list, circle);
                }
            }
        }
    }

    private Vertex addSubEdge(Vertex vertex, Vertex vertex2, double d, List<Edge> list, Circle circle) {
        if (d <= this.circle.getTolerance()) {
            return vertex;
        }
        vertex2.bindWith(circle);
        Edge edge = new Edge(vertex, vertex2, d, this.circle);
        list.add(edge);
        return vertex2;
    }
}

