/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.spherical.twod.Edge;
import org.apache.commons.math3.geometry.spherical.twod.S2Point;
import org.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import org.apache.commons.math3.geometry.spherical.twod.SphericalPolygonsSet;
import org.apache.commons.math3.geometry.spherical.twod.Vertex;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesComputer
implements BSPTreeVisitor<Sphere2D> {
    private final double tolerance;
    private double summedArea;
    private Vector3D summedBarycenter;
    private final List<Vector3D> convexCellsInsidePoints;

    PropertiesComputer(double d) {
        this.tolerance = d;
        this.summedArea = 0.0;
        this.summedBarycenter = Vector3D.ZERO;
        this.convexCellsInsidePoints = new ArrayList<Vector3D>();
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> bSPTree) {
        return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<Sphere2D> bSPTree) {
    }

    @Override
    public void visitLeafNode(BSPTree<Sphere2D> bSPTree) {
        if (((Boolean)bSPTree.getAttribute()).booleanValue()) {
            SphericalPolygonsSet sphericalPolygonsSet = new SphericalPolygonsSet(bSPTree.pruneAroundConvexCell(Boolean.TRUE, Boolean.FALSE, null), this.tolerance);
            List<Vertex> list = sphericalPolygonsSet.getBoundaryLoops();
            if (list.size() != 1) {
                throw new MathInternalError();
            }
            double d = this.convexCellArea(list.get(0));
            Vector3D vector3D = this.convexCellBarycenter(list.get(0));
            this.convexCellsInsidePoints.add(vector3D);
            this.summedArea += d;
            this.summedBarycenter = new Vector3D(1.0, this.summedBarycenter, d, vector3D);
        }
    }

    private double convexCellArea(Vertex vertex) {
        int n;
        double d = 0.0;
        Edge edge = vertex.getOutgoing();
        for (n = 0; n == 0 || edge.getStart() != vertex; ++n) {
            Vector3D vector3D;
            Vector3D vector3D2 = edge.getCircle().getPole();
            Vector3D vector3D3 = edge.getEnd().getOutgoing().getCircle().getPole();
            double d2 = FastMath.atan2(Vector3D.dotProduct(vector3D3, Vector3D.crossProduct(vector3D = edge.getEnd().getLocation().getVector(), vector3D2)), -Vector3D.dotProduct(vector3D3, vector3D2));
            if (d2 < 0.0) {
                d2 += Math.PI * 2;
            }
            d += d2;
            edge = edge.getEnd().getOutgoing();
        }
        return d - (double)(n - 2) * Math.PI;
    }

    private Vector3D convexCellBarycenter(Vertex vertex) {
        Vector3D vector3D = Vector3D.ZERO;
        Edge edge = vertex.getOutgoing();
        for (int i = 0; i == 0 || edge.getStart() != vertex; ++i) {
            vector3D = new Vector3D(1.0, vector3D, edge.getLength(), edge.getCircle().getPole());
            edge = edge.getEnd().getOutgoing();
        }
        return vector3D.normalize();
    }

    public double getArea() {
        return this.summedArea;
    }

    public S2Point getBarycenter() {
        if (this.summedBarycenter.getNormSq() == 0.0) {
            return S2Point.NaN;
        }
        return new S2Point(this.summedBarycenter);
    }

    public List<Vector3D> getConvexCellsInsidePoints() {
        return this.convexCellsInsidePoints;
    }
}

