/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.ArrayList;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.DefaultFieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultFieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldMatrix<T extends FieldElement<T>>
implements FieldMatrix<T> {
    private final Field<T> field;

    protected AbstractFieldMatrix() {
        this.field = null;
    }

    protected AbstractFieldMatrix(Field<T> field) {
        this.field = field;
    }

    protected AbstractFieldMatrix(Field<T> field, int n, int n2) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n2);
        }
        this.field = field;
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[][] TArray) {
        if (TArray == null) {
            throw new NullArgumentException();
        }
        if (TArray.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        if (TArray[0].length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        return TArray[0][0].getField();
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[] TArray) {
        if (TArray.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        return TArray[0].getField();
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[][] buildArray(Field<T> field, int n, int n2) {
        return (FieldElement[][])MathArrays.buildArray(field, n, n2);
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[] buildArray(Field<T> field, int n) {
        return (FieldElement[])MathArrays.buildArray(field, n);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public abstract FieldMatrix<T> createMatrix(int var1, int var2);

    @Override
    public abstract FieldMatrix<T> copy();

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> fieldMatrix) {
        this.checkAdditionCompatible(fieldMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix2 = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fieldMatrix2.setEntry(i, j, (FieldElement)this.getEntry(i, j).add(fieldMatrix.getEntry(i, j)));
            }
        }
        return fieldMatrix2;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> fieldMatrix) {
        this.checkSubtractionCompatible(fieldMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix2 = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fieldMatrix2.setEntry(i, j, (FieldElement)this.getEntry(i, j).subtract(fieldMatrix.getEntry(i, j)));
            }
        }
        return fieldMatrix2;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T t) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fieldMatrix.setEntry(i, j, (FieldElement)this.getEntry(i, j).add(t));
            }
        }
        return fieldMatrix;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T t) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fieldMatrix.setEntry(i, j, (FieldElement)this.getEntry(i, j).multiply(t));
            }
        }
        return fieldMatrix;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> fieldMatrix) {
        this.checkMultiplicationCompatible(fieldMatrix);
        int n = this.getRowDimension();
        int n2 = fieldMatrix.getColumnDimension();
        int n3 = this.getColumnDimension();
        FieldMatrix<FieldElement> fieldMatrix2 = this.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                FieldElement fieldElement = (FieldElement)this.field.getZero();
                for (int k = 0; k < n3; ++k) {
                    fieldElement = (FieldElement)fieldElement.add(this.getEntry(i, k).multiply(fieldMatrix.getEntry(k, j)));
                }
                fieldMatrix2.setEntry(i, j, fieldElement);
            }
        }
        return fieldMatrix2;
    }

    @Override
    public FieldMatrix<T> preMultiply(FieldMatrix<T> fieldMatrix) {
        return fieldMatrix.multiply(this);
    }

    @Override
    public FieldMatrix<T> power(int n) {
        int n2;
        if (n < 0) {
            throw new NotPositiveException(n);
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (n == 0) {
            return MatrixUtils.createFieldIdentityMatrix(this.getField(), this.getRowDimension());
        }
        if (n == 1) {
            return this.copy();
        }
        int n3 = n - 1;
        char[] cArray = Integer.toBinaryString(n3).toCharArray();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '1') continue;
            n2 = cArray.length - i - 1;
            arrayList.add(n2);
        }
        ArrayList arrayList2 = new ArrayList(cArray.length);
        arrayList2.add(0, this.copy());
        for (n2 = 1; n2 < cArray.length; ++n2) {
            FieldMatrix fieldMatrix = (FieldMatrix)arrayList2.get(n2 - 1);
            FieldMatrix object = fieldMatrix.multiply(fieldMatrix);
            arrayList2.add(n2, object);
        }
        FieldMatrix<T> fieldMatrix = this.copy();
        for (Integer n4 : arrayList) {
            fieldMatrix = fieldMatrix.multiply((FieldMatrix)arrayList2.get(n4));
        }
        return fieldMatrix;
    }

    @Override
    public T[][] getData() {
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.field, this.getRowDimension(), this.getColumnDimension());
        for (int i = 0; i < fieldElementArray.length; ++i) {
            FieldElement[] fieldElementArray2 = fieldElementArray[i];
            for (int j = 0; j < fieldElementArray2.length; ++j) {
                fieldElementArray2[j] = this.getEntry(i, j);
            }
        }
        return fieldElementArray;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        FieldMatrix<T> fieldMatrix = this.createMatrix(n2 - n + 1, n4 - n3 + 1);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                fieldMatrix.setEntry(i - n, j - n3, this.getEntry(i, j));
            }
        }
        return fieldMatrix;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(final int[] nArray, final int[] nArray2) {
        this.checkSubMatrixIndex(nArray, nArray2);
        FieldMatrix<T> fieldMatrix = this.createMatrix(nArray.length, nArray2.length);
        fieldMatrix.walkInOptimizedOrder(new DefaultFieldMatrixChangingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public T visit(int n, int n2, T t) {
                return AbstractFieldMatrix.this.getEntry(nArray[n], nArray2[n2]);
            }
        });
        return fieldMatrix;
    }

    @Override
    public void copySubMatrix(int n, int n2, int n3, int n4, T[][] TArray) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        int n5 = n2 + 1 - n;
        int n6 = n4 + 1 - n3;
        if (TArray.length < n5 || TArray[0].length < n6) {
            throw new MatrixDimensionMismatchException(TArray.length, TArray[0].length, n5, n6);
        }
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero(), (FieldElement[][])TArray){
            private int startRow;
            private int startColumn;
            final /* synthetic */ FieldElement[][] val$destination;
            {
                this.val$destination = fieldElementArray;
                super(fieldElement);
            }

            @Override
            public void start(int n, int n2, int n3, int n4, int n5, int n6) {
                this.startRow = n3;
                this.startColumn = n5;
            }

            @Override
            public void visit(int n, int n2, T t) {
                this.val$destination[n - this.startRow][n2 - this.startColumn] = t;
            }
        }, n, n2, n3, n4);
    }

    @Override
    public void copySubMatrix(int[] nArray, int[] nArray2, T[][] TArray) {
        this.checkSubMatrixIndex(nArray, nArray2);
        if (TArray.length < nArray.length || TArray[0].length < nArray2.length) {
            throw new MatrixDimensionMismatchException(TArray.length, TArray[0].length, nArray.length, nArray2.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            T[] TArray2 = TArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                TArray2[j] = this.getEntry(nArray[i], nArray2[j]);
            }
        }
    }

    @Override
    public void setSubMatrix(T[][] TArray, int n, int n2) {
        int n3;
        if (TArray == null) {
            throw new NullArgumentException();
        }
        int n4 = TArray.length;
        if (n4 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int n5 = TArray[0].length;
        if (n5 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (n3 = 1; n3 < n4; ++n3) {
            if (TArray[n3].length == n5) continue;
            throw new DimensionMismatchException(n5, TArray[n3].length);
        }
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        this.checkRowIndex(n4 + n - 1);
        this.checkColumnIndex(n5 + n2 - 1);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i < n5; ++i) {
                this.setEntry(n + n3, n2 + i, TArray[n3][i]);
            }
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int n) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        FieldMatrix<T> fieldMatrix = this.createMatrix(1, n2);
        for (int i = 0; i < n2; ++i) {
            fieldMatrix.setEntry(0, i, this.getEntry(n, i));
        }
        return fieldMatrix;
    }

    @Override
    public void setRowMatrix(int n, FieldMatrix<T> fieldMatrix) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (fieldMatrix.getRowDimension() != 1 || fieldMatrix.getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), 1, n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(n, i, fieldMatrix.getEntry(0, i));
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int n) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        FieldMatrix<T> fieldMatrix = this.createMatrix(n2, 1);
        for (int i = 0; i < n2; ++i) {
            fieldMatrix.setEntry(i, 0, this.getEntry(i, n));
        }
        return fieldMatrix;
    }

    @Override
    public void setColumnMatrix(int n, FieldMatrix<T> fieldMatrix) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (fieldMatrix.getRowDimension() != n2 || fieldMatrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), n2, 1);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i, n, fieldMatrix.getEntry(i, 0));
        }
    }

    @Override
    public FieldVector<T> getRowVector(int n) {
        return new ArrayFieldVector(this.field, this.getRow(n), false);
    }

    @Override
    public void setRowVector(int n, FieldVector<T> fieldVector) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (fieldVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(1, fieldVector.getDimension(), 1, n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(n, i, fieldVector.getEntry(i));
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int n) {
        return new ArrayFieldVector(this.field, this.getColumn(n), false);
    }

    @Override
    public void setColumnVector(int n, FieldVector<T> fieldVector) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (fieldVector.getDimension() != n2) {
            throw new MatrixDimensionMismatchException(fieldVector.getDimension(), 1, n2, 1);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i, n, fieldVector.getEntry(i));
        }
    }

    @Override
    public T[] getRow(int n) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
        for (int i = 0; i < n2; ++i) {
            fieldElementArray[i] = this.getEntry(n, i);
        }
        return fieldElementArray;
    }

    @Override
    public void setRow(int n, T[] TArray) {
        this.checkRowIndex(n);
        int n2 = this.getColumnDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, TArray.length, 1, n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(n, i, TArray[i]);
        }
    }

    @Override
    public T[] getColumn(int n) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
        for (int i = 0; i < n2; ++i) {
            fieldElementArray[i] = this.getEntry(i, n);
        }
        return fieldElementArray;
    }

    @Override
    public void setColumn(int n, T[] TArray) {
        this.checkColumnIndex(n);
        int n2 = this.getRowDimension();
        if (TArray.length != n2) {
            throw new MatrixDimensionMismatchException(TArray.length, 1, n2, 1);
        }
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i, n, TArray[i]);
        }
    }

    @Override
    public abstract T getEntry(int var1, int var2);

    @Override
    public abstract void setEntry(int var1, int var2, T var3);

    @Override
    public abstract void addToEntry(int var1, int var2, T var3);

    @Override
    public abstract void multiplyEntry(int var1, int var2, T var3);

    @Override
    public FieldMatrix<T> transpose() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        final FieldMatrix<T> fieldMatrix = this.createMatrix(n2, n);
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public void visit(int n, int n2, T t) {
                fieldMatrix.setEntry(n2, n, t);
            }
        });
        return fieldMatrix;
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Override
    public abstract int getRowDimension();

    @Override
    public abstract int getColumnDimension();

    @Override
    public T getTrace() {
        int n;
        int n2 = this.getRowDimension();
        if (n2 != (n = this.getColumnDimension())) {
            throw new NonSquareMatrixException(n2, n);
        }
        FieldElement fieldElement = (FieldElement)this.field.getZero();
        for (int i = 0; i < n2; ++i) {
            fieldElement = (FieldElement)fieldElement.add(this.getEntry(i, i));
        }
        return (T)fieldElement;
    }

    @Override
    public T[] operate(T[] TArray) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (TArray.length != n2) {
            throw new DimensionMismatchException(TArray.length, n2);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n);
        for (int i = 0; i < n; ++i) {
            FieldElement fieldElement = (FieldElement)this.field.getZero();
            for (int j = 0; j < n2; ++j) {
                fieldElement = (FieldElement)fieldElement.add(this.getEntry(i, j).multiply(TArray[j]));
            }
            fieldElementArray[i] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public FieldVector<T> operate(FieldVector<T> fieldVector) {
        try {
            return new ArrayFieldVector(this.field, this.operate(((ArrayFieldVector)fieldVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = this.getRowDimension();
            int n2 = this.getColumnDimension();
            if (fieldVector.getDimension() != n2) {
                throw new DimensionMismatchException(fieldVector.getDimension(), n2);
            }
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n);
            for (int i = 0; i < n; ++i) {
                FieldElement fieldElement = (FieldElement)this.field.getZero();
                for (int j = 0; j < n2; ++j) {
                    fieldElement = (FieldElement)fieldElement.add(this.getEntry(i, j).multiply(fieldVector.getEntry(j)));
                }
                fieldElementArray[i] = fieldElement;
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public T[] preMultiply(T[] TArray) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (TArray.length != n) {
            throw new DimensionMismatchException(TArray.length, n);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
        for (int i = 0; i < n2; ++i) {
            FieldElement fieldElement = (FieldElement)this.field.getZero();
            for (int j = 0; j < n; ++j) {
                fieldElement = (FieldElement)fieldElement.add(this.getEntry(j, i).multiply(TArray[j]));
            }
            fieldElementArray[i] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public FieldVector<T> preMultiply(FieldVector<T> fieldVector) {
        try {
            return new ArrayFieldVector(this.field, this.preMultiply(((ArrayFieldVector)fieldVector).getDataRef()), false);
        }
        catch (ClassCastException classCastException) {
            int n = this.getRowDimension();
            int n2 = this.getColumnDimension();
            if (fieldVector.getDimension() != n) {
                throw new DimensionMismatchException(fieldVector.getDimension(), n);
            }
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n2);
            for (int i = 0; i < n2; ++i) {
                FieldElement fieldElement = (FieldElement)this.field.getZero();
                for (int j = 0; j < n; ++j) {
                    fieldElement = (FieldElement)fieldElement.add(this.getEntry(j, i).multiply(fieldVector.getEntry(j)));
                }
                fieldElementArray[i] = fieldElement;
            }
            return new ArrayFieldVector(this.field, fieldElementArray, false);
        }
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                T t = this.getEntry(i, j);
                T t2 = fieldMatrixChangingVisitor.visit(i, j, t);
                this.setEntry(i, j, t2);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fieldMatrixPreservingVisitor.visit(i, j, this.getEntry(i, j));
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                T t = this.getEntry(i, j);
                T t2 = fieldMatrixChangingVisitor.visit(i, j, t);
                this.setEntry(i, j, t2);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                fieldMatrixPreservingVisitor.visit(i, j, this.getEntry(i, j));
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                T t = this.getEntry(j, i);
                T t2 = fieldMatrixChangingVisitor.visit(j, i, t);
                this.setEntry(j, i, t2);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fieldMatrixPreservingVisitor.visit(j, i, this.getEntry(j, i));
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                T t = this.getEntry(j, i);
                T t2 = fieldMatrixChangingVisitor.visit(j, i, t);
                this.setEntry(j, i, t2);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                fieldMatrixPreservingVisitor.visit(j, i, this.getEntry(j, i));
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        return this.walkInRowOrder(fieldMatrixChangingVisitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        return this.walkInRowOrder(fieldMatrixPreservingVisitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(fieldMatrixChangingVisitor, n, n2, n3, n4);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) {
        return this.walkInRowOrder(fieldMatrixPreservingVisitor, n, n2, n3, n4);
    }

    public String toString() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        stringBuffer.append(string2).append("{");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{");
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.getEntry(i, j));
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldMatrix)) {
            return false;
        }
        FieldMatrix fieldMatrix = (FieldMatrix)object;
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (fieldMatrix.getColumnDimension() != n2 || fieldMatrix.getRowDimension() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (this.getEntry(i, j).equals(fieldMatrix.getEntry(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 322562;
        int n2 = this.getRowDimension();
        int n3 = this.getColumnDimension();
        n = n * 31 + n2;
        n = n * 31 + n3;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                n = n * 31 + (11 * (i + 1) + 17 * (j + 1)) * this.getEntry(i, j).hashCode();
            }
        }
        return n;
    }

    protected void checkRowIndex(int n) {
        if (n < 0 || n >= this.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)n, 0, this.getRowDimension() - 1);
        }
    }

    protected void checkColumnIndex(int n) {
        if (n < 0 || n >= this.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)n, 0, this.getColumnDimension() - 1);
        }
    }

    protected void checkSubMatrixIndex(int n, int n2, int n3, int n4) {
        this.checkRowIndex(n);
        this.checkRowIndex(n2);
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, true);
        }
        this.checkColumnIndex(n3);
        this.checkColumnIndex(n4);
        if (n4 < n3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)n4, n3, true);
        }
    }

    protected void checkSubMatrixIndex(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            throw new NullArgumentException();
        }
        if (nArray.length == 0 || nArray2.length == 0) {
            throw new NoDataException();
        }
        for (int n : nArray) {
            this.checkRowIndex(n);
        }
        for (int n : nArray2) {
            this.checkColumnIndex(n);
        }
    }

    protected void checkAdditionCompatible(FieldMatrix<T> fieldMatrix) {
        if (this.getRowDimension() != fieldMatrix.getRowDimension() || this.getColumnDimension() != fieldMatrix.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkSubtractionCompatible(FieldMatrix<T> fieldMatrix) {
        if (this.getRowDimension() != fieldMatrix.getRowDimension() || this.getColumnDimension() != fieldMatrix.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkMultiplicationCompatible(FieldMatrix<T> fieldMatrix) {
        if (this.getColumnDimension() != fieldMatrix.getRowDimension()) {
            throw new DimensionMismatchException(fieldMatrix.getRowDimension(), this.getColumnDimension());
        }
    }
}

