/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public class DiagonalMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = 20121229L;
    private final double[] data;

    public DiagonalMatrix(int n) {
        super(n, n);
        this.data = new double[n];
    }

    public DiagonalMatrix(double[] dArray) {
        this(dArray, true);
    }

    public DiagonalMatrix(double[] dArray, boolean bl) {
        MathUtils.checkNotNull(dArray);
        this.data = bl ? (double[])dArray.clone() : dArray;
    }

    public RealMatrix createMatrix(int n, int n2) {
        if (n != n2) {
            throw new DimensionMismatchException(n, n2);
        }
        return new DiagonalMatrix(n);
    }

    public RealMatrix copy() {
        return new DiagonalMatrix(this.data);
    }

    public DiagonalMatrix add(DiagonalMatrix diagonalMatrix) {
        MatrixUtils.checkAdditionCompatible(this, diagonalMatrix);
        int n = this.getRowDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[i] + diagonalMatrix.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public DiagonalMatrix subtract(DiagonalMatrix diagonalMatrix) {
        MatrixUtils.checkSubtractionCompatible(this, diagonalMatrix);
        int n = this.getRowDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[i] - diagonalMatrix.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public DiagonalMatrix multiply(DiagonalMatrix diagonalMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, diagonalMatrix);
        int n = this.getRowDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.data[i] * diagonalMatrix.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public RealMatrix multiply(RealMatrix realMatrix) {
        if (realMatrix instanceof DiagonalMatrix) {
            return this.multiply((DiagonalMatrix)realMatrix);
        }
        MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.data[i] * realMatrix.getEntry(i, j);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    public double[][] getData() {
        int n = this.getRowDimension();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = this.data[i];
        }
        return dArray;
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double getEntry(int n, int n2) {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        return n == n2 ? this.data[n] : 0.0;
    }

    public void setEntry(int n, int n2, double d) {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            this.data[n] = d;
        } else {
            this.ensureZero(d);
        }
    }

    public void addToEntry(int n, int n2, double d) {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            int n3 = n;
            this.data[n3] = this.data[n3] + d;
        } else {
            this.ensureZero(d);
        }
    }

    public void multiplyEntry(int n, int n2, double d) {
        if (n == n2) {
            MatrixUtils.checkRowIndex(this, n);
            int n3 = n;
            this.data[n3] = this.data[n3] * d;
        }
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data.length;
    }

    public double[] operate(double[] dArray) {
        return this.multiply(new DiagonalMatrix(dArray, false)).getDataRef();
    }

    public double[] preMultiply(double[] dArray) {
        return this.operate(dArray);
    }

    public RealVector preMultiply(RealVector realVector) {
        double[] dArray = realVector instanceof ArrayRealVector ? ((ArrayRealVector)realVector).getDataRef() : realVector.toArray();
        return MatrixUtils.createRealVector(this.preMultiply(dArray));
    }

    private void ensureZero(double d) {
        if (!Precision.equals(0.0, d, 1)) {
            throw new NumberIsTooLargeException(FastMath.abs(d), (Number)0, true);
        }
    }

    public DiagonalMatrix inverse() {
        return this.inverse(0.0);
    }

    public DiagonalMatrix inverse(double d) {
        if (this.isSingular(d)) {
            throw new SingularMatrixException();
        }
        double[] dArray = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            dArray[i] = 1.0 / this.data[i];
        }
        return new DiagonalMatrix(dArray, false);
    }

    public boolean isSingular(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!Precision.equals(this.data[i], 0.0, d)) continue;
            return true;
        }
        return false;
    }
}

