/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

class HessenbergTransformer {
    private final double[][] householderVectors;
    private final double[] ort;
    private RealMatrix cachedP;
    private RealMatrix cachedPt;
    private RealMatrix cachedH;

    HessenbergTransformer(RealMatrix realMatrix) {
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n = realMatrix.getRowDimension();
        this.householderVectors = realMatrix.getData();
        this.ort = new double[n];
        this.cachedP = null;
        this.cachedPt = null;
        this.cachedH = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int n;
            int n2;
            int n3 = this.householderVectors.length;
            int n4 = n3 - 1;
            double[][] dArray = new double[n3][n3];
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    dArray[n2][n] = n2 == n ? 1.0 : 0.0;
                }
            }
            for (n2 = n4 - 1; n2 >= 1; --n2) {
                if (this.householderVectors[n2][n2 - 1] == 0.0) continue;
                for (n = n2 + 1; n <= n4; ++n) {
                    this.ort[n] = this.householderVectors[n][n2 - 1];
                }
                for (n = n2; n <= n4; ++n) {
                    int n5;
                    double d = 0.0;
                    for (n5 = n2; n5 <= n4; ++n5) {
                        d += this.ort[n5] * dArray[n5][n];
                    }
                    d = d / this.ort[n2] / this.householderVectors[n2][n2 - 1];
                    for (n5 = n2; n5 <= n4; ++n5) {
                        double[] dArray2 = dArray[n5];
                        int n6 = n;
                        dArray2[n6] = dArray2[n6] + d * this.ort[n5];
                    }
                }
            }
            this.cachedP = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int n = this.householderVectors.length;
            double[][] dArray = new double[n][n];
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    dArray[i][i - 1] = this.householderVectors[i][i - 1];
                }
                for (int j = i; j < n; ++j) {
                    dArray[i][j] = this.householderVectors[i][j];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(dArray);
        }
        return this.cachedH;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    private void transform() {
        int n = this.householderVectors.length;
        int n2 = n - 1;
        for (int i = 1; i <= n2 - 1; ++i) {
            int n3;
            double d;
            int n4;
            double d2 = 0.0;
            for (int j = i; j <= n2; ++j) {
                d2 += FastMath.abs(this.householderVectors[j][i - 1]);
            }
            if (Precision.equals(d2, 0.0)) continue;
            double d3 = 0.0;
            for (int j = n2; j >= i; --j) {
                this.ort[j] = this.householderVectors[j][i - 1] / d2;
                d3 += this.ort[j] * this.ort[j];
            }
            double d4 = this.ort[i] > 0.0 ? -FastMath.sqrt(d3) : FastMath.sqrt(d3);
            d3 -= this.ort[i] * d4;
            int n5 = i;
            this.ort[n5] = this.ort[n5] - d4;
            for (n4 = i; n4 < n; ++n4) {
                d = 0.0;
                for (n3 = n2; n3 >= i; --n3) {
                    d += this.ort[n3] * this.householderVectors[n3][n4];
                }
                d /= d3;
                for (n3 = i; n3 <= n2; ++n3) {
                    double[] dArray = this.householderVectors[n3];
                    int n6 = n4;
                    dArray[n6] = dArray[n6] - d * this.ort[n3];
                }
            }
            for (n4 = 0; n4 <= n2; ++n4) {
                d = 0.0;
                for (n3 = n2; n3 >= i; --n3) {
                    d += this.ort[n3] * this.householderVectors[n4][n3];
                }
                d /= d3;
                for (n3 = i; n3 <= n2; ++n3) {
                    double[] dArray = this.householderVectors[n4];
                    int n7 = n3;
                    dArray[n7] = dArray[n7] - d * this.ort[n3];
                }
            }
            this.ort[i] = d2 * this.ort[i];
            this.householderVectors[i][i - 1] = d2 * d4;
        }
    }
}

