/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SparseRealMatrix;
import org.apache.commons.math3.util.OpenIntToDoubleHashMap;

public class OpenMapRealMatrix
extends AbstractRealMatrix
implements SparseRealMatrix,
Serializable {
    private static final long serialVersionUID = -5962461716457143437L;
    private final int rows;
    private final int columns;
    private final OpenIntToDoubleHashMap entries;

    public OpenMapRealMatrix(int n, int n2) {
        super(n, n2);
        long l = n;
        long l2 = n2;
        if (l * l2 >= Integer.MAX_VALUE) {
            throw new NumberIsTooLargeException(l * l2, (Number)Integer.MAX_VALUE, false);
        }
        this.rows = n;
        this.columns = n2;
        this.entries = new OpenIntToDoubleHashMap(0.0);
    }

    public OpenMapRealMatrix(OpenMapRealMatrix openMapRealMatrix) {
        this.rows = openMapRealMatrix.rows;
        this.columns = openMapRealMatrix.columns;
        this.entries = new OpenIntToDoubleHashMap(openMapRealMatrix.entries);
    }

    public OpenMapRealMatrix copy() {
        return new OpenMapRealMatrix(this);
    }

    public OpenMapRealMatrix createMatrix(int n, int n2) {
        return new OpenMapRealMatrix(n, n2);
    }

    public int getColumnDimension() {
        return this.columns;
    }

    public OpenMapRealMatrix add(OpenMapRealMatrix openMapRealMatrix) {
        MatrixUtils.checkAdditionCompatible(this, openMapRealMatrix);
        OpenMapRealMatrix openMapRealMatrix2 = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator = openMapRealMatrix.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key() / this.columns;
            int n2 = iterator.key() - n * this.columns;
            openMapRealMatrix2.setEntry(n, n2, this.getEntry(n, n2) + iterator.value());
        }
        return openMapRealMatrix2;
    }

    public OpenMapRealMatrix subtract(RealMatrix realMatrix) {
        try {
            return this.subtract((OpenMapRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            return (OpenMapRealMatrix)super.subtract(realMatrix);
        }
    }

    public OpenMapRealMatrix subtract(OpenMapRealMatrix openMapRealMatrix) {
        MatrixUtils.checkAdditionCompatible(this, openMapRealMatrix);
        OpenMapRealMatrix openMapRealMatrix2 = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator = openMapRealMatrix.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key() / this.columns;
            int n2 = iterator.key() - n * this.columns;
            openMapRealMatrix2.setEntry(n, n2, this.getEntry(n, n2) - iterator.value());
        }
        return openMapRealMatrix2;
    }

    public RealMatrix multiply(RealMatrix realMatrix) {
        try {
            return this.multiply((OpenMapRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
            int n = realMatrix.getColumnDimension();
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, n);
            OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                double d = iterator.value();
                int n2 = iterator.key();
                int n3 = n2 / this.columns;
                int n4 = n2 % this.columns;
                for (int i = 0; i < n; ++i) {
                    blockRealMatrix.addToEntry(n3, i, d * realMatrix.getEntry(n4, i));
                }
            }
            return blockRealMatrix;
        }
    }

    public OpenMapRealMatrix multiply(OpenMapRealMatrix openMapRealMatrix) {
        MatrixUtils.checkMultiplicationCompatible(this, openMapRealMatrix);
        int n = openMapRealMatrix.getColumnDimension();
        OpenMapRealMatrix openMapRealMatrix2 = new OpenMapRealMatrix(this.rows, n);
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double d = iterator.value();
            int n2 = iterator.key();
            int n3 = n2 / this.columns;
            int n4 = n2 % this.columns;
            for (int i = 0; i < n; ++i) {
                int n5 = openMapRealMatrix.computeKey(n4, i);
                if (!openMapRealMatrix.entries.containsKey(n5)) continue;
                int n6 = openMapRealMatrix2.computeKey(n3, i);
                double d2 = openMapRealMatrix2.entries.get(n6) + d * openMapRealMatrix.entries.get(n5);
                if (d2 == 0.0) {
                    openMapRealMatrix2.entries.remove(n6);
                    continue;
                }
                openMapRealMatrix2.entries.put(n6, d2);
            }
        }
        return openMapRealMatrix2;
    }

    public double getEntry(int n, int n2) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        return this.entries.get(this.computeKey(n, n2));
    }

    public int getRowDimension() {
        return this.rows;
    }

    public void setEntry(int n, int n2, double d) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        if (d == 0.0) {
            this.entries.remove(this.computeKey(n, n2));
        } else {
            this.entries.put(this.computeKey(n, n2), d);
        }
    }

    public void addToEntry(int n, int n2, double d) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        int n3 = this.computeKey(n, n2);
        double d2 = this.entries.get(n3) + d;
        if (d2 == 0.0) {
            this.entries.remove(n3);
        } else {
            this.entries.put(n3, d2);
        }
    }

    public void multiplyEntry(int n, int n2, double d) {
        MatrixUtils.checkRowIndex(this, n);
        MatrixUtils.checkColumnIndex(this, n2);
        int n3 = this.computeKey(n, n2);
        double d2 = this.entries.get(n3) * d;
        if (d2 == 0.0) {
            this.entries.remove(n3);
        } else {
            this.entries.put(n3, d2);
        }
    }

    private int computeKey(int n, int n2) {
        return n * this.columns + n2;
    }
}

