/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SparseRealVector;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.OpenIntToDoubleHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMapRealVector
extends SparseRealVector
implements Serializable {
    public static final double DEFAULT_ZERO_TOLERANCE = 1.0E-12;
    private static final long serialVersionUID = 8772222695580707260L;
    private final OpenIntToDoubleHashMap entries;
    private final int virtualSize;
    private final double epsilon;

    public OpenMapRealVector() {
        this(0, 1.0E-12);
    }

    public OpenMapRealVector(int n) {
        this(n, 1.0E-12);
    }

    public OpenMapRealVector(int n, double d) {
        this.virtualSize = n;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = d;
    }

    protected OpenMapRealVector(OpenMapRealVector openMapRealVector, int n) {
        this.virtualSize = openMapRealVector.getDimension() + n;
        this.entries = new OpenIntToDoubleHashMap(openMapRealVector.entries);
        this.epsilon = openMapRealVector.epsilon;
    }

    public OpenMapRealVector(int n, int n2) {
        this(n, n2, 1.0E-12);
    }

    public OpenMapRealVector(int n, int n2, double d) {
        this.virtualSize = n;
        this.entries = new OpenIntToDoubleHashMap(n2, 0.0);
        this.epsilon = d;
    }

    public OpenMapRealVector(double[] dArray) {
        this(dArray, 1.0E-12);
    }

    public OpenMapRealVector(double[] dArray, double d) {
        this.virtualSize = dArray.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = d;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (this.isDefaultValue(d2)) continue;
            this.entries.put(i, d2);
        }
    }

    public OpenMapRealVector(Double[] doubleArray) {
        this(doubleArray, 1.0E-12);
    }

    public OpenMapRealVector(Double[] doubleArray, double d) {
        this.virtualSize = doubleArray.length;
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = d;
        for (int i = 0; i < doubleArray.length; ++i) {
            double d2 = doubleArray[i];
            if (this.isDefaultValue(d2)) continue;
            this.entries.put(i, d2);
        }
    }

    public OpenMapRealVector(OpenMapRealVector openMapRealVector) {
        this.virtualSize = openMapRealVector.getDimension();
        this.entries = new OpenIntToDoubleHashMap(openMapRealVector.getEntries());
        this.epsilon = openMapRealVector.epsilon;
    }

    public OpenMapRealVector(RealVector realVector) {
        this.virtualSize = realVector.getDimension();
        this.entries = new OpenIntToDoubleHashMap(0.0);
        this.epsilon = 1.0E-12;
        for (int i = 0; i < this.virtualSize; ++i) {
            double d = realVector.getEntry(i);
            if (this.isDefaultValue(d)) continue;
            this.entries.put(i, d);
        }
    }

    private OpenIntToDoubleHashMap getEntries() {
        return this.entries;
    }

    protected boolean isDefaultValue(double d) {
        return FastMath.abs(d) < this.epsilon;
    }

    @Override
    public RealVector add(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.add((OpenMapRealVector)realVector);
        }
        return super.add(realVector);
    }

    public OpenMapRealVector add(OpenMapRealVector openMapRealVector) {
        OpenIntToDoubleHashMap openIntToDoubleHashMap;
        this.checkVectorDimensions(openMapRealVector.getDimension());
        boolean bl = this.entries.size() > openMapRealVector.entries.size();
        OpenMapRealVector openMapRealVector2 = bl ? this.copy() : openMapRealVector.copy();
        OpenIntToDoubleHashMap.Iterator iterator = bl ? openMapRealVector.entries.iterator() : this.entries.iterator();
        OpenIntToDoubleHashMap openIntToDoubleHashMap2 = openIntToDoubleHashMap = bl ? this.entries : openMapRealVector.entries;
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key();
            if (openIntToDoubleHashMap.containsKey(n)) {
                openMapRealVector2.setEntry(n, openIntToDoubleHashMap.get(n) + iterator.value());
                continue;
            }
            openMapRealVector2.setEntry(n, iterator.value());
        }
        return openMapRealVector2;
    }

    public OpenMapRealVector append(OpenMapRealVector openMapRealVector) {
        OpenMapRealVector openMapRealVector2 = new OpenMapRealVector(this, openMapRealVector.getDimension());
        OpenIntToDoubleHashMap.Iterator iterator = openMapRealVector.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            openMapRealVector2.setEntry(iterator.key() + this.virtualSize, iterator.value());
        }
        return openMapRealVector2;
    }

    @Override
    public OpenMapRealVector append(RealVector realVector) {
        if (realVector instanceof OpenMapRealVector) {
            return this.append((OpenMapRealVector)realVector);
        }
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this, realVector.getDimension());
        for (int i = 0; i < realVector.getDimension(); ++i) {
            openMapRealVector.setEntry(i + this.virtualSize, realVector.getEntry(i));
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector append(double d) {
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this, 1);
        openMapRealVector.setEntry(this.virtualSize, d);
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector copy() {
        return new OpenMapRealVector(this);
    }

    @Deprecated
    public double dotProduct(OpenMapRealVector openMapRealVector) {
        return this.dotProduct((RealVector)openMapRealVector);
    }

    @Override
    public OpenMapRealVector ebeDivide(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this);
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            openMapRealVector.setEntry(i, this.getEntry(i) / realVector.getEntry(i));
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector ebeMultiply(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(this);
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            openMapRealVector.setEntry(iterator.key(), iterator.value() * realVector.getEntry(iterator.key()));
        }
        return openMapRealVector;
    }

    @Override
    public OpenMapRealVector getSubVector(int n, int n2) {
        this.checkIndex(n);
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        this.checkIndex(n + n2 - 1);
        OpenMapRealVector openMapRealVector = new OpenMapRealVector(n2);
        int n3 = n + n2;
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n4 = iterator.key();
            if (n4 < n || n4 >= n3) continue;
            openMapRealVector.setEntry(n4 - n, iterator.value());
        }
        return openMapRealVector;
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    public double getDistance(OpenMapRealVector openMapRealVector) {
        double d;
        int n;
        this.checkVectorDimensions(openMapRealVector.getDimension());
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        double d2 = 0.0;
        while (iterator.hasNext()) {
            iterator.advance();
            n = iterator.key();
            d = iterator.value() - openMapRealVector.getEntry(n);
            d2 += d * d;
        }
        iterator = openMapRealVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            n = iterator.key();
            if (this.entries.containsKey(n)) continue;
            d = iterator.value();
            d2 += d * d;
        }
        return FastMath.sqrt(d2);
    }

    @Override
    public double getDistance(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.getDistance((OpenMapRealVector)realVector);
        }
        return super.getDistance(realVector);
    }

    @Override
    public double getEntry(int n) {
        this.checkIndex(n);
        return this.entries.get(n);
    }

    public double getL1Distance(OpenMapRealVector openMapRealVector) {
        this.checkVectorDimensions(openMapRealVector.getDimension());
        double d = 0.0;
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double d2 = FastMath.abs(iterator.value() - openMapRealVector.getEntry(iterator.key()));
            d += d2;
        }
        iterator = openMapRealVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key();
            if (this.entries.containsKey(n)) continue;
            double d3 = FastMath.abs(iterator.value());
            d += FastMath.abs(d3);
        }
        return d;
    }

    @Override
    public double getL1Distance(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.getL1Distance((OpenMapRealVector)realVector);
        }
        return super.getL1Distance(realVector);
    }

    private double getLInfDistance(OpenMapRealVector openMapRealVector) {
        this.checkVectorDimensions(openMapRealVector.getDimension());
        double d = 0.0;
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double d2 = FastMath.abs(iterator.value() - openMapRealVector.getEntry(iterator.key()));
            if (!(d2 > d)) continue;
            d = d2;
        }
        iterator = openMapRealVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key();
            if (this.entries.containsKey(n) || !(iterator.value() > d)) continue;
            d = iterator.value();
        }
        return d;
    }

    @Override
    public double getLInfDistance(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.getLInfDistance((OpenMapRealVector)realVector);
        }
        return super.getLInfDistance(realVector);
    }

    @Override
    public boolean isInfinite() {
        boolean bl = false;
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double d = iterator.value();
            if (Double.isNaN(d)) {
                return false;
            }
            if (!Double.isInfinite(d)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isNaN() {
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            if (!Double.isNaN(iterator.value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public OpenMapRealVector mapAdd(double d) {
        return this.copy().mapAddToSelf(d);
    }

    @Override
    public OpenMapRealVector mapAddToSelf(double d) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, this.getEntry(i) + d);
        }
        return this;
    }

    @Override
    public void setEntry(int n, double d) {
        this.checkIndex(n);
        if (!this.isDefaultValue(d)) {
            this.entries.put(n, d);
        } else if (this.entries.containsKey(n)) {
            this.entries.remove(n);
        }
    }

    @Override
    public void setSubVector(int n, RealVector realVector) {
        this.checkIndex(n);
        this.checkIndex(n + realVector.getDimension() - 1);
        for (int i = 0; i < realVector.getDimension(); ++i) {
            this.setEntry(i + n, realVector.getEntry(i));
        }
    }

    @Override
    public void set(double d) {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, d);
        }
    }

    public OpenMapRealVector subtract(OpenMapRealVector openMapRealVector) {
        this.checkVectorDimensions(openMapRealVector.getDimension());
        OpenMapRealVector openMapRealVector2 = this.copy();
        OpenIntToDoubleHashMap.Iterator iterator = openMapRealVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key();
            if (this.entries.containsKey(n)) {
                openMapRealVector2.setEntry(n, this.entries.get(n) - iterator.value());
                continue;
            }
            openMapRealVector2.setEntry(n, -iterator.value());
        }
        return openMapRealVector2;
    }

    @Override
    public RealVector subtract(RealVector realVector) {
        this.checkVectorDimensions(realVector.getDimension());
        if (realVector instanceof OpenMapRealVector) {
            return this.subtract((OpenMapRealVector)realVector);
        }
        return super.subtract(realVector);
    }

    @Override
    public OpenMapRealVector unitVector() {
        OpenMapRealVector openMapRealVector = this.copy();
        openMapRealVector.unitize();
        return openMapRealVector;
    }

    @Override
    public void unitize() {
        double d = this.getNorm();
        if (this.isDefaultValue(d)) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            this.entries.put(iterator.key(), iterator.value() / d);
        }
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.virtualSize];
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            dArray[iterator.key()] = iterator.value();
        }
        return dArray;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.epsilon);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + this.virtualSize;
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            l = Double.doubleToLongBits(iterator.value());
            n2 = 31 * n2 + (int)(l ^ l >> 32);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        double d;
        if (this == object) {
            return true;
        }
        if (!(object instanceof OpenMapRealVector)) {
            return false;
        }
        OpenMapRealVector openMapRealVector = (OpenMapRealVector)object;
        if (this.virtualSize != openMapRealVector.virtualSize) {
            return false;
        }
        if (Double.doubleToLongBits(this.epsilon) != Double.doubleToLongBits(openMapRealVector.epsilon)) {
            return false;
        }
        OpenIntToDoubleHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            d = openMapRealVector.getEntry(iterator.key());
            if (Double.doubleToLongBits(d) == Double.doubleToLongBits(iterator.value())) continue;
            return false;
        }
        iterator = openMapRealVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            d = iterator.value();
            if (Double.doubleToLongBits(d) == Double.doubleToLongBits(this.getEntry(iterator.key()))) continue;
            return false;
        }
        return true;
    }

    public double getSparsity() {
        return (double)this.entries.size() / (double)this.getDimension();
    }

    @Override
    public Iterator<RealVector.Entry> sparseIterator() {
        return new OpenMapSparseIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OpenMapSparseIterator
    implements Iterator<RealVector.Entry> {
        private final OpenIntToDoubleHashMap.Iterator iter;
        private final RealVector.Entry current;

        protected OpenMapSparseIterator() {
            this.iter = OpenMapRealVector.this.entries.iterator();
            this.current = new OpenMapEntry(this.iter);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RealVector.Entry next() {
            this.iter.advance();
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    protected class OpenMapEntry
    extends RealVector.Entry {
        private final OpenIntToDoubleHashMap.Iterator iter;

        protected OpenMapEntry(OpenIntToDoubleHashMap.Iterator iterator) {
            this.iter = iterator;
        }

        public double getValue() {
            return this.iter.value();
        }

        public void setValue(double d) {
            OpenMapRealVector.this.entries.put(this.iter.key(), d);
        }

        public int getIndex() {
            return this.iter.key();
        }
    }
}

