/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.util.ExceptionContext;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DefaultIterativeLinearSolverEvent;
import org.apache.commons.math3.linear.IllConditionedOperatorException;
import org.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import org.apache.commons.math3.linear.NonSelfAdjointOperatorException;
import org.apache.commons.math3.linear.PreconditionedIterativeLinearSolver;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularOperatorException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.IterationManager;
import org.apache.commons.math3.util.MathUtils;

public class SymmLQ
extends PreconditionedIterativeLinearSolver {
    private static final String OPERATOR = "operator";
    private static final String THRESHOLD = "threshold";
    private static final String VECTOR = "vector";
    private static final String VECTOR1 = "vector1";
    private static final String VECTOR2 = "vector2";
    private final boolean check;
    private final double delta;

    public SymmLQ(int n, double d, boolean bl) {
        super(n);
        this.delta = d;
        this.check = bl;
    }

    public SymmLQ(IterationManager iterationManager, double d, boolean bl) {
        super(iterationManager);
        this.delta = d;
        this.check = bl;
    }

    public final boolean getCheck() {
        return this.check;
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, arrayRealVector, false, 0.0);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, boolean bl, double d) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, arrayRealVector, bl, d);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, realVector2.copy(), false, 0.0);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        ((RealVector)arrayRealVector).set(0.0);
        return this.solveInPlace(realLinearOperator, null, realVector, arrayRealVector, false, 0.0);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector, boolean bl, double d) {
        MathUtils.checkNotNull(realLinearOperator);
        ArrayRealVector arrayRealVector = new ArrayRealVector(realLinearOperator.getColumnDimension());
        return this.solveInPlace(realLinearOperator, null, realVector, arrayRealVector, bl, d);
    }

    public RealVector solve(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) {
        MathUtils.checkNotNull(realVector2);
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2.copy(), false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) {
        return this.solveInPlace(realLinearOperator, realLinearOperator2, realVector, realVector2, false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2, boolean bl, double d) {
        SymmLQ.checkParameters(realLinearOperator, realLinearOperator2, realVector, realVector2);
        IterationManager iterationManager = this.getIterationManager();
        iterationManager.resetIterationCount();
        iterationManager.incrementIterationCount();
        State state = new State(realLinearOperator, realLinearOperator2, realVector, bl, d, this.delta, this.check);
        state.init();
        state.refineSolution(realVector2);
        DefaultIterativeLinearSolverEvent defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, state.getNormOfResidual());
        if (state.bEqualsNullVector()) {
            iterationManager.fireTerminationEvent(defaultIterativeLinearSolverEvent);
            return realVector2;
        }
        boolean bl2 = state.betaEqualsZero() || state.hasConverged();
        iterationManager.fireInitializationEvent(defaultIterativeLinearSolverEvent);
        if (!bl2) {
            do {
                iterationManager.incrementIterationCount();
                defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, state.getNormOfResidual());
                iterationManager.fireIterationStartedEvent(defaultIterativeLinearSolverEvent);
                state.update();
                state.refineSolution(realVector2);
                defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, state.getNormOfResidual());
                iterationManager.fireIterationPerformedEvent(defaultIterativeLinearSolverEvent);
            } while (!state.hasConverged());
        }
        defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector2, realVector, state.getNormOfResidual());
        iterationManager.fireTerminationEvent(defaultIterativeLinearSolverEvent);
        return realVector2;
    }

    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2) {
        return this.solveInPlace(realLinearOperator, null, realVector, realVector2, false, 0.0);
    }

    private static class State {
        static final double CBRT_MACH_PREC;
        static final double MACH_PREC;
        private final RealLinearOperator a;
        private final RealVector b;
        private final boolean check;
        private final double delta;
        private double beta;
        private double beta1;
        private double bstep;
        private double cgnorm;
        private double dbar;
        private double gammaZeta;
        private double gbar;
        private double gmax;
        private double gmin;
        private final boolean goodb;
        private boolean hasConverged;
        private double lqnorm;
        private final RealLinearOperator m;
        private double minusEpsZeta;
        private final RealVector mb;
        private double oldb;
        private RealVector r1;
        private RealVector r2;
        private double rnorm;
        private final double shift;
        private double snprod;
        private double tnorm;
        private RealVector wbar;
        private final RealVector xL;
        private RealVector y;
        private double ynorm2;
        private boolean bIsNull;

        State(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, boolean bl, double d, double d2, boolean bl2) {
            this.a = realLinearOperator;
            this.m = realLinearOperator2;
            this.b = realVector;
            this.xL = new ArrayRealVector(realVector.getDimension());
            this.goodb = bl;
            this.shift = d;
            this.mb = realLinearOperator2 == null ? realVector : realLinearOperator2.operate(realVector);
            this.hasConverged = false;
            this.check = bl2;
            this.delta = d2;
        }

        private static void checkSymmetry(RealLinearOperator realLinearOperator, RealVector realVector, RealVector realVector2, RealVector realVector3) {
            double d = realVector2.dotProduct(realVector2);
            double d2 = realVector.dotProduct(realVector3);
            double d3 = (d + MACH_PREC) * CBRT_MACH_PREC;
            if (FastMath.abs(d - d2) > d3) {
                NonSelfAdjointOperatorException nonSelfAdjointOperatorException = new NonSelfAdjointOperatorException();
                ExceptionContext exceptionContext = nonSelfAdjointOperatorException.getContext();
                exceptionContext.setValue(SymmLQ.OPERATOR, realLinearOperator);
                exceptionContext.setValue(SymmLQ.VECTOR1, realVector);
                exceptionContext.setValue(SymmLQ.VECTOR2, realVector2);
                exceptionContext.setValue(SymmLQ.THRESHOLD, d3);
                throw nonSelfAdjointOperatorException;
            }
        }

        private static void throwNPDLOException(RealLinearOperator realLinearOperator, RealVector realVector) {
            NonPositiveDefiniteOperatorException nonPositiveDefiniteOperatorException = new NonPositiveDefiniteOperatorException();
            ExceptionContext exceptionContext = nonPositiveDefiniteOperatorException.getContext();
            exceptionContext.setValue(SymmLQ.OPERATOR, realLinearOperator);
            exceptionContext.setValue(SymmLQ.VECTOR, realVector);
            throw nonPositiveDefiniteOperatorException;
        }

        private static void daxpy(double d, RealVector realVector, RealVector realVector2) {
            int n = realVector.getDimension();
            for (int i = 0; i < n; ++i) {
                realVector2.setEntry(i, d * realVector.getEntry(i) + realVector2.getEntry(i));
            }
        }

        private static void daxpbypz(double d, RealVector realVector, double d2, RealVector realVector2, RealVector realVector3) {
            int n = realVector3.getDimension();
            for (int i = 0; i < n; ++i) {
                double d3 = d * realVector.getEntry(i) + d2 * realVector2.getEntry(i) + realVector3.getEntry(i);
                realVector3.setEntry(i, d3);
            }
        }

        void refineSolution(RealVector realVector) {
            int n = this.xL.getDimension();
            if (this.lqnorm < this.cgnorm) {
                if (!this.goodb) {
                    realVector.setSubVector(0, this.xL);
                } else {
                    double d = this.bstep / this.beta1;
                    for (int i = 0; i < n; ++i) {
                        double d2 = this.mb.getEntry(i);
                        double d3 = this.xL.getEntry(i);
                        realVector.setEntry(i, d3 + d * d2);
                    }
                }
            } else {
                double d = FastMath.sqrt(this.tnorm);
                double d4 = this.gbar == 0.0 ? d * MACH_PREC : this.gbar;
                double d5 = this.gammaZeta / d4;
                double d6 = (this.bstep + this.snprod * d5) / this.beta1;
                if (!this.goodb) {
                    for (int i = 0; i < n; ++i) {
                        double d7 = this.xL.getEntry(i);
                        double d8 = this.wbar.getEntry(i);
                        realVector.setEntry(i, d7 + d5 * d8);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double d9 = this.xL.getEntry(i);
                        double d10 = this.wbar.getEntry(i);
                        double d11 = this.mb.getEntry(i);
                        realVector.setEntry(i, d9 + d5 * d10 + d6 * d11);
                    }
                }
            }
        }

        void init() {
            this.xL.set(0.0);
            this.r1 = this.b.copy();
            RealVector realVector = this.y = this.m == null ? this.b.copy() : this.m.operate(this.r1);
            if (this.m != null && this.check) {
                State.checkSymmetry(this.m, this.r1, this.y, this.m.operate(this.y));
            }
            this.beta1 = this.r1.dotProduct(this.y);
            if (this.beta1 < 0.0) {
                State.throwNPDLOException(this.m, this.y);
            }
            if (this.beta1 == 0.0) {
                this.bIsNull = true;
                return;
            }
            this.bIsNull = false;
            this.beta1 = FastMath.sqrt(this.beta1);
            RealVector realVector2 = this.y.mapMultiply(1.0 / this.beta1);
            this.y = this.a.operate(realVector2);
            if (this.check) {
                State.checkSymmetry(this.a, realVector2, this.y, this.a.operate(this.y));
            }
            State.daxpy(-this.shift, realVector2, this.y);
            double d = realVector2.dotProduct(this.y);
            State.daxpy(-d / this.beta1, this.r1, this.y);
            double d2 = realVector2.dotProduct(this.y);
            double d3 = realVector2.dotProduct(realVector2);
            State.daxpy(-d2 / d3, realVector2, this.y);
            this.r2 = this.y.copy();
            if (this.m != null) {
                this.y = this.m.operate(this.r2);
            }
            this.oldb = this.beta1;
            this.beta = this.r2.dotProduct(this.y);
            if (this.beta < 0.0) {
                State.throwNPDLOException(this.m, this.y);
            }
            this.beta = FastMath.sqrt(this.beta);
            this.cgnorm = this.beta1;
            this.gbar = d;
            this.dbar = this.beta;
            this.gammaZeta = this.beta1;
            this.minusEpsZeta = 0.0;
            this.bstep = 0.0;
            this.snprod = 1.0;
            this.tnorm = d * d + this.beta * this.beta;
            this.ynorm2 = 0.0;
            this.gmin = this.gmax = FastMath.abs(d) + MACH_PREC;
            if (this.goodb) {
                this.wbar = new ArrayRealVector(this.a.getRowDimension());
                this.wbar.set(0.0);
            } else {
                this.wbar = realVector2;
            }
            this.updateNorms();
        }

        void update() {
            RealVector realVector = this.y.mapMultiply(1.0 / this.beta);
            this.y = this.a.operate(realVector);
            State.daxpbypz(-this.shift, realVector, -this.beta / this.oldb, this.r1, this.y);
            double d = realVector.dotProduct(this.y);
            State.daxpy(-d / this.beta, this.r2, this.y);
            this.r1 = this.r2;
            this.r2 = this.y;
            if (this.m != null) {
                this.y = this.m.operate(this.r2);
            }
            this.oldb = this.beta;
            this.beta = this.r2.dotProduct(this.y);
            if (this.beta < 0.0) {
                State.throwNPDLOException(this.m, this.y);
            }
            this.beta = FastMath.sqrt(this.beta);
            this.tnorm += d * d + this.oldb * this.oldb + this.beta * this.beta;
            double d2 = FastMath.sqrt(this.gbar * this.gbar + this.oldb * this.oldb);
            double d3 = this.gbar / d2;
            double d4 = this.oldb / d2;
            double d5 = d3 * this.dbar + d4 * d;
            this.gbar = d4 * this.dbar - d3 * d;
            double d6 = d4 * this.beta;
            this.dbar = -d3 * this.beta;
            double d7 = this.gammaZeta / d2;
            double d8 = d7 * d3;
            double d9 = d7 * d4;
            int n = this.xL.getDimension();
            for (int i = 0; i < n; ++i) {
                double d10 = this.xL.getEntry(i);
                double d11 = realVector.getEntry(i);
                double d12 = this.wbar.getEntry(i);
                this.xL.setEntry(i, d10 + d12 * d8 + d11 * d9);
                this.wbar.setEntry(i, d12 * d4 - d11 * d3);
            }
            this.bstep += this.snprod * d3 * d7;
            this.snprod *= d4;
            this.gmax = FastMath.max(this.gmax, d2);
            this.gmin = FastMath.min(this.gmin, d2);
            this.ynorm2 += d7 * d7;
            this.gammaZeta = this.minusEpsZeta - d5 * d7;
            this.minusEpsZeta = -d6 * d7;
            this.updateNorms();
        }

        private void updateNorms() {
            double d = FastMath.sqrt(this.tnorm);
            double d2 = FastMath.sqrt(this.ynorm2);
            double d3 = d * MACH_PREC;
            double d4 = d * d2 * MACH_PREC;
            double d5 = d * d2 * this.delta;
            double d6 = this.gbar == 0.0 ? d3 : this.gbar;
            this.lqnorm = FastMath.sqrt(this.gammaZeta * this.gammaZeta + this.minusEpsZeta * this.minusEpsZeta);
            double d7 = this.snprod * this.beta1;
            this.cgnorm = d7 * this.beta / FastMath.abs(d6);
            double d8 = this.lqnorm <= this.cgnorm ? this.gmax / this.gmin : this.gmax / FastMath.min(this.gmin, FastMath.abs(d6));
            if (d8 * MACH_PREC >= 0.1) {
                throw new IllConditionedOperatorException(d8);
            }
            if (this.beta1 <= d4) {
                throw new SingularOperatorException();
            }
            this.rnorm = FastMath.min(this.cgnorm, this.lqnorm);
            this.hasConverged = this.cgnorm <= d4 || this.cgnorm <= d5;
        }

        boolean hasConverged() {
            return this.hasConverged;
        }

        boolean bEqualsNullVector() {
            return this.bIsNull;
        }

        boolean betaEqualsZero() {
            return this.beta < MACH_PREC;
        }

        double getNormOfResidual() {
            return this.rnorm;
        }

        static {
            MACH_PREC = FastMath.ulp(1.0);
            CBRT_MACH_PREC = FastMath.cbrt(MACH_PREC);
        }
    }
}

