/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.Clusterer;
import org.apache.commons.math3.ml.clustering.DoublePoint;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansPlusPlusClusterer<T extends Clusterable>
extends Clusterer<T> {
    private final int k;
    private final int maxIterations;
    private final RandomGenerator random;
    private final EmptyClusterStrategy emptyStrategy;

    public KMeansPlusPlusClusterer(int n) {
        this(n, -1);
    }

    public KMeansPlusPlusClusterer(int n, int n2) {
        this(n, n2, new EuclideanDistance());
    }

    public KMeansPlusPlusClusterer(int n, int n2, DistanceMeasure distanceMeasure) {
        this(n, n2, distanceMeasure, new JDKRandomGenerator());
    }

    public KMeansPlusPlusClusterer(int n, int n2, DistanceMeasure distanceMeasure, RandomGenerator randomGenerator) {
        this(n, n2, distanceMeasure, randomGenerator, EmptyClusterStrategy.LARGEST_VARIANCE);
    }

    public KMeansPlusPlusClusterer(int n, int n2, DistanceMeasure distanceMeasure, RandomGenerator randomGenerator, EmptyClusterStrategy emptyClusterStrategy) {
        super(distanceMeasure);
        this.k = n;
        this.maxIterations = n2;
        this.random = randomGenerator;
        this.emptyStrategy = emptyClusterStrategy;
    }

    public int getK() {
        return this.k;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public RandomGenerator getRandomGenerator() {
        return this.random;
    }

    public EmptyClusterStrategy getEmptyClusterStrategy() {
        return this.emptyStrategy;
    }

    @Override
    public List<CentroidCluster<T>> cluster(Collection<T> collection) {
        MathUtils.checkNotNull(collection);
        if (collection.size() < this.k) {
            throw new NumberIsTooSmallException(collection.size(), (Number)this.k, false);
        }
        List<CentroidCluster<T>> list = this.chooseInitialCenters(collection);
        int[] nArray = new int[collection.size()];
        this.assignPointsToClusters(list, collection, nArray);
        int n = this.maxIterations < 0 ? Integer.MAX_VALUE : this.maxIterations;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            ArrayList<CentroidCluster<T>> arrayList = new ArrayList<CentroidCluster<T>>();
            for (CentroidCluster<T> centroidCluster : list) {
                Clusterable clusterable;
                if (centroidCluster.getPoints().isEmpty()) {
                    switch (this.emptyStrategy) {
                        case LARGEST_VARIANCE: {
                            clusterable = this.getPointFromLargestVarianceCluster(list);
                            break;
                        }
                        case LARGEST_POINTS_NUMBER: {
                            clusterable = this.getPointFromLargestNumberCluster(list);
                            break;
                        }
                        case FARTHEST_POINT: {
                            clusterable = this.getFarthestPoint(list);
                            break;
                        }
                        default: {
                            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
                        }
                    }
                    bl = true;
                } else {
                    clusterable = this.centroidOf(centroidCluster.getPoints(), centroidCluster.getCenter().getPoint().length);
                }
                arrayList.add(new CentroidCluster(clusterable));
            }
            int n2 = this.assignPointsToClusters(arrayList, collection, nArray);
            list = arrayList;
            if (n2 != 0 || bl) continue;
            return list;
        }
        return list;
    }

    private int assignPointsToClusters(List<CentroidCluster<T>> list, Collection<T> collection, int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (Clusterable clusterable : collection) {
            int n3 = this.getNearestCluster(list, clusterable);
            if (n3 != nArray[n2]) {
                ++n;
            }
            CentroidCluster<Clusterable> centroidCluster = list.get(n3);
            centroidCluster.addPoint(clusterable);
            nArray[n2++] = n3;
        }
        return n;
    }

    private List<CentroidCluster<T>> chooseInitialCenters(Collection<T> collection) {
        List<T> list = Collections.unmodifiableList(new ArrayList<T>(collection));
        int n = list.size();
        boolean[] blArray = new boolean[n];
        ArrayList<CentroidCluster<T>> arrayList = new ArrayList<CentroidCluster<T>>();
        int n2 = this.random.nextInt(n);
        Clusterable clusterable = (Clusterable)list.get(n2);
        arrayList.add(new CentroidCluster(clusterable));
        blArray[n2] = true;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            if (i == n2) continue;
            double d = this.distance(clusterable, (Clusterable)list.get(i));
            dArray[i] = d * d;
        }
        while (arrayList.size() < this.k) {
            int n3;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                if (blArray[i]) continue;
                d += dArray[i];
            }
            double d2 = this.random.nextDouble() * d;
            int n4 = -1;
            double d3 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                if (blArray[n3] || !((d3 += dArray[n3]) >= d2)) continue;
                n4 = n3;
                break;
            }
            if (n4 == -1) {
                for (n3 = n - 1; n3 >= 0; --n3) {
                    if (blArray[n3]) continue;
                    n4 = n3;
                    break;
                }
            }
            if (n4 < 0) break;
            Clusterable clusterable2 = (Clusterable)list.get(n4);
            arrayList.add(new CentroidCluster(clusterable2));
            blArray[n4] = true;
            if (arrayList.size() >= this.k) continue;
            for (int i = 0; i < n; ++i) {
                double d4;
                double d5;
                if (blArray[i] || !((d5 = (d4 = this.distance(clusterable2, (Clusterable)list.get(i))) * d4) < dArray[i])) continue;
                dArray[i] = d5;
            }
        }
        return arrayList;
    }

    private T getPointFromLargestVarianceCluster(Collection<CentroidCluster<T>> collection) {
        double d = Double.NEGATIVE_INFINITY;
        CentroidCluster<T> centroidCluster = null;
        for (CentroidCluster<T> centroidCluster2 : collection) {
            if (centroidCluster2.getPoints().isEmpty()) continue;
            Clusterable clusterable = centroidCluster2.getCenter();
            Variance variance = new Variance();
            for (Clusterable clusterable2 : centroidCluster2.getPoints()) {
                variance.increment(this.distance(clusterable2, clusterable));
            }
            double d2 = variance.getResult();
            if (!(d2 > d)) continue;
            d = d2;
            centroidCluster = centroidCluster2;
        }
        if (centroidCluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List list = centroidCluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getPointFromLargestNumberCluster(Collection<? extends Cluster<T>> collection) {
        int n = 0;
        Cluster<T> cluster = null;
        for (Cluster<T> cluster2 : collection) {
            int n2 = cluster2.getPoints().size();
            if (n2 <= n) continue;
            n = n2;
            cluster = cluster2;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        List list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getFarthestPoint(Collection<CentroidCluster<T>> collection) {
        double d = Double.NEGATIVE_INFINITY;
        CentroidCluster<T> centroidCluster = null;
        int n = -1;
        for (CentroidCluster<T> centroidCluster2 : collection) {
            Clusterable clusterable = centroidCluster2.getCenter();
            List list = centroidCluster2.getPoints();
            for (int i = 0; i < list.size(); ++i) {
                double d2 = this.distance((Clusterable)list.get(i), clusterable);
                if (!(d2 > d)) continue;
                d = d2;
                centroidCluster = centroidCluster2;
                n = i;
            }
        }
        if (centroidCluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        return (T)((Clusterable)centroidCluster.getPoints().remove(n));
    }

    private int getNearestCluster(Collection<CentroidCluster<T>> collection, T t) {
        double d = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        for (CentroidCluster<T> centroidCluster : collection) {
            double d2 = this.distance((Clusterable)t, centroidCluster.getCenter());
            if (d2 < d) {
                d = d2;
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    private Clusterable centroidOf(Collection<T> collection, int n) {
        double[] dArray = new double[n];
        for (Clusterable clusterable : collection) {
            double[] dArray2 = clusterable.getPoint();
            for (int i = 0; i < dArray.length; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + dArray2[i];
            }
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] / (double)collection.size();
        }
        return new DoublePoint(dArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EmptyClusterStrategy {
        LARGEST_VARIANCE,
        LARGEST_POINTS_NUMBER,
        FARTHEST_POINT,
        ERROR;

    }
}

