/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.clustering.evaluation;

import java.util.List;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.evaluation.ClusterEvaluator;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.stat.descriptive.moment.Variance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumOfClusterVariances<T extends Clusterable>
extends ClusterEvaluator<T> {
    public SumOfClusterVariances(DistanceMeasure distanceMeasure) {
        super(distanceMeasure);
    }

    @Override
    public double score(List<? extends Cluster<T>> list) {
        double d = 0.0;
        for (Cluster<T> cluster : list) {
            if (cluster.getPoints().isEmpty()) continue;
            Clusterable clusterable = this.centroidOf(cluster);
            Variance variance = new Variance();
            for (Clusterable clusterable2 : cluster.getPoints()) {
                variance.increment(this.distance(clusterable2, clusterable));
            }
            d += variance.getResult();
        }
        return d;
    }
}

