/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.distance;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class EarthMoversDistance
implements DistanceMeasure {
    private static final long serialVersionUID = -5406732779747414922L;

    public double compute(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] + d - dArray2[i];
            d2 += FastMath.abs(d3);
            d = d3;
        }
        return d2;
    }
}

