/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Constant;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.random.RandomGenerator;

public class FeatureInitializerFactory {
    private FeatureInitializerFactory() {
    }

    public static FeatureInitializer uniform(RandomGenerator randomGenerator, double d, double d2) {
        return FeatureInitializerFactory.randomize(new UniformRealDistribution(randomGenerator, d, d2), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer uniform(double d, double d2) {
        return FeatureInitializerFactory.randomize(new UniformRealDistribution(d, d2), FeatureInitializerFactory.function(new Constant(0.0), 0.0, 0.0));
    }

    public static FeatureInitializer function(final UnivariateFunction univariateFunction, final double d, final double d2) {
        return new FeatureInitializer(){
            private double arg;
            {
                this.arg = d;
            }

            public double value() {
                double d3 = univariateFunction.value(this.arg);
                this.arg += d2;
                return d3;
            }
        };
    }

    public static FeatureInitializer randomize(final RealDistribution realDistribution, final FeatureInitializer featureInitializer) {
        return new FeatureInitializer(){

            public double value() {
                return featureInitializer.value() + realDistribution.sample();
            }
        };
    }
}

