/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    private MapUtils() {
    }

    public static Neuron findBest(double[] dArray, Iterable<Neuron> iterable, DistanceMeasure distanceMeasure) {
        Neuron neuron = null;
        double d = Double.POSITIVE_INFINITY;
        for (Neuron neuron2 : iterable) {
            double d2 = distanceMeasure.compute(neuron2.getFeatures(), dArray);
            if (!(d2 < d)) continue;
            d = d2;
            neuron = neuron2;
        }
        return neuron;
    }

    public static Pair<Neuron, Neuron> findBestAndSecondBest(double[] dArray, Iterable<Neuron> iterable, DistanceMeasure distanceMeasure) {
        Neuron[] neuronArray = new Neuron[]{null, null};
        double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        for (Neuron neuron : iterable) {
            double d = distanceMeasure.compute(neuron.getFeatures(), dArray);
            if (d < dArray2[0]) {
                dArray2[1] = dArray2[0];
                neuronArray[1] = neuronArray[0];
                dArray2[0] = d;
                neuronArray[0] = neuron;
                continue;
            }
            if (!(d < dArray2[1])) continue;
            dArray2[1] = d;
            neuronArray[1] = neuron;
        }
        return new Pair<Neuron, Neuron>(neuronArray[0], neuronArray[1]);
    }

    public static Neuron[] sort(double[] dArray, Iterable<Neuron> iterable, DistanceMeasure distanceMeasure) {
        ArrayList<PairNeuronDouble> arrayList = new ArrayList<PairNeuronDouble>();
        for (Neuron neuronArray2 : iterable) {
            double i = distanceMeasure.compute(neuronArray2.getFeatures(), dArray);
            arrayList.add(new PairNeuronDouble(neuronArray2, i));
        }
        Collections.sort(arrayList, PairNeuronDouble.COMPARATOR);
        int n = arrayList.size();
        Neuron[] neuronArray = new Neuron[n];
        for (int i = 0; i < n; ++i) {
            neuronArray[i] = ((PairNeuronDouble)arrayList.get(i)).getNeuron();
        }
        return neuronArray;
    }

    public static double[][] computeU(NeuronSquareMesh2D neuronSquareMesh2D, DistanceMeasure distanceMeasure) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        double[][] dArray = new double[n][n2];
        Network network = neuronSquareMesh2D.getNetwork();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Neuron neuron = neuronSquareMesh2D.getNeuron(i, j);
                Collection<Neuron> collection = network.getNeighbours(neuron);
                double[] dArray2 = neuron.getFeatures();
                double d = 0.0;
                int n3 = 0;
                for (Neuron neuron2 : collection) {
                    ++n3;
                    d += distanceMeasure.compute(dArray2, neuron2.getFeatures());
                }
                dArray[i][j] = d / (double)n3;
            }
        }
        return dArray;
    }

    public static int[][] computeHitHistogram(Iterable<double[]> iterable, NeuronSquareMesh2D neuronSquareMesh2D, DistanceMeasure distanceMeasure) {
        Object object;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Network network = neuronSquareMesh2D.getNetwork();
        for (double[] dArray : iterable) {
            object = MapUtils.findBest(dArray, network, distanceMeasure);
            Integer n = (Integer)hashMap.get(object);
            if (n == null) {
                hashMap.put(object, 1);
                continue;
            }
            hashMap.put(object, n + 1);
        }
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        object = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Neuron neuron = neuronSquareMesh2D.getNeuron(i, j);
                Integer n3 = (Integer)hashMap.get(neuron);
                object[i][j] = n3 == null ? (Object)false : (Object)n3;
            }
        }
        return object;
    }

    public static double computeQuantizationError(Iterable<double[]> iterable, Iterable<Neuron> iterable2, DistanceMeasure distanceMeasure) {
        double d = 0.0;
        int n = 0;
        for (double[] dArray : iterable) {
            ++n;
            d += distanceMeasure.compute(dArray, MapUtils.findBest(dArray, iterable2, distanceMeasure).getFeatures());
        }
        if (n == 0) {
            throw new NoDataException();
        }
        return d / (double)n;
    }

    public static double computeTopographicError(Iterable<double[]> iterable, Network network, DistanceMeasure distanceMeasure) {
        int n = 0;
        int n2 = 0;
        for (double[] dArray : iterable) {
            ++n2;
            Pair<Neuron, Neuron> pair = MapUtils.findBestAndSecondBest(dArray, network, distanceMeasure);
            if (network.getNeighbours(pair.getFirst()).contains(pair.getSecond())) continue;
            ++n;
        }
        if (n2 == 0) {
            throw new NoDataException();
        }
        return (double)n / (double)n2;
    }

    private static class PairNeuronDouble {
        static final Comparator<PairNeuronDouble> COMPARATOR = new Comparator<PairNeuronDouble>(){

            @Override
            public int compare(PairNeuronDouble pairNeuronDouble, PairNeuronDouble pairNeuronDouble2) {
                return Double.compare(pairNeuronDouble.value, pairNeuronDouble2.value);
            }
        };
        private final Neuron neuron;
        private final double value;

        PairNeuronDouble(Neuron neuron, double d) {
            this.neuron = neuron;
            this.value = d;
        }

        public Neuron getNeuron() {
            return this.neuron;
        }
    }
}

