/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.oned;

import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.Network;

public class NeuronString
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Network network;
    private final int size;
    private final boolean wrap;
    private final long[] identifiers;

    NeuronString(boolean bl, double[][] dArray) {
        this.size = dArray.length;
        if (this.size < 2) {
            throw new NumberIsTooSmallException(this.size, (Number)2, true);
        }
        this.wrap = bl;
        int n = dArray[0].length;
        this.network = new Network(0L, n);
        this.identifiers = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.identifiers[i] = this.network.createNeuron(dArray[i]);
        }
        this.createLinks();
    }

    public NeuronString(int n, boolean bl, FeatureInitializer[] featureInitializerArray) {
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.size = n;
        this.wrap = bl;
        this.identifiers = new long[n];
        int n2 = featureInitializerArray.length;
        this.network = new Network(0L, n2);
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArray[j] = featureInitializerArray[j].value();
            }
            this.identifiers[i] = this.network.createNeuron(dArray);
        }
        this.createLinks();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getFeatures(int n) {
        if (n < 0 || n >= this.size) {
            throw new OutOfRangeException(n, (Number)0, this.size - 1);
        }
        return this.network.getNeuron(this.identifiers[n]).getFeatures();
    }

    private void createLinks() {
        int n;
        for (n = 0; n < this.size - 1; ++n) {
            this.network.addLink(this.network.getNeuron(n), this.network.getNeuron(n + 1));
        }
        for (n = this.size - 1; n > 0; --n) {
            this.network.addLink(this.network.getNeuron(n), this.network.getNeuron(n - 1));
        }
        if (this.wrap) {
            this.network.addLink(this.network.getNeuron(0L), this.network.getNeuron(this.size - 1));
            this.network.addLink(this.network.getNeuron(this.size - 1), this.network.getNeuron(0L));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        double[][] dArrayArray = new double[this.size][];
        for (int i = 0; i < this.size; ++i) {
            dArrayArray[i] = this.getFeatures(i);
        }
        return new SerializationProxy(this.wrap, dArrayArray);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 20130226L;
        private final boolean wrap;
        private final double[][] featuresList;

        SerializationProxy(boolean bl, double[][] dArray) {
            this.wrap = bl;
            this.featuresList = dArray;
        }

        private Object readResolve() {
            return new NeuronString(this.wrap, this.featuresList);
        }
    }
}

