/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.ml.neuralnet.sofm.NeighbourhoodSizeFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.ExponentialDecayFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction;
import org.apache.commons.math3.util.FastMath;

public class NeighbourhoodSizeFunctionFactory {
    private NeighbourhoodSizeFunctionFactory() {
    }

    public static NeighbourhoodSizeFunction exponentialDecay(final double d, final double d2, final long l) {
        return new NeighbourhoodSizeFunction(){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(d, d2, l);
            }

            public int value(long l2) {
                return (int)FastMath.rint(this.decay.value(l2));
            }
        };
    }

    public static NeighbourhoodSizeFunction quasiSigmoidDecay(final double d, final double d2, final long l) {
        return new NeighbourhoodSizeFunction(){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(d, d2, l);
            }

            public int value(long l2) {
                return (int)FastMath.rint(this.decay.value(l2));
            }
        };
    }
}

