/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm.util;

import org.apache.commons.math3.analysis.function.Logistic;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;

public class QuasiSigmoidDecayFunction {
    private final Logistic sigmoid;
    private final double scale;

    public QuasiSigmoidDecayFunction(double d, double d2, long l) {
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException(d);
        }
        if (d2 >= 0.0) {
            throw new NumberIsTooLargeException(d2, (Number)0, false);
        }
        if (l <= 1L) {
            throw new NotStrictlyPositiveException(l);
        }
        double d3 = d;
        double d4 = l;
        double d5 = 4.0 * d2 / d;
        double d6 = 1.0;
        double d7 = 0.0;
        double d8 = 1.0;
        this.sigmoid = new Logistic(d3, d4, d5, 1.0, 0.0, 1.0);
        double d9 = this.sigmoid.value(0.0);
        this.scale = d3 / d9;
    }

    public double value(long l) {
        return this.scale * this.sigmoid.value(l);
    }
}

