/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.SquareNeighbourhood;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuronSquareMesh2D
implements Iterable<Neuron>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Network network;
    private final int numberOfRows;
    private final int numberOfColumns;
    private final boolean wrapRows;
    private final boolean wrapColumns;
    private final SquareNeighbourhood neighbourhood;
    private final long[][] identifiers;

    NeuronSquareMesh2D(boolean bl, boolean bl2, SquareNeighbourhood squareNeighbourhood, double[][][] dArray) {
        this.numberOfRows = dArray.length;
        this.numberOfColumns = dArray[0].length;
        if (this.numberOfRows < 2) {
            throw new NumberIsTooSmallException(this.numberOfRows, (Number)2, true);
        }
        if (this.numberOfColumns < 2) {
            throw new NumberIsTooSmallException(this.numberOfColumns, (Number)2, true);
        }
        this.wrapRows = bl;
        this.wrapColumns = bl2;
        this.neighbourhood = squareNeighbourhood;
        int n = dArray[0][0].length;
        this.network = new Network(0L, n);
        this.identifiers = new long[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.identifiers[i][j] = this.network.createNeuron(dArray[i][j]);
            }
        }
        this.createLinks();
    }

    public NeuronSquareMesh2D(int n, boolean bl, int n2, boolean bl2, SquareNeighbourhood squareNeighbourhood, FeatureInitializer[] featureInitializerArray) {
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        if (n2 < 2) {
            throw new NumberIsTooSmallException(n2, (Number)2, true);
        }
        this.numberOfRows = n;
        this.wrapRows = bl;
        this.numberOfColumns = n2;
        this.wrapColumns = bl2;
        this.neighbourhood = squareNeighbourhood;
        this.identifiers = new long[this.numberOfRows][this.numberOfColumns];
        int n3 = featureInitializerArray.length;
        this.network = new Network(0L, n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double[] dArray = new double[n3];
                for (int k = 0; k < n3; ++k) {
                    dArray[k] = featureInitializerArray[k].value();
                }
                this.identifiers[i][j] = this.network.createNeuron(dArray);
            }
        }
        this.createLinks();
    }

    private NeuronSquareMesh2D(boolean bl, boolean bl2, SquareNeighbourhood squareNeighbourhood, Network network, long[][] lArray) {
        this.numberOfRows = lArray.length;
        this.numberOfColumns = lArray[0].length;
        this.wrapRows = bl;
        this.wrapColumns = bl2;
        this.neighbourhood = squareNeighbourhood;
        this.network = network;
        this.identifiers = lArray;
    }

    public synchronized NeuronSquareMesh2D copy() {
        long[][] lArray = new long[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                lArray[i][j] = this.identifiers[i][j];
            }
        }
        return new NeuronSquareMesh2D(this.wrapRows, this.wrapColumns, this.neighbourhood, this.network.copy(), lArray);
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.network.iterator();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public Neuron getNeuron(int n, int n2) {
        if (n < 0 || n >= this.numberOfRows) {
            throw new OutOfRangeException(n, (Number)0, this.numberOfRows - 1);
        }
        if (n2 < 0 || n2 >= this.numberOfColumns) {
            throw new OutOfRangeException(n2, (Number)0, this.numberOfColumns - 1);
        }
        return this.network.getNeuron(this.identifiers[n][n2]);
    }

    public Neuron getNeuron(int n, int n2, HorizontalDirection horizontalDirection, VerticalDirection verticalDirection) {
        int[] nArray = this.getLocation(n, n2, horizontalDirection, verticalDirection);
        return nArray == null ? null : this.getNeuron(nArray[0], nArray[1]);
    }

    private int[] getLocation(int n, int n2, HorizontalDirection horizontalDirection, VerticalDirection verticalDirection) {
        int n3;
        int n4;
        switch (horizontalDirection) {
            case LEFT: {
                n4 = -1;
                break;
            }
            case RIGHT: {
                n4 = 1;
                break;
            }
            case CENTER: {
                n4 = 0;
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
        int n5 = n2 + n4;
        if (this.wrapColumns) {
            n5 = n5 < 0 ? (n5 += this.numberOfColumns) : (n5 %= this.numberOfColumns);
        }
        switch (verticalDirection) {
            case UP: {
                n3 = -1;
                break;
            }
            case DOWN: {
                n3 = 1;
                break;
            }
            case CENTER: {
                n3 = 0;
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
        int n6 = n + n3;
        if (this.wrapRows) {
            n6 = n6 < 0 ? (n6 += this.numberOfRows) : (n6 %= this.numberOfRows);
        }
        if (n6 < 0 || n6 >= this.numberOfRows || n5 < 0 || n5 >= this.numberOfColumns) {
            return null;
        }
        return new int[]{n6, n5};
    }

    /*
     * Unable to fully structure code
     */
    private void createLinks() {
        var1_1 = new ArrayList<Long>();
        var2_2 = this.numberOfRows - 1;
        var3_3 = this.numberOfColumns - 1;
        for (var4_4 = 0; var4_4 < this.numberOfRows; ++var4_4) {
            for (var5_5 = 0; var5_5 < this.numberOfColumns; ++var5_5) {
                var1_1.clear();
                switch (1.$SwitchMap$org$apache$commons$math3$ml$neuralnet$SquareNeighbourhood[this.neighbourhood.ordinal()]) {
                    case 1: {
                        if (var4_4 > 0) {
                            if (var5_5 > 0) {
                                var1_1.add(this.identifiers[var4_4 - 1][var5_5 - 1]);
                            }
                            if (var5_5 < var3_3) {
                                var1_1.add(this.identifiers[var4_4 - 1][var5_5 + 1]);
                            }
                        }
                        if (var4_4 < var2_2) {
                            if (var5_5 > 0) {
                                var1_1.add(this.identifiers[var4_4 + 1][var5_5 - 1]);
                            }
                            if (var5_5 < var3_3) {
                                var1_1.add(this.identifiers[var4_4 + 1][var5_5 + 1]);
                            }
                        }
                        if (this.wrapRows) {
                            if (var4_4 == 0) {
                                if (var5_5 > 0) {
                                    var1_1.add(this.identifiers[var2_2][var5_5 - 1]);
                                }
                                if (var5_5 < var3_3) {
                                    var1_1.add(this.identifiers[var2_2][var5_5 + 1]);
                                }
                            } else if (var4_4 == var2_2) {
                                if (var5_5 > 0) {
                                    var1_1.add(this.identifiers[0][var5_5 - 1]);
                                }
                                if (var5_5 < var3_3) {
                                    var1_1.add(this.identifiers[0][var5_5 + 1]);
                                }
                            }
                        }
                        if (this.wrapColumns) {
                            if (var5_5 == 0) {
                                if (var4_4 > 0) {
                                    var1_1.add(this.identifiers[var4_4 - 1][var3_3]);
                                }
                                if (var4_4 < var2_2) {
                                    var1_1.add(this.identifiers[var4_4 + 1][var3_3]);
                                }
                            } else if (var5_5 == var3_3) {
                                if (var4_4 > 0) {
                                    var1_1.add(this.identifiers[var4_4 - 1][0]);
                                }
                                if (var4_4 < var2_2) {
                                    var1_1.add(this.identifiers[var4_4 + 1][0]);
                                }
                            }
                        }
                        if (!this.wrapRows || !this.wrapColumns) ** GOTO lbl71
                        if (var4_4 != 0 || var5_5 != 0) ** GOTO lbl60
                        var1_1.add(this.identifiers[var2_2][var3_3]);
                        ** GOTO lbl71
lbl60:
                        // 1 sources

                        if (var4_4 != 0 || var5_5 != var3_3) ** GOTO lbl64
                        var1_1.add(this.identifiers[var2_2][0]);
                        ** GOTO lbl71
lbl64:
                        // 1 sources

                        if (var4_4 != var2_2 || var5_5 != 0) ** GOTO lbl68
                        var1_1.add(this.identifiers[0][var3_3]);
                        ** GOTO lbl71
lbl68:
                        // 1 sources

                        if (var4_4 == var2_2 && var5_5 == var3_3) {
                            var1_1.add(this.identifiers[0][0]);
                        }
                    }
lbl71:
                    // 8 sources

                    case 2: {
                        if (var4_4 > 0) {
                            var1_1.add(this.identifiers[var4_4 - 1][var5_5]);
                        }
                        if (var4_4 < var2_2) {
                            var1_1.add(this.identifiers[var4_4 + 1][var5_5]);
                        }
                        if (this.wrapRows) {
                            if (var4_4 == 0) {
                                var1_1.add(this.identifiers[var2_2][var5_5]);
                            } else if (var4_4 == var2_2) {
                                var1_1.add(this.identifiers[0][var5_5]);
                            }
                        }
                        if (var5_5 > 0) {
                            var1_1.add(this.identifiers[var4_4][var5_5 - 1]);
                        }
                        if (var5_5 < var3_3) {
                            var1_1.add(this.identifiers[var4_4][var5_5 + 1]);
                        }
                        if (!this.wrapColumns) break;
                        if (var5_5 == 0) {
                            var1_1.add(this.identifiers[var4_4][var3_3]);
                            break;
                        }
                        if (var5_5 != var3_3) break;
                        var1_1.add(this.identifiers[var4_4][0]);
                        break;
                    }
                    default: {
                        throw new MathInternalError();
                    }
                }
                var6_6 = this.network.getNeuron(this.identifiers[var4_4][var5_5]);
                var7_7 = var1_1.iterator();
                while (var7_7.hasNext()) {
                    var8_8 = (Long)var7_7.next();
                    var10_9 = this.network.getNeuron(var8_8);
                    this.network.addLink(var6_6, var10_9);
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        double[][][] dArray = new double[this.numberOfRows][this.numberOfColumns][];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                dArray[i][j] = this.getNeuron(i, j).getFeatures();
            }
        }
        return new SerializationProxy(this.wrapRows, this.wrapColumns, this.neighbourhood, dArray);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 20130226L;
        private final boolean wrapRows;
        private final boolean wrapColumns;
        private final SquareNeighbourhood neighbourhood;
        private final double[][][] featuresList;

        SerializationProxy(boolean bl, boolean bl2, SquareNeighbourhood squareNeighbourhood, double[][][] dArray) {
            this.wrapRows = bl;
            this.wrapColumns = bl2;
            this.neighbourhood = squareNeighbourhood;
            this.featuresList = dArray;
        }

        private Object readResolve() {
            return new NeuronSquareMesh2D(this.wrapRows, this.wrapColumns, this.neighbourhood, this.featuresList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalDirection {
        UP,
        CENTER,
        DOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalDirection {
        RIGHT,
        CENTER,
        LEFT;

    }
}

