/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitHistogram
implements MapDataVisualization {
    private final DistanceMeasure distance;
    private final boolean normalizeCount;

    public HitHistogram(boolean bl, DistanceMeasure distanceMeasure) {
        this.normalizeCount = bl;
        this.distance = distanceMeasure;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D, Iterable<double[]> iterable) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        LocationFinder locationFinder = new LocationFinder(neuronSquareMesh2D);
        int n3 = 0;
        double[][] dArray = new double[n][n2];
        for (double[] dArray2 : iterable) {
            Neuron neuron = MapUtils.findBest(dArray2, neuronSquareMesh2D, this.distance);
            LocationFinder.Location location = locationFinder.getLocation(neuron);
            int n4 = location.getRow();
            int n5 = location.getColumn();
            double[] dArray3 = dArray[n4];
            int n6 = n5;
            dArray3[n6] = dArray3[n6] + 1.0;
            ++n3;
        }
        if (this.normalizeCount) {
            for (int i = 0; i < n; ++i) {
                int n7 = 0;
                while (n7 < n2) {
                    double[] dArray4 = dArray[i];
                    int n8 = n7++;
                    dArray4[n8] = dArray4[n8] / (double)n3;
                }
            }
        }
        return dArray;
    }
}

