/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;

public class LocationFinder {
    private final Map<Long, Location> locations = new HashMap<Long, Location>();

    public LocationFinder(NeuronSquareMesh2D neuronSquareMesh2D) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Long l = neuronSquareMesh2D.getNeuron(i, j).getIdentifier();
                if (this.locations.get(l) != null) {
                    throw new MathIllegalStateException();
                }
                this.locations.put(l, new Location(i, j));
            }
        }
    }

    public Location getLocation(Neuron neuron) {
        return this.locations.get(neuron.getIdentifier());
    }

    public static class Location {
        private final int row;
        private final int column;

        public Location(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

