/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import java.util.Collection;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapVisualization;

public class UnifiedDistanceMatrix
implements MapVisualization {
    private final boolean individualDistances;
    private final DistanceMeasure distance;

    public UnifiedDistanceMatrix(boolean bl, DistanceMeasure distanceMeasure) {
        this.individualDistances = bl;
        this.distance = distanceMeasure;
    }

    public double[][] computeImage(NeuronSquareMesh2D neuronSquareMesh2D) {
        if (this.individualDistances) {
            return this.individualDistances(neuronSquareMesh2D);
        }
        return this.averageDistances(neuronSquareMesh2D);
    }

    private double[][] individualDistances(NeuronSquareMesh2D neuronSquareMesh2D) {
        Neuron neuron;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = neuronSquareMesh2D.getNumberOfRows();
        int n6 = neuronSquareMesh2D.getNumberOfColumns();
        double[][] dArray = new double[n5 * 2 + 1][n6 * 2 + 1];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 2 * n4 + 1;
            for (n2 = 0; n2 < n6; ++n2) {
                n = 2 * n2 + 1;
                object = neuronSquareMesh2D.getNeuron(n4, n2).getFeatures();
                neuron = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER);
                if (neuron != null) {
                    dArray[n3][n + 1] = this.distance.compute((double[])object, neuron.getFeatures());
                }
                if ((neuron = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN)) == null) continue;
                dArray[n3 + 1][n] = this.distance.compute((double[])object, neuron.getFeatures());
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 2 * n4 + 1;
            for (n2 = 0; n2 < n6; ++n2) {
                n = 2 * n2 + 1;
                object = neuronSquareMesh2D.getNeuron(n4, n2);
                neuron = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER);
                Neuron neuron2 = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN);
                Neuron neuron3 = neuronSquareMesh2D.getNeuron(n4, n2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.DOWN);
                double d = neuron3 == null ? 0.0 : this.distance.compute(((Neuron)object).getFeatures(), neuron3.getFeatures());
                double d2 = neuron == null || neuron2 == null ? 0.0 : this.distance.compute(neuron.getFeatures(), neuron2.getFeatures());
                dArray[n3 + 1][n + 1] = 0.5 * (d + d2);
            }
        }
        n4 = dArray.length - 1;
        dArray[0] = dArray[n4];
        n3 = dArray[0].length - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            dArray[n2][0] = dArray[n2][n3];
        }
        return dArray;
    }

    private double[][] averageDistances(NeuronSquareMesh2D neuronSquareMesh2D) {
        int n = neuronSquareMesh2D.getNumberOfRows();
        int n2 = neuronSquareMesh2D.getNumberOfColumns();
        double[][] dArray = new double[n][n2];
        Network network = neuronSquareMesh2D.getNetwork();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Neuron neuron = neuronSquareMesh2D.getNeuron(i, j);
                Collection<Neuron> collection = network.getNeighbours(neuron);
                double[] dArray2 = neuron.getFeatures();
                double d = 0.0;
                int n3 = 0;
                for (Neuron neuron2 : collection) {
                    ++n3;
                    d += this.distance.compute(dArray2, neuron2.getFeatures());
                }
                dArray[i][j] = d / (double)n3;
            }
        }
        return dArray;
    }
}

