/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.FirstOrderFieldIntegrator;
import org.apache.commons.math3.ode.events.FieldEventHandler;
import org.apache.commons.math3.ode.events.FieldEventState;
import org.apache.commons.math3.ode.sampling.AbstractFieldStepInterpolator;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.IntegerSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldIntegrator<T extends RealFieldElement<T>>
implements FirstOrderFieldIntegrator<T> {
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-14;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 1.0E-15;
    private Collection<FieldStepHandler<T>> stepHandlers;
    private FieldODEStateAndDerivative<T> stepStart;
    private T stepSize;
    private boolean isLastStep;
    private boolean resetOccurred;
    private final Field<T> field;
    private Collection<FieldEventState<T>> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private IntegerSequence.Incrementor evaluations;
    private transient FieldExpandableODE<T> equations;

    protected AbstractFieldIntegrator(Field<T> field, String string) {
        this.field = field;
        this.name = string;
        this.stepHandlers = new ArrayList<FieldStepHandler<T>>();
        this.stepStart = null;
        this.stepSize = null;
        this.eventsStates = new ArrayList<FieldEventState<T>>();
        this.statesInitialized = false;
        this.evaluations = IntegerSequence.Incrementor.create().withMaximalCount(Integer.MAX_VALUE);
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(FieldStepHandler<T> fieldStepHandler) {
        this.stepHandlers.add(fieldStepHandler);
    }

    @Override
    public Collection<FieldStepHandler<T>> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(FieldEventHandler<T> fieldEventHandler, double d, double d2, int n) {
        this.addEventHandler(fieldEventHandler, d, d2, n, new FieldBracketingNthOrderBrentSolver<RealFieldElement>((RealFieldElement)((RealFieldElement)this.field.getZero()).add(1.0E-14), (RealFieldElement)((RealFieldElement)this.field.getZero()).add(d2), (RealFieldElement)((RealFieldElement)this.field.getZero()).add(1.0E-15), 5));
    }

    @Override
    public void addEventHandler(FieldEventHandler<T> fieldEventHandler, double d, double d2, int n, BracketedRealFieldUnivariateSolver<T> bracketedRealFieldUnivariateSolver) {
        this.eventsStates.add(new FieldEventState<RealFieldElement>(fieldEventHandler, d, (RealFieldElement)((RealFieldElement)this.field.getZero()).add(d2), n, bracketedRealFieldUnivariateSolver));
    }

    @Override
    public Collection<FieldEventHandler<T>> getEventHandlers() {
        ArrayList<FieldEventHandler<T>> arrayList = new ArrayList<FieldEventHandler<T>>(this.eventsStates.size());
        for (FieldEventState<T> fieldEventState : this.eventsStates) {
            arrayList.add(fieldEventState.getEventHandler());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    @Override
    public FieldODEStateAndDerivative<T> getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public T getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int n) {
        this.evaluations = this.evaluations.withMaximalCount(n < 0 ? Integer.MAX_VALUE : n);
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    protected FieldODEStateAndDerivative<T> initIntegration(FieldExpandableODE<T> fieldExpandableODE, T t, T[] TArray, T t2) {
        this.equations = fieldExpandableODE;
        this.evaluations = this.evaluations.withStart(0);
        fieldExpandableODE.init((RealFieldElement)t, (RealFieldElement[])TArray, (RealFieldElement)t2);
        RealFieldElement[] realFieldElementArray = this.computeDerivatives((RealFieldElement)t, (RealFieldElement[])TArray);
        FieldODEStateAndDerivative fieldODEStateAndDerivative = new FieldODEStateAndDerivative(t, TArray, realFieldElementArray);
        for (FieldEventState<T> object : this.eventsStates) {
            object.getEventHandler().init(fieldODEStateAndDerivative, t2);
        }
        for (FieldStepHandler fieldStepHandler : this.stepHandlers) {
            fieldStepHandler.init(fieldODEStateAndDerivative, t2);
        }
        this.setStateInitialized(false);
        return fieldODEStateAndDerivative;
    }

    protected FieldExpandableODE<T> getEquations() {
        return this.equations;
    }

    protected IntegerSequence.Incrementor getEvaluationsCounter() {
        return this.evaluations;
    }

    public T[] computeDerivatives(T t, T[] TArray) {
        this.evaluations.increment();
        return this.equations.computeDerivatives((RealFieldElement)t, (RealFieldElement[])TArray);
    }

    protected void setStateInitialized(boolean bl) {
        this.statesInitialized = bl;
    }

    protected FieldODEStateAndDerivative<T> acceptStep(AbstractFieldStepInterpolator<T> abstractFieldStepInterpolator, T t) {
        FieldODEStateAndDerivative<T> fieldODEStateAndDerivative = abstractFieldStepInterpolator.getGlobalPreviousState();
        FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2 = abstractFieldStepInterpolator.getGlobalCurrentState();
        if (!this.statesInitialized) {
            for (FieldEventState<T> object2 : this.eventsStates) {
                object2.reinitializeBegin(abstractFieldStepInterpolator);
            }
            this.statesInitialized = true;
        }
        final int n = abstractFieldStepInterpolator.isForward() ? 1 : -1;
        TreeSet<FieldEventState> treeSet = new TreeSet<FieldEventState>(new Comparator<FieldEventState<T>>(){

            @Override
            public int compare(FieldEventState<T> fieldEventState, FieldEventState<T> fieldEventState2) {
                return n * Double.compare(fieldEventState.getEventTime().getReal(), fieldEventState2.getEventTime().getReal());
            }
        });
        for (FieldEventState<T> fieldEventState : this.eventsStates) {
            if (!fieldEventState.evaluateStep(abstractFieldStepInterpolator)) continue;
            treeSet.add(fieldEventState);
        }
        AbstractFieldStepInterpolator abstractFieldStepInterpolator2 = abstractFieldStepInterpolator;
        while (!treeSet.isEmpty()) {
            Iterator iterator = treeSet.iterator();
            FieldEventState fieldEventState = (FieldEventState)iterator.next();
            iterator.remove();
            FieldODEStateAndDerivative fieldODEStateAndDerivative3 = abstractFieldStepInterpolator2.getInterpolatedState(fieldEventState.getEventTime());
            abstractFieldStepInterpolator2 = abstractFieldStepInterpolator2.restrictStep(fieldODEStateAndDerivative, fieldODEStateAndDerivative3);
            for (FieldEventState fieldEventState2 : this.eventsStates) {
                fieldEventState2.stepAccepted(fieldODEStateAndDerivative3);
                this.isLastStep = this.isLastStep || fieldEventState2.stop();
            }
            for (FieldStepHandler fieldStepHandler : this.stepHandlers) {
                fieldStepHandler.handleStep(abstractFieldStepInterpolator2, this.isLastStep);
            }
            if (this.isLastStep) {
                return fieldODEStateAndDerivative3;
            }
            FieldODEState<T> fieldODEState = null;
            this.resetOccurred = false;
            for (FieldEventState fieldEventState3 : this.eventsStates) {
                fieldODEState = fieldEventState3.reset(fieldODEStateAndDerivative3);
                if (fieldODEState == null) continue;
                RealFieldElement[] realFieldElementArray = this.equations.getMapper().mapState(fieldODEState);
                RealFieldElement[] realFieldElementArray2 = this.computeDerivatives((RealFieldElement)fieldODEState.getTime(), realFieldElementArray);
                this.resetOccurred = true;
                return this.equations.getMapper().mapStateAndDerivative((RealFieldElement)fieldODEState.getTime(), realFieldElementArray, realFieldElementArray2);
            }
            fieldODEStateAndDerivative = fieldODEStateAndDerivative3;
            if (!fieldEventState.evaluateStep(abstractFieldStepInterpolator2 = abstractFieldStepInterpolator2.restrictStep(fieldODEStateAndDerivative3, fieldODEStateAndDerivative2))) continue;
            treeSet.add(fieldEventState);
        }
        for (FieldEventState<T> fieldEventState : this.eventsStates) {
            fieldEventState.stepAccepted(fieldODEStateAndDerivative2);
            this.isLastStep = this.isLastStep || fieldEventState.stop();
        }
        this.isLastStep = this.isLastStep || ((RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative2.getTime().subtract(t)).abs()).getReal() <= FastMath.ulp(t.getReal());
        for (FieldStepHandler fieldStepHandler : this.stepHandlers) {
            fieldStepHandler.handleStep(abstractFieldStepInterpolator2, this.isLastStep);
        }
        return fieldODEStateAndDerivative2;
    }

    protected void sanityChecks(FieldODEState<T> fieldODEState, T t) {
        double d = 1000.0 * FastMath.ulp(FastMath.max(FastMath.abs(fieldODEState.getTime().getReal()), FastMath.abs(t.getReal())));
        double d2 = ((RealFieldElement)((RealFieldElement)fieldODEState.getTime().subtract(t)).abs()).getReal();
        if (d2 <= d) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.TOO_SMALL_INTEGRATION_INTERVAL, (Number)d2, d, false);
        }
    }

    protected boolean resetOccurred() {
        return this.resetOccurred;
    }

    protected void setStepSize(T t) {
        this.stepSize = t;
    }

    protected T getStepSize() {
        return this.stepSize;
    }

    protected void setStepStart(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative) {
        this.stepStart = fieldODEStateAndDerivative;
    }

    protected FieldODEStateAndDerivative<T> getStepStart() {
        return this.stepStart;
    }

    protected void setIsLastStep(boolean bl) {
        this.isLastStep = bl;
    }

    protected boolean isLastStep() {
        return this.isLastStep;
    }
}

