/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.sampling.FieldStepHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousOutputFieldModel<T extends RealFieldElement<T>>
implements FieldStepHandler<T> {
    private T initialTime = null;
    private T finalTime = null;
    private boolean forward = true;
    private int index = 0;
    private List<FieldStepInterpolator<T>> steps = new ArrayList<FieldStepInterpolator<T>>();

    public void append(ContinuousOutputFieldModel<T> continuousOutputFieldModel) {
        if (continuousOutputFieldModel.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = continuousOutputFieldModel.initialTime;
            this.forward = continuousOutputFieldModel.forward;
        } else {
            FieldODEStateAndDerivative<T> fieldODEStateAndDerivative = this.steps.get(0).getPreviousState();
            FieldODEStateAndDerivative<T> object = continuousOutputFieldModel.steps.get(0).getPreviousState();
            this.checkDimensionsEquality(fieldODEStateAndDerivative.getStateDimension(), object.getStateDimension());
            this.checkDimensionsEquality(fieldODEStateAndDerivative.getNumberOfSecondaryStates(), object.getNumberOfSecondaryStates());
            for (int i = 0; i < fieldODEStateAndDerivative.getNumberOfSecondaryStates(); ++i) {
                this.checkDimensionsEquality(fieldODEStateAndDerivative.getSecondaryStateDimension(i), object.getSecondaryStateDimension(i));
            }
            if (this.forward ^ continuousOutputFieldModel.forward) {
                throw new MathIllegalArgumentException(LocalizedFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            FieldStepInterpolator<T> fieldStepInterpolator = this.steps.get(this.index);
            Object t = fieldStepInterpolator.getCurrentState().getTime();
            Object t2 = fieldStepInterpolator.getPreviousState().getTime();
            RealFieldElement realFieldElement = (RealFieldElement)t.subtract(t2);
            RealFieldElement realFieldElement2 = (RealFieldElement)continuousOutputFieldModel.getInitialTime().subtract(t);
            if (((RealFieldElement)((RealFieldElement)realFieldElement2.abs()).subtract(((RealFieldElement)realFieldElement.abs()).multiply(0.001))).getReal() > 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, ((RealFieldElement)realFieldElement2.abs()).getReal());
            }
        }
        for (FieldStepInterpolator fieldStepInterpolator : continuousOutputFieldModel.steps) {
            this.steps.add(fieldStepInterpolator);
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentState().getTime();
    }

    private void checkDimensionsEquality(int n, int n2) {
        if (n != n2) {
            throw new DimensionMismatchException(n2, n);
        }
    }

    @Override
    public void init(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, T t) {
        this.initialTime = fieldODEStateAndDerivative.getTime();
        this.finalTime = t;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    @Override
    public void handleStep(FieldStepInterpolator<T> fieldStepInterpolator, boolean bl) {
        if (this.steps.size() == 0) {
            this.initialTime = fieldStepInterpolator.getPreviousState().getTime();
            this.forward = fieldStepInterpolator.isForward();
        }
        this.steps.add(fieldStepInterpolator);
        if (bl) {
            this.finalTime = fieldStepInterpolator.getCurrentState().getTime();
            this.index = this.steps.size() - 1;
        }
    }

    public T getInitialTime() {
        return this.initialTime;
    }

    public T getFinalTime() {
        return this.finalTime;
    }

    public FieldODEStateAndDerivative<T> getInterpolatedState(T realFieldElement) {
        int n = 0;
        FieldStepInterpolator<T> fieldStepInterpolator = this.steps.get(n);
        RealFieldElement realFieldElement2 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator.getPreviousState().getTime().add(fieldStepInterpolator.getCurrentState().getTime())).multiply(0.5);
        int n2 = this.steps.size() - 1;
        FieldStepInterpolator<T> fieldStepInterpolator2 = this.steps.get(n2);
        RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator2.getPreviousState().getTime().add(fieldStepInterpolator2.getCurrentState().getTime())).multiply(0.5);
        if (this.locatePoint(realFieldElement, fieldStepInterpolator) <= 0) {
            this.index = n;
            return fieldStepInterpolator.getInterpolatedState(realFieldElement);
        }
        if (this.locatePoint(realFieldElement, fieldStepInterpolator2) >= 0) {
            this.index = n2;
            return fieldStepInterpolator2.getInterpolatedState(realFieldElement);
        }
        while (n2 - n > 5) {
            FieldStepInterpolator<T> fieldStepInterpolator3 = this.steps.get(this.index);
            int n3 = this.locatePoint(realFieldElement, fieldStepInterpolator3);
            if (n3 < 0) {
                n2 = this.index;
                realFieldElement3 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator3.getPreviousState().getTime().add(fieldStepInterpolator3.getCurrentState().getTime())).multiply(0.5);
            } else if (n3 > 0) {
                n = this.index;
                realFieldElement2 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator3.getPreviousState().getTime().add(fieldStepInterpolator3.getCurrentState().getTime())).multiply(0.5);
            } else {
                return fieldStepInterpolator3.getInterpolatedState(realFieldElement);
            }
            int n4 = (n + n2) / 2;
            FieldStepInterpolator<T> fieldStepInterpolator4 = this.steps.get(n4);
            RealFieldElement realFieldElement4 = (RealFieldElement)((RealFieldElement)fieldStepInterpolator4.getPreviousState().getTime().add(fieldStepInterpolator4.getCurrentState().getTime())).multiply(0.5);
            if (((RealFieldElement)((RealFieldElement)realFieldElement4.subtract(realFieldElement2).abs()).subtract(1.0E-6)).getReal() < 0.0 || ((RealFieldElement)((RealFieldElement)realFieldElement3.subtract(realFieldElement4).abs()).subtract(1.0E-6)).getReal() < 0.0) {
                this.index = n4;
            } else {
                RealFieldElement realFieldElement5 = realFieldElement3.subtract(realFieldElement4);
                RealFieldElement realFieldElement6 = realFieldElement4.subtract(realFieldElement2);
                RealFieldElement realFieldElement7 = realFieldElement3.subtract(realFieldElement2);
                RealFieldElement realFieldElement8 = realFieldElement.subtract((RealFieldElement)realFieldElement3);
                RealFieldElement realFieldElement9 = realFieldElement.subtract((RealFieldElement)realFieldElement4);
                RealFieldElement realFieldElement10 = realFieldElement.subtract((RealFieldElement)realFieldElement2);
                RealFieldElement realFieldElement11 = ((RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement9.multiply(realFieldElement10).multiply(realFieldElement6).multiply(n2)).subtract(realFieldElement8.multiply(realFieldElement10).multiply(realFieldElement7).multiply(n4))).add(realFieldElement8.multiply(realFieldElement9).multiply(realFieldElement5).multiply(n))).divide(realFieldElement5.multiply(realFieldElement6).multiply(realFieldElement7));
                this.index = (int)FastMath.rint(realFieldElement11.getReal());
            }
            int n5 = FastMath.max(n + 1, (9 * n + n2) / 10);
            int n6 = FastMath.min(n2 - 1, (n + 9 * n2) / 10);
            if (this.index < n5) {
                this.index = n5;
                continue;
            }
            if (this.index <= n6) continue;
            this.index = n6;
        }
        this.index = n;
        while (this.index <= n2 && this.locatePoint(realFieldElement, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        return this.steps.get(this.index).getInterpolatedState(realFieldElement);
    }

    private int locatePoint(T t, FieldStepInterpolator<T> fieldStepInterpolator) {
        if (this.forward) {
            if (((RealFieldElement)t.subtract(fieldStepInterpolator.getPreviousState().getTime())).getReal() < 0.0) {
                return -1;
            }
            if (((RealFieldElement)t.subtract(fieldStepInterpolator.getCurrentState().getTime())).getReal() > 0.0) {
                return 1;
            }
            return 0;
        }
        if (((RealFieldElement)t.subtract(fieldStepInterpolator.getPreviousState().getTime())).getReal() > 0.0) {
            return -1;
        }
        if (((RealFieldElement)t.subtract(fieldStepInterpolator.getCurrentState().getTime())).getReal() < 0.0) {
            return 1;
        }
        return 0;
    }
}

