/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class ContinuousOutputModel
implements StepHandler,
Serializable {
    private static final long serialVersionUID = -1417964919405031606L;
    private double initialTime;
    private double finalTime;
    private boolean forward = true;
    private int index = 0;
    private List<StepInterpolator> steps = new ArrayList<StepInterpolator>();

    public ContinuousOutputModel() {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
    }

    public void append(ContinuousOutputModel continuousOutputModel) {
        if (continuousOutputModel.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = continuousOutputModel.initialTime;
            this.forward = continuousOutputModel.forward;
        } else {
            if (this.getInterpolatedState().length != continuousOutputModel.getInterpolatedState().length) {
                throw new DimensionMismatchException(continuousOutputModel.getInterpolatedState().length, this.getInterpolatedState().length);
            }
            if (this.forward ^ continuousOutputModel.forward) {
                throw new MathIllegalArgumentException(LocalizedFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            StepInterpolator stepInterpolator = this.steps.get(this.index);
            double d = stepInterpolator.getCurrentTime();
            double d2 = stepInterpolator.getPreviousTime();
            double d3 = d - d2;
            double d4 = continuousOutputModel.getInitialTime() - d;
            if (FastMath.abs(d4) > 0.001 * FastMath.abs(d3)) {
                throw new MathIllegalArgumentException(LocalizedFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, FastMath.abs(d4));
            }
        }
        for (StepInterpolator stepInterpolator : continuousOutputModel.steps) {
            this.steps.add(stepInterpolator.copy());
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentTime();
    }

    public void init(double d, double[] dArray, double d2) {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    public void handleStep(StepInterpolator stepInterpolator, boolean bl) {
        if (this.steps.size() == 0) {
            this.initialTime = stepInterpolator.getPreviousTime();
            this.forward = stepInterpolator.isForward();
        }
        this.steps.add(stepInterpolator.copy());
        if (bl) {
            this.finalTime = stepInterpolator.getCurrentTime();
            this.index = this.steps.size() - 1;
        }
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getFinalTime() {
        return this.finalTime;
    }

    public double getInterpolatedTime() {
        return this.steps.get(this.index).getInterpolatedTime();
    }

    public void setInterpolatedTime(double d) {
        int n = 0;
        StepInterpolator stepInterpolator = this.steps.get(n);
        double d2 = 0.5 * (stepInterpolator.getPreviousTime() + stepInterpolator.getCurrentTime());
        int n2 = this.steps.size() - 1;
        StepInterpolator stepInterpolator2 = this.steps.get(n2);
        double d3 = 0.5 * (stepInterpolator2.getPreviousTime() + stepInterpolator2.getCurrentTime());
        if (this.locatePoint(d, stepInterpolator) <= 0) {
            this.index = n;
            stepInterpolator.setInterpolatedTime(d);
            return;
        }
        if (this.locatePoint(d, stepInterpolator2) >= 0) {
            this.index = n2;
            stepInterpolator2.setInterpolatedTime(d);
            return;
        }
        while (n2 - n > 5) {
            StepInterpolator stepInterpolator3 = this.steps.get(this.index);
            int n3 = this.locatePoint(d, stepInterpolator3);
            if (n3 < 0) {
                n2 = this.index;
                d3 = 0.5 * (stepInterpolator3.getPreviousTime() + stepInterpolator3.getCurrentTime());
            } else if (n3 > 0) {
                n = this.index;
                d2 = 0.5 * (stepInterpolator3.getPreviousTime() + stepInterpolator3.getCurrentTime());
            } else {
                stepInterpolator3.setInterpolatedTime(d);
                return;
            }
            int n4 = (n + n2) / 2;
            StepInterpolator stepInterpolator4 = this.steps.get(n4);
            double d4 = 0.5 * (stepInterpolator4.getPreviousTime() + stepInterpolator4.getCurrentTime());
            if (FastMath.abs(d4 - d2) < 1.0E-6 || FastMath.abs(d3 - d4) < 1.0E-6) {
                this.index = n4;
            } else {
                double d5 = d3 - d4;
                double d6 = d4 - d2;
                double d7 = d3 - d2;
                double d8 = d - d3;
                double d9 = d - d4;
                double d10 = d - d2;
                double d11 = (d9 * d10 * d6 * (double)n2 - d8 * d10 * d7 * (double)n4 + d8 * d9 * d5 * (double)n) / (d5 * d6 * d7);
                this.index = (int)FastMath.rint(d11);
            }
            int n5 = FastMath.max(n + 1, (9 * n + n2) / 10);
            int n6 = FastMath.min(n2 - 1, (n + 9 * n2) / 10);
            if (this.index < n5) {
                this.index = n5;
                continue;
            }
            if (this.index <= n6) continue;
            this.index = n6;
        }
        this.index = n;
        while (this.index <= n2 && this.locatePoint(d, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        this.steps.get(this.index).setInterpolatedTime(d);
    }

    public double[] getInterpolatedState() {
        return this.steps.get(this.index).getInterpolatedState();
    }

    public double[] getInterpolatedDerivatives() {
        return this.steps.get(this.index).getInterpolatedDerivatives();
    }

    public double[] getInterpolatedSecondaryState(int n) {
        return this.steps.get(this.index).getInterpolatedSecondaryState(n);
    }

    public double[] getInterpolatedSecondaryDerivatives(int n) {
        return this.steps.get(this.index).getInterpolatedSecondaryDerivatives(n);
    }

    private int locatePoint(double d, StepInterpolator stepInterpolator) {
        if (this.forward) {
            if (d < stepInterpolator.getPreviousTime()) {
                return -1;
            }
            if (d > stepInterpolator.getCurrentTime()) {
                return 1;
            }
            return 0;
        }
        if (d > stepInterpolator.getPreviousTime()) {
            return -1;
        }
        if (d < stepInterpolator.getCurrentTime()) {
            return 1;
        }
        return 0;
    }
}

